/*
 * Copyright (c) 2014, 2016, Oracle and/or its affiliates. All rights reserved.
 *
 * This software is dual-licensed to you under the MIT License (MIT) and the
 * Universal Permissive License (UPL). See the LICENSE file in the root
 * directory for license terms. You may choose either license, or both.
 */
package com.oracle.iot.sample.daf.type.pulseoximeter;

import oracle.iot.module.IoTExport;
import com.oracle.iot.sample.daf.type.heartratemonitor.HeartRateMonitorEndpoint;

/**
 * {@code PulseOximeter} represented as a {@code DeviceEndpoint}.
 * <p>
 * Concrete implementation is responsible for sending
 * {@link PulseOximeterEvent PulseOximeterEvents}.
 *
 * @see PulseOximeter
 * @see oracle.iot.device.DeviceEndpoint
 */
@IoTExport
public interface PulseOximeterEndpoint extends PulseOximeter, HeartRateMonitorEndpoint {
}
