/*
 * Copyright (c) 2014, 2016, Oracle and/or its affiliates. All rights reserved.
 *
 * This software is dual-licensed to you under the MIT License (MIT) and the
 * Universal Permissive License (UPL).  See the LICENSE file in the root
 * directory for license terms.  You may choose either license, or both.
 */
package com.oracle.iot.sample.daf.type.pulseoximeter;

import oracle.iot.device.DeviceModel;
import oracle.iot.module.IoTExport;
import oracle.iot.device.attribute.ReadOnlyDeviceAttribute;
import oracle.iot.messaging.IoTResource;

/**
 * Pulse oximeter, also referred as oximeter, provides noninvasive measurement of functional oxygen of arterial
 * haemoglobin. It is measured from a light signal interacting with tissue.
 */
@IoTExport
@DeviceModel(name = "urn:com:oracle:iot:device:pulse_oximeter")
public interface PulseOximeter {

    /**
     * Oxygen saturation (SpO<sub>2</sub>) refers to the concentration of oxygen in the blood. It is measured in
     * percents (%). Normal blood oxygen levels in humans are considered 95% - 100%.
     * @return the property describing the oxygen saturation
     */
    @IoTResource
    ReadOnlyDeviceAttribute<Float> oxygenSaturationProperty();

    Float getOxygenSaturation();

    /**
     * Heart rate refers to speed of the heart beat. It is measured in beats per minute (bpm). Normal human heart rate
     * is between 60 - 100 bpm.
     * @return the property describing the heart rate
     */
    @IoTResource
    ReadOnlyDeviceAttribute<Integer> heartRateProperty();

    Integer getHeartRate();
}
