/*
 * Copyright (c) 2015, 2016, Oracle and/or its affiliates. All rights reserved.
 *
 * This software is dual-licensed to you under the MIT License (MIT) and the
 * Universal Permissive License (UPL). See the LICENSE file in the root
 * directory for license terms. You may choose either license, or both.
 */
package com.oracle.iot.sample.daf.type.bodyweightscale;

import oracle.iot.device.DeviceEndpoint;
import oracle.iot.device.DeviceModel;
import oracle.iot.module.IoTExport;

/**
 * {@code BodyWeightScale} device represented as a {@code DeviceEndpoint}.
 * <p>
 * Concrete implementation is responsible for sending
 * {@link BodyWeightScaleEvent BodyWeightScaleEvents}.
 *
 * @see BodyWeightScale
 * @see oracle.iot.device.DeviceEndpoint
 */
@IoTExport
@DeviceModel(name = "BodyWeightScale")
public interface BodyWeightScaleEndpoint extends BodyWeightScale, DeviceEndpoint {
}
