/*
 * Copyright (c) 2014, 2016, Oracle and/or its affiliates. All rights reserved.
 *
 * This software is dual-licensed to you under the MIT License (MIT) and the
 * Universal Permissive License (UPL). See the LICENSE file in the root
 * directory for license terms. You may choose either license, or both.
 */

package com.oracle.iot.sample.daf.type.bloodpressuremonitor;

import oracle.iot.device.Device;
import oracle.iot.device.DeviceModel;
import oracle.iot.module.IoTExport;
import oracle.iot.device.attribute.ReadOnlyDeviceAttribute;
import oracle.iot.messaging.IoTResource;

/**
 * Provides measurement of systolic and diastolic blood pressure and heart
 * beat rate.
 */
@IoTExport
@DeviceModel(name = "urn:com:oracle:iot:device:blood_pressure_monitor")
public interface BloodPressureMonitor extends Device {

    /**
     * Systolic (maximum) blood pressure measured in millimetres of mercury (mm Hg)
     * over normal atmospheric pressure (760 mm Hg).
     * @return The property describing the systolic pressure
     */
    @IoTResource
    ReadOnlyDeviceAttribute<Integer> systolicPressureProperty();

    Integer getSystolicPressure();

    /**
     * Diastolic (minimum) blood pressure measured in millimetres of mercury (mm Hg)
     * over normal atmospheric pressure (760 mm Hg).
     * @return The property describing the diastolic pressure
     */
    @IoTResource
    ReadOnlyDeviceAttribute<Integer> diastolicPressureProperty();

    Integer getDiastolicPressure();

    /**
     * Heart rate refers to speed of the heart beat. It is measured in beats per minute (bpm). Normal human heart rate
     * is between 60 - 100 bpm.
     * @return the property describing the heart rate
     */
    @IoTResource
    ReadOnlyDeviceAttribute<Integer> heartRateProperty();

    Integer getHeartRate();
}
