/*
 * Copyright (c) 2016, Oracle and/or its affiliates. All rights reserved.
 *
 * This software is dual-licensed to you under the MIT License (MIT) and the
 * Universal Permissive License (UPL). See the LICENSE file in the root
 * directory for license terms. You may choose either license, or both.
 */
package com.oracle.iot.sample.daf.type.eddystonebeacon;

import oracle.iot.device.Device;
import oracle.iot.device.DeviceModel;
import oracle.iot.module.IoTExport;
import oracle.iot.device.attribute.ReadOnlyDeviceAttribute;
import oracle.iot.messaging.IoTResource;

/**
 * Eddystone beacon provides:
 *    - Received signal strength (RSSI)
 *    - Transmission power (TxPower)
 *    - Battery Voltage
 *    - Temperature
 */
@IoTExport
@DeviceModel(name = "urn:com:oracle:iot:device:location:eddystone-tlm-uid")
public interface EddystoneBeacon extends Device {
    @IoTResource
    ReadOnlyDeviceAttribute<Float> ora_rssiProperty();
    
    @IoTResource
    ReadOnlyDeviceAttribute<Integer> ora_txPowerProperty();

    @IoTResource
    ReadOnlyDeviceAttribute<Float> batteryVoltageProperty();

    @IoTResource
    ReadOnlyDeviceAttribute<Float> temperatureProperty();
}
