/*
 * Copyright (c) 2014, 2016, Oracle and/or its affiliates. All rights reserved.
 *
 * This software is dual-licensed to you under the MIT License (MIT) and the
 * Universal Permissive License (UPL). See the LICENSE file in the root
 * directory for license terms. You may choose either license, or both.
 */

package com.oracle.iot.sample.adapter.bluetooth;


import oracle.iot.device.IoTDeviceAdapter;
import com.oracle.iot.sample.daf.adapter.bluetooth.AbstractBluetoothHealthAdapter;
import com.oracle.iot.sample.daf.adapter.health.PersonalHealthEndpoint;
import com.oracle.iot.sample.daf.adapter.health.PulseOximeterEndpoint;
import com.oracle.iot.sample.daf.adapter.health.BloodPressureMonitorEndpoint;
import com.oracle.iot.sample.daf.adapter.health.WeightScaleEndpoint;

import javax.inject.Inject;
import java.util.logging.Level;
import java.util.logging.Logger;

@IoTDeviceAdapter
public class BluetoothHealthAdapter extends AbstractBluetoothHealthAdapter {

    private static final boolean USE_SPOT_CHECK = true;

    /**
     * Creates a new instance of the {@code BluetoothHealthAdapter}.
     *
     * @param logger Logger associated with this endpoint.
     */
    @Inject
    public BluetoothHealthAdapter(Logger logger) {
        super(logger);
        logger.log(Level.FINE , "Bluetooth health adapter created.");
    }

    @Override
    protected void start() throws Exception {
        logger.log(Level.INFO, "Bluetooth health adapter started.");

        // create device handler mapping
        if(USE_SPOT_CHECK) {
            registerDeviceClass(PersonalHealthEndpoint.PULSE_OXIMETER, com.oracle.iot.sample.adapter.health.PulseOximeterEndpoint.class);
        } else {
            registerDeviceClass(PersonalHealthEndpoint.PULSE_OXIMETER, PulseOximeterEndpoint.class);
        }

        registerDeviceClass(PersonalHealthEndpoint.BLOOD_PRESSURE_MONITOR, BloodPressureMonitorEndpoint.class);
        registerDeviceClass(PersonalHealthEndpoint.WEIGHING_SCALE, WeightScaleEndpoint.class);
    }

    @Override
    protected void stop() throws Exception {
        logger.log(Level.INFO, "Bluetooth health adapter stopped.");
        unregisterDeviceClass(PersonalHealthEndpoint.PULSE_OXIMETER);
        unregisterDeviceClass(PersonalHealthEndpoint.BLOOD_PRESSURE_MONITOR);
        unregisterDeviceClass(PersonalHealthEndpoint.WEIGHING_SCALE);
    }
}
