# 
# Copyright (c) 2015, 2016, Oracle and/or its affiliates. All rights reserved.
#
# This software is dual-licensed to you under the MIT License (MIT) and the Universal Permissive License (UPL).  See the LICENSE file in the root directory for license terms.  You may choose
# either license, or both.
#

.print_openssl_src:
	@printf "Compile openssl source files...\n"

.clean_stored_folders:
	$(A)rm -rf $(OPENSSL)/lib/
	$(A)rm -rf $(OPENSSL)/include/

$(OPENSSL_LIBS): .clean_stored_folders $(OPENSSL)/$(OPENSSL_ARCH_FOLDER)/nmake.bat $(OPENSSL)/$(OPENSSL_ARCH_FOLDER)/unpacked
	$(A)mkdir -p $(dir $@)
	$(A)cd $(OPENSSL)/$(OPENSSL_ARCH_FOLDER); perl Configure VC-WIN32 no-asm
	$(A)cd $(OPENSSL)/$(OPENSSL_ARCH_FOLDER); chmod +x ms/do_ms.bat
	$(A)cd $(OPENSSL)/$(OPENSSL_ARCH_FOLDER); ./ms/do_ms.bat
	$(A)cd $(OPENSSL)/$(OPENSSL_ARCH_FOLDER); ./nmake.bat /nologo -f ms/nt.mak install
	$(A)cp -f $(OPENSSL)/$(OPENSSL_ARCH_FOLDER)/out32/*.lib $(OPENSSL)/lib/
	$(A)cp -r -f $(OPENSSL)/$(OPENSSL_ARCH_FOLDER)/inc32/ $(OPENSSL)/include/

$(OPENSSL)/$(OPENSSL_ARCH_FOLDER)/nmake.bat:
	$(A)mkdir -p $(dir $@)
	$(A)cd $(OPENSSL)/$(OPENSSL_ARCH_FOLDER); echo "set MAKE=" >nmake.bat
	$(A)cd $(OPENSSL)/$(OPENSSL_ARCH_FOLDER); echo "set MAKEFLAGS=" >>nmake.bat
	$(A)cd $(OPENSSL)/$(OPENSSL_ARCH_FOLDER); echo "$(A)call \"$(VS120COMNTOOLS)\vsvars32.bat\"" >>nmake.bat
	$(A)cd $(OPENSSL)/$(OPENSSL_ARCH_FOLDER); echo "$(A)nmake.exe %*" >>nmake.bat
	$(A)cd $(OPENSSL)/$(OPENSSL_ARCH_FOLDER); chmod +x nmake.bat

.windows_generate_tools_config:
	$(A)mkdir -p $(TMP_DIR)
	$(A)echo "$(A)call \"$(VS120COMNTOOLS)\vsvars32.bat\" & cl %*" >$(TMP_DIR)/cc.bat
	$(A)echo "$(A)call \"$(VS120COMNTOOLS)\vsvars32.bat\" & lib %*" >$(TMP_DIR)/ar.bat
	$(A)chmod +x $(TMP_DIR)/cc.bat $(TMP_DIR)/ar.bat

.windows_impl: .windows_generate_tools_config .print_openssl_src $(OPENSSL_LIBS)
	@printf "Openssl compilation finished!\n"
