# 
# Copyright (c) 2015, 2016, Oracle and/or its affiliates. All rights reserved.
#
# This software is dual-licensed to you under the MIT License (MIT) and the Universal Permissive License (UPL).  See the LICENSE file in the root directory for license terms.  You may choose
# either license, or both.
#

# windows source specific
# check source bundle path
ifneq ($(wildcard $(PROJ_DIR)/src), )
    ifeq ("$(wildcard $(WINDOWS_SRC_DIR))","")
	PORT_SRC_DIR=$(PROJ_DIR)/src/windows
    endif
else
# check sample bundle path
ifneq ($(wildcard $(PROJ_DIR)/samples/src), )
	PORT_SRC_DIR=$(PROJ_DIR)/samples/src
else
# check repo path
    ifneq ($(wildcard $(PROJ_DIR)/library), )
	PORT_SRC_DIR=$(PROJ_DIR)/library/port/windows
    endif
endif
endif

SAMPLE_EXT=.exe

_SAMPLE_RUNTIME_LIBS = \
	$(OPENSSL_LIBS)    \
	crypt32.lib        \
	Ws2_32.lib         \
	kernel32.lib       \
	user32.lib         \
	gdi32.lib          \
	winspool.lib       \
	comdlg32.lib       \
	advapi32.lib       \
	shell32.lib        \
	ole32.lib          \
	oleaut32.lib       \
	uuid.lib           \
	odbc32.lib         \
	odbccp32.lib

CFLAGS+=$(INCLUDE_OPT)$(OPENSSL)/include
CFLAGS+=/nologo /Gy /Gm- /errorReport:prompt /Oy- /Oi /MT
ifeq ($(DEBUG),true)
    CFLAGS+=/GS-
else
    CFLAGS+=/GL /O2 /analyze- /sdl
endif
CFLAGS+=/D_CRT_SECURE_NO_WARNINGS /D_CRT_SECURE_NO_DEPRECATE /D_CRT_NONONSTDC_NO_DEPRECATE /D_WINSOCK_DEPRECATED_NO_WARNINGS /wd4996 /wd4711
CFLAGS+=/Dsnprintf=_snprintf /Dstrcasecmp=_stricmp /Dstrnicmp=_strnicmp /Dstrncasecmp=_strnicmp /D__func__=__FUNCTION__

LDFLAGS+=/link /DYNAMICBASE /NOLOGO /INCREMENTAL /IGNORE:4711
LDLIBS=/LIBPATH:$(CURRENT_LIB_PATH) $(FULL_LIB_NAME) $(_SAMPLE_RUNTIME_LIBS)

include $(PORT_IMPLPATH)/windows.mk
include $(PORT_IMPLPATH)/download.mk

ifneq ($(CURRENT_SCS_SAMPLE),"")
	BUILD_STORAGE_SAMPLE_COMMAND=$(A)$(CC) $(CPPFLAGS) $(CPP_OPTS) $(CFLAGS) $(C_OPTS) $(CURRENT_SAMPLE_DIR)/$(CURRENT_SCS_SAMPLE).c \
		$(OBJECT_FILE_NAME_OPT)$(OUT_SAMPLE_PATH)/obj/ $(LDFLAGS) $(LD_OPTS) $(LDLIBS) \
		/out:$(OUT_SAMPLE_PATH)/$(CURRENT_SCS_SAMPLE)$(SAMPLE_EXT)
else
	BUILD_STORAGE_SAMPLE_COMMAND=
endif
# create sample
.smpl_impl: $(OPENSSL_LIBS)
	$(A)$(CC) $(CPPFLAGS) $(CPP_OPTS) $(CFLAGS) $(C_OPTS) $(CURRENT_SAMPLE_DIR)/$(CURRENT_SAMPLE).c \
		$(OBJECT_FILE_NAME_OPT)$(OUT_SAMPLE_PATH)/obj/ $(LDFLAGS) $(LD_OPTS) $(LDLIBS) \
		/out:$(OUT_SAMPLE_PATH)/$(CURRENT_SAMPLE)$(SAMPLE_EXT)
	$(BUILD_STORAGE_SAMPLE_COMMAND)

# build related targets
.pre_build: check_smpl .windows_generate_tools_config
	@printf "\nGenerate sample %s.c...\n" "$(CURRENT_SAMPLE_DIR)/$(CURRENT_SAMPLE)"
	$(A)mkdir -p $(OUT_SAMPLE_PATH)/obj
	$(A)mkdir -p $(dir $(OUT_SAMPLE_PATH)/$(CURRENT_SAMPLE))

.build_impl: print_conf print_smplconf .smpl_impl

.post_build:
	@printf "\n Sample %s%s is built !\n" "$(OUT_SAMPLE_PATH)/$(CURRENT_SAMPLE)" "$(SAMPLE_EXT)"

# clean related targets
.pre_clean:
	@printf "\nStart samples cleaning...\n"

.clean_impl:
	$(A)rm -rf $(OUTPUT_DIR)

.post_clean:
	@printf "Cleaning done !\n"

# configuration related targets
.print_smplconf_impl:
	@printf "  OPENSSL                   = %s\n" "$(OPENSSL)";     \
	printf "  OPENSSL_LIBS              = %s\n" "$(OPENSSL_LIBS)"; \
	printf "  OPENSSL_NAME              = %s\n" "$(OPENSSL_NAME)"; \
	printf "  OPENSSL_ARCH_FOLDER       = %s\n" "$(OPENSSL_ARCH_FOLDER)";

.check_impl: 
# check custom paths if set
	@$(if $(IOTCS_LIBRARY_PATH),                                         \
	    $(call CHECK_PATH, $(IOTCS_LIBRARY_PATH), $(IOTCS_HEADERS_PATH),Checking custom directories...) \
	)
# check source bundle directory
	$(call CHECK_PATH, $(EXP_SRC_LIB_PATH), $(EXP_SRC_HEADERS_PATH),Checking source bundle directories...)
# check binary bundle directory
	@$(if                                                                \
	    $(or                                                             \
		$(findstring "true true true true","$(MESSAGING_THREAD_SAFETY) $(MESSAGE_DISPATCHER) $(VIRTUALIZATION_SUPPORT) $(GATEWAY)"), \
		$(findstring "true true true false","$(MESSAGING_THREAD_SAFETY) $(MESSAGE_DISPATCHER) $(VIRTUALIZATION_SUPPORT) $(GATEWAY)") \
	    ),                                                               \
	    $(call CHECK_PATH, $(EXP_BIN_LIB_PATH), $(EXP_BIN_HEADERS_PATH),Checking binary bundle directories...) \
	)
# if all needed isn't found
	@$(if $(filter-out true,$(IS_ALL_FOUND)),                            \
	    $(error $(ERROR_CHECK_MSG))                                      \
	)
