# 
# Copyright (c) 2015, 2016, Oracle and/or its affiliates. All rights reserved.
#
# This software is dual-licensed to you under the MIT License (MIT) and the Universal Permissive License (UPL).  See the LICENSE file in the root directory for license terms.  You may choose
# either license, or both.
#
ifneq ($(OPENSSL_URL), )
OPENSSL_ARCH=$(notdir $(OPENSSL_URL) )
OPENSSL_NAME=$(subst .tar.gz,,$(OPENSSL_ARCH))
else
ifneq ($(OPENSSL_PATH), )
OPENSSL_ARCH=$(notdir $(OPENSSL_PATH) )
OPENSSL_NAME=$(subst .tar.gz,,$(OPENSSL_ARCH))
else
OPENSSL_ARCH=$(OPENSSL_NAME).tar.gz
OPENSSL_URL="https://www.openssl.org/source/$(OPENSSL_ARCH)"
endif
endif

ifneq ($(OPENSSL_PATH), )
    DOWNLOAD_COMMAND=cp -f "$(OPENSSL_PATH)" ./$(OPENSSL_ARCH)
else
    ifneq ($(PROXY), )
	DOWNLOAD_COMMAND=export https_proxy="$(PROXY)"; wget $(OPENSSL_URL)
    else
        DOWNLOAD_COMMAND=echo "WARNING: No HTTPS proxy is set for download. Usage: 'make -f Makefile.lib.mk PORT=windows download_dependencies [OPENSSL_PATH=<PATH TO OPENSSL.TAR.GZ> | PROXY=https://<YOUR PROXY URL>]'"; echo ""; wget $(OPENSSL_URL)
    endif
endif

$(OPENSSL)/$(OPENSSL_ARCH):
	$(A)mkdir -p $(dir $@)
	$(A)cd $(OPENSSL); $(DOWNLOAD_COMMAND)

$(OPENSSL)/$(OPENSSL_ARCH_FOLDER)/unpacked: $(OPENSSL)/$(OPENSSL_ARCH)
	$(A)tar -xvf $? -C "$(shell cd $(dir $(OPENSSL)/$(OPENSSL_ARCH)); pwd)"
	$(A)touch $(OPENSSL)/$(OPENSSL_ARCH_FOLDER)/unpacked

download_dependencies: $(OPENSSL)/$(OPENSSL_ARCH_FOLDER)/unpacked
	@printf 'openssl download finished!';

clean_dependencies:
	$(A)rm $(OPENSSL)/$(OPENSSL_ARCH)
	$(A)rm -rf $(OPENSSL)/$(OPENSSL_ARCH_FOLDER)
