# 
# Copyright (c) 2015, 2016, Oracle and/or its affiliates. All rights reserved.
#
# This software is dual-licensed to you under the MIT License (MIT) and the Universal Permissive License (UPL).  See the LICENSE file in the root directory for license terms.  You may choose
# either license, or both.
#

################################################################################
## custom arguments                                                           ##
################################################################################

# custom path to the IoTCS shared library
IOTCS_LIBRARY_PATH?=
# custom path to the IoTCS header files
# if specified only IOTCS_LIBRARY_PATH then IOTCS_HEADERS_PATH = IOTCS_LIBRARY_PATH
IOTCS_HEADERS_PATH?=
# + common custom compiler arguments

################################################################################
## internal port-dependent variables                                          ##
##                   should be overwritten in port implementation             ##
################################################################################
LDLIBS?=

################################################################################
## internal port-independent variables shouldn't be overwritten               ##
################################################################################
# base file check
ifeq ($(LIB_CONFIG),)
    $(error No library configuration file for LIB_CFG=$(LIB_CFG) !)
endif
ifeq ($(SMPL_SHARED_CUSTOM_CONFIG),)
    $(info No custom shared library part configuration file !)
endif
ifeq ($(SMPL_PORT_CUSTOM_CONFIG),)
    $(error No custom port library part configuration file !)
endif
ifeq ($(COMPILER_CONFIG),)
    $(error No compiler configuration file for CC_CFG=$(CC_CFG) !)
endif
ifeq ($(SAMPLE_COMMON_DEFS),)
    $(error No sample common defenition file !)
endif
ifeq ($(SAMPLE_PORT_IMPL),)
    $(error No sample port implemenetation file !)
endif

## variable depending on the configuration ##
# used for verbose output log
ifneq ($(VERBOSE),true)
    A=@
else
    V=-v
endif

# used for output directory name
ifeq ($(DEBUG), true)
    DEBUG_SUFFIX=_d
    CPPFLAGS+=$(DEBUG_OPT)
endif

# used for library configuration
CONF_SUBDIR:=
ifeq ($(MESSAGING_THREAD_SAFETY), true)
    CONF_SUBDIR:=ts
else
    CONF_SUBDIR:=nots
endif
ifeq ($(MESSAGE_DISPATCHER), true)
    CONF_SUBDIR:=$(CONF_SUBDIR)_md
endif
ifeq ($(VIRTUALIZATION_SUPPORT), true)
    CONF_SUBDIR:=$(CONF_SUBDIR)_vs
endif
ifeq ($(GATEWAY), true)
    CONF_SUBDIR:=$(CONF_SUBDIR)_gw
endif

## base directories ##
MSG_SUBDIR=advanced
INCLUDE_SUBDIR=include

## base files ##

## base variables ##
# platform variables
PLATFORM_OS:=$(subst /,_,$(shell uname -m))
PLATFORM_OS:=$(shell echo $(PLATFORM_OS) | tr A-Z a-z)
# sample names
DCD_SAMPLE_NAME=directly_connected_device_sample
GW_SAMPLE_NAME=gateway_device_sample
STORAGE_SAMPLE_NAME=motion_activated_camera_sample
LINE_TRAP="===================================================="
# library variables
LIB_EXT=a
# shared library short name
SHORT_LIB_NAME=deviceclient
# shared library full name
FULL_LIB_NAME=lib$(SHORT_LIB_NAME).$(LIB_EXT)

## temporary directories ##
TMP_DIR=$(OUTPUT_DIR)/tmp

## output directories ##

## output messages ##
define POSSIBLE_CONF_MSG
    
Please use next build options to build samples.
    for $(MSG_SUBDIR)/$(DCD_SAMPLE_NAME) use 
        LIB_CFG=nots or LIB_CFG=ts
    
    for $(MSG_SUBDIR)/$(GW_SAMPLE_NAME) use 
        LIB_CFG=ts_md_gw

    for $(DCD_SAMPLE_NAME) use 
        LIB_CFG=ts_md_vs

    for $(GW_SAMPLE_NAME) use 
        LIB_CFG=ts_md_vs_gw

endef

define LIB_CHECKING_MSG
Checking the $(abspath $(CURRENT_LIB_PATH)) directory for library...
endef

define LIB_CHECK_ERR_MSG
	Library $(FULL_LIB_NAME) isn't found in the $(CURRENT_LIB_PATH) directory

endef

define LIB_CHECK_OK_MSG
	Library $(FULL_LIB_NAME) ... OK

endef

INCLUDE_CHECKING_MSG=Checking the $(abspath $(CURRENT_INCLUDE_PATH)) directory for library...

define INCLUDE_CHECK_ERR_MSG
	Headers aren't found in $(CURRENT_INCLUDE_PATH) directory...

endef

define INCLUDE_CHECK_OK_MSG
	$(CURRENT_INCLUDE_PATH) directory ... OK

endef

define ERROR_CHECK_MSG
Please use binary or source bundle to get needed library to build sample.
OR
Set IOTCS_LIBRARY_PATH=<directory with libary> and 
    IOTCS_HEADERS_PATH=<directory with headers OR directory with include folder> 
    variables to directory with library and include headers.
endef

# $(1) - library path for check
# $(2) - headers path (include folder) for check
define CHECK_PATH
$(if $(filter-out true,$(IS_ALL_FOUND)), \
	$(info ) \
	$(info $(3)) \
	$(eval CURRENT_LIB_PATH:=$(1)) \
	$(eval CURRENT_INCLUDE_PATH:=$(2)) \
	$(info $(LIB_CHECKING_MSG)) \
	$(if $(shell [ -r $(CURRENT_LIB_PATH)/$(FULL_LIB_NAME) ] && echo 1), \
	    $(info $(LIB_CHECK_OK_MSG)) \
	    $(info $(INCLUDE_CHECKING_MSG)) \
	    $(if $(filter-out 0,$(shell [ -d $(CURRENT_INCLUDE_PATH) ] \
		&& ls -1 $(CURRENT_INCLUDE_PATH)/*.h 2>/dev/null | wc -l)), \
		$(info $(INCLUDE_CHECK_OK_MSG)) \
		$(eval IS_ALL_FOUND:=true) \
	    , \
		$(info $(INCLUDE_CHECK_ERR_MSG)) \
		$(eval CURRENT_INCLUDE_PATH:=$(2)/$(INCLUDE_SUBDIR)) \
		$(info $(INCLUDE_CHECKING_MSG)) \
		$(if $(filter-out 0,$(shell [ -d $(CURRENT_INCLUDE_PATH) ] \
		    && ls -1 $(CURRENT_INCLUDE_PATH)/*.h 2>/dev/null | wc -l)), \
		    $(info $(INCLUDE_CHECK_OK_MSG)) \
		    $(eval IS_ALL_FOUND:=true) \
		, \
		    $(info $(INCLUDE_CHECK_ERR_MSG)) \
		) \
	    ) \
	, \
	    $(info $(LIB_CHECK_ERR_MSG)) \
	) \
)
endef

# check sample configuration
CURRENT_SAMPLE=
CURRENT_SCS_SAMPLE=
CURRENT_SAMPLE_DIR=
# advanced/dcd_extra_sample using Messaging API | LIB_CFG=nots
ifeq ("false false false false", "$(MESSAGING_THREAD_SAFETY) $(MESSAGE_DISPATCHER) $(VIRTUALIZATION_SUPPORT) $(GATEWAY)")
    CURRENT_SAMPLE:=$(DCD_SAMPLE_NAME)
    CURRENT_SCS_SAMPLE:=""
    CURRENT_SAMPLE_DIR:=$(SAMPLE_SRC_DIR)/$(MSG_SUBDIR)
endif

# advanced/dcd_extra_sample using thread safety Messaging API | LIB_CFG=ts
ifeq ("true false false false", "$(MESSAGING_THREAD_SAFETY) $(MESSAGE_DISPATCHER) $(VIRTUALIZATION_SUPPORT) $(GATEWAY)")
    CURRENT_SAMPLE:=$(DCD_SAMPLE_NAME)
    CURRENT_SAMPLE_DIR:=$(SAMPLE_SRC_DIR)/$(MSG_SUBDIR)
    CURRENT_SCS_SAMPLE:=""
endif

# advanced/gw_extra_sample using thread safety Messaging API and Message Dispatcher | LIB_CFG=ts_md_gw
ifeq ("true true false true", "$(MESSAGING_THREAD_SAFETY) $(MESSAGE_DISPATCHER) $(VIRTUALIZATION_SUPPORT) $(GATEWAY)")
    CURRENT_SAMPLE:=$(GW_SAMPLE_NAME)
    CURRENT_SAMPLE_DIR:=$(SAMPLE_SRC_DIR)/$(MSG_SUBDIR)
    CURRENT_SCS_SAMPLE:=$(STORAGE_SAMPLE_NAME)
endif

# dcd_sample using Virtualization API | LIB_CFG=ts_md_vs
ifeq ("true true true false", "$(MESSAGING_THREAD_SAFETY) $(MESSAGE_DISPATCHER) $(VIRTUALIZATION_SUPPORT) $(GATEWAY)")
    CURRENT_SAMPLE:=$(DCD_SAMPLE_NAME)
    CURRENT_SAMPLE_DIR:=$(SAMPLE_SRC_DIR)
    CURRENT_SCS_SAMPLE:=""
endif

# gw_sample using Virtualization API | LIB_CFG=ts_md_vs_gw
ifeq ("true true true true", "$(MESSAGING_THREAD_SAFETY) $(MESSAGE_DISPATCHER) $(VIRTUALIZATION_SUPPORT) $(GATEWAY)")
    CURRENT_SAMPLE:=$(GW_SAMPLE_NAME)
    CURRENT_SAMPLE_DIR:=$(SAMPLE_SRC_DIR)
    CURRENT_SCS_SAMPLE:=$(STORAGE_SAMPLE_NAME)
endif

# flag of library and include folder paths check
IS_ALL_FOUND:=false

# custom path
ifneq ("$(IOTCS_LIBRARY_PATH)", "")
    ifeq ("$(IOTCS_HEADERS_PATH)", "")
	IOTCS_HEADERS_PATH=$(IOTCS_LIBRARY_PATH)
    endif
endif

## add default includes
CPPFLAGS+=$(WALL_OPT) $(INCLUDE_OPT)$(CURRENT_INCLUDE_PATH) $(INCLUDE_OPT)$(CURRENT_LIB_PATH)

# print build configuration
.PHONY: print_conf
print_conf:
	@printf "%s\n" "$(LINE_TRAP)";                      \
	printf "PLATFORM_OS     = %s\n" "$(PLATFORM_OS)";   \
	printf "PORT            = %s\n" "$(PORT)";          \
	printf "LIB_CFG         = %s\n" "$(LIB_CFG)";       \
	printf "CC_CFG          = %s\n" "$(CC_CFG)";        \
	printf "OUT_CC_SUBDIR   = %s\n" "$(OUT_CC_SUBDIR)"; \
	printf "TOOLS_PREFIX    = %s\n" "$(TOOLS_PREFIX)" ; \
	$(if $(CPP_OPTS), printf "CPP_OPTS        = %s\n" "$(CPP_OPTS)"; ) \
	$(if $(C_OPTS), printf "C_OPTS          = %s\n" "$(C_OPTS)"; ) \
	$(if $(CXX_OPTS), printf "CXX_OPTS        = %s\n" "$(CXX_OPTS)"; ) \
	$(if $(AS_OPTS), printf "AS_OPTS         = %s\n" "$(AS_OPTS)"; ) \
	$(if $(LD_OPTS), printf "LD_OPTS         = %s\n" "$(LD_OPTS)"; ) \
	$(if $(IOTCS_LIBRARY_PATH),                                          \
	    printf "IOTCS_LIBRARY_PATH  = %s\n" "$(IOTCS_LIBRARY_PATH)" ;    \
	    printf "IOTCS_HEADERS_PATH  = %s\n" "$(IOTCS_HEADERS_PATH)" ;    \
	)                                                                    \
	printf "%s\n" "$(LINE_TRAP)"

# print sample configuration
.PHONY: print_smplconf
print_smplconf: .print_common_smplconf .print_smplconf_impl
	@printf "%s\n" "$(LINE_TRAP)"

.print_common_smplconf:
	@printf "IoTCS sample configuration:\n";                                   \
	printf "%s\n" "$(LINE_TRAP)";                                              \
	printf "  MESSAGING_THREAD_SAFETY   = %s\n" "$(MESSAGING_THREAD_SAFETY)";  \
	printf "  MESSAGE_DISPATCHER        = %s\n" "$(MESSAGE_DISPATCHER)";       \
	printf "  VIRTUALIZATION_SUPPORT    = %s\n" "$(VIRTUALIZATION_SUPPORT)";   \
	printf "  GATEWAY                   = %s\n" "$(GATEWAY)";                  \
	printf "  DEBUG                     = %s\n" "$(DEBUG)";
	

.PHONY: check_smpl
check_smpl: .base_check .check_impl

ifeq ($(CURRENT_SAMPLE),)
    ERROR_CONF=$(error $(POSSIBLE_CONF_MSG))
endif
ifneq ($(DEFAULT_TAM),true)
    ERROR_TAM=$(error Please use DEFAULT_TAM=true to build samples.)
endif

.base_check: 
	$(ERROR_CONF)
	$(ERROR_TAM)
