/*
 * Copyright (c) 2015, 2016, Oracle and/or its affiliates. All rights reserved.
 *
 * This software is dual-licensed to you under the MIT License (MIT) and
 * the Universal Permissive License (UPL). See the LICENSE file in the root
 * directory for license terms. You may choose either license, or both.
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include <mbedtls/cipher.h>
#include <mbedtls/sha256.h>
#include <mbedtls/md5.h>
#include <mbedtls/base64.h>
#include "mbedtls/entropy.h"
#include "mbedtls/ctr_drbg.h"
#include <mbedtls/rsa.h>
#include <mbedtls/pk.h>
#include <mbedtls/pem.h>
#include <mbedtls/x509.h>
#include <mbedtls/x509_crt.h>
#include "util/util_memory.h"
#include "iotcs_port_system.h"
#include "iotcs_port_crypto.h"
#include "iotcs_port_tam.h"
#include "trusted_assets_manager/iotcs_tam.h"
#include "util/util.h"

#include "log/log.h"
#define IOTCSP_MODULE_LOG_CHANNEL LOG_CHANNEL_PORT_CRYPTO
#include "log/log_template.h"

iotcs_result iotcs_port_crypto_encode_base64(char* output, size_t* output_length, const char* input, size_t input_length) {
    int res = mbedtls_base64_encode((unsigned char *)output, *output_length, output_length, (const unsigned char *)input, input_length);

    return (res == 0) ? IOTCS_RESULT_OK : IOTCS_RESULT_FAIL;
}

iotcs_result iotcs_port_crypto_decode_base64(char* output, size_t* output_length, const char* input, size_t input_length) {
    int res = mbedtls_base64_decode((unsigned char *)output, *output_length, output_length, (const unsigned char *)input, input_length);
    return (res == 0) ? IOTCS_RESULT_OK : IOTCS_RESULT_FAIL;
}

iotcs_result iotcs_port_crypto_init(void) {
    return IOTCS_RESULT_OK;
}

void iotcs_port_crypto_finalize(void) {
}
