/**
 * Copyright (c) 2018, Oracle and/or its affiliates. All rights reserved.
 *
 * This software is dual-licensed to you under the MIT License (MIT) and
 * the Universal Permissive License (UPL). See the LICENSE file in the root
 * directory for license terms. You may choose either license, or both.
 *
 */

const util = require('util');

/**
 * This Platform class supports handling the environment-specific variables when running on NodeJS.
 * This file, and it's associated file, PlatformBrowser must support the same environment
 * variables.
 */
 class Platform {
     static debug(message) {
         debug(message);
     }

     /**
      * Returns a string representation of the specified object. The returned string is typically
      * used for debugging.
      *
      * @param {object} obj the object to "debug".
      * @returns {string} a string representation of the object.
      */
    static inspect(obj) {
        return util.inspect(obj);
    }
}
