/**
 * Copyright (c) 2018, Oracle and/or its affiliates. All rights reserved.
 *
 * This software is dual-licensed to you under the MIT License (MIT) and
 * the Universal Permissive License (UPL). See the LICENSE file in the root
 * directory for license terms. You may choose either license, or both.
 *
 */

/**
 * List of HTTP status codes and messages.
 *
 * @alias iotcs.StatusCode
 * @class
 */
StatusCode = {
    /**
     * Indicates HTTP status code 200 - OK
     */
    OK: {
        code: 200,
        message: 'OK'
    },
    /**
     * Indicates HTTP status code 201 - Created
     */
    CREATED: {
        code: 201,
        message: 'Created'
    },
    /**
     * Indicates HTTP status code 202 - Accepted
     */
    ACCEPTED: {
        code: 202,
        message: 'Accepted'
    },
    /**
     * Indicates HTTP status code 203- Non Authoritative Information
     */
    NON_AUTHORITATIVE_INFORMATION: {
        code: 203,
        message: 'Non Authoritative Information'
    },
    /**
     * Indicates HTTP status code 204 - No Content
     */
    NO_CONTENT: {
        code: 204,
        message: 'No Content'
    },
    /**
     * Indicates HTTP status code 205 - Finished
     */
    FINISHED: {
        code: 205,
        message: 'Finished'
    },
    /**
     * Indicates HTTP status code 206 - Data Finished
     */
    DATA_FINISHED: {
        code: 206,
        message: 'Data Finished'
    },
    /**
     * Indicates HTTP status code 400 - Bad Request
     */
    BAD_REQUEST: {
        code: 400,
        message: 'Bad Request'
    },
    /**
     * Indicates HTTP status code 401 - Unauthorized
     */
    UNAUTHORIZED: {
        code: 401,
        message: 'Unauthorized'
    },
    /**
     * Indicates HTTP status code 402 - Payment Required
     */
    PAYMENT_REQUIRED: {
        code: 402,
        message: 'Payment Required'
    },
    /**
     * Indicates HTTP status code 403 - Forbidden
     */
    FORBIDDEN: {
        code: 403,
        message: 'Forbidden'
    },
    /**
     * Indicates HTTP status code 404 - Not Found
     */
    NOT_FOUND: {
        code: 404,
        message: 'Not Found'
    },
    /**
     * Indicates HTTP status code 405 - OK
     */
    METHOD_NOT_ALLOWED: {
        code: 405,
        message: 'Method Not Allowed'
    },
    /**
     * Indicates HTTP status code 406 - Not Acceptable
     */
    NOT_ACCEPTABLE: {
        code: 406,
        message: 'Not Acceptable'
    },
    /**
     * Indicates HTTP status code 408 - Request Timeout
     */
    REQUEST_TIMEOUT: {
        code: 408,
        message: 'Request Timeout'
    },
    /**
     * Indicates HTTP status code 409 - Conflict
     */
    CONFLICT: {
        code: 409,
        message: 'Conflict'
    },
    /**
     * Indicates HTTP status code 500 - Internal Server Error
     */
    INTERNAL_SERVER_ERROR: {
        code: 500,
        message: 'Internal Server Error'
    },
    /**
     * Indicates HTTP status code 501 - Not implemented
     */
    NOT_IMPLEMENTED: {
        code: 501,
        message: 'Not Implemented'
    },
    /**
     * Indicates HTTP status code 502 - Bad Gateway
     */
    BAD_GATEWAY: {
        code: 502,
        message: 'Bad Gateway'
    },
    /**
     * Indicates HTTP status code 503 - Service Unavailabl
     */
    SERVICE_UNAVAILABLE: {
        code: 503,
        message: 'Service Unavailable'
    },
    /**
     * Indicates HTTP status code -1 - Other
     */
    OTHER: {
        code: -1,
        message: 'Other'
    }
};
