/**
 * Copyright (c) 2015, 2018, Oracle and/or its affiliates. All rights reserved.
 *
 * This software is dual-licensed to you under the MIT License (MIT) and
 * the Universal Permissive License (UPL). See the LICENSE file in the root
 * directory for license terms. You may choose either license, or both.
 *
 */

 /**
  * This Platform class supports handling environment-specific variables when running on a browser.
  * This file, and it's associated file, PlatformNode must support the same environment variables.
  */
 class Platform {
     static debug(message) {
         console.log(message);
     }

     /**
      * Returns a string representation of the specified object. The returned string is typically
      * used for debugging.
      *
      * @param {object} obj the object to "debug".
      * @returns {string} a string representation of the object.
      */
     static inspect(obj) {
         return String(obj);
     }
}
