/**
 * Copyright (c) 2015, 2018, Oracle and/or its affiliates. All rights reserved.
 *
 * This software is dual-licensed to you under the MIT License (MIT) and
 * the Universal Permissive License (UPL). See the LICENSE file in the root
 * directory for license terms. You may choose either license, or both.
 *
 */

this.config = {
    bundles : [
        // Device client library for NodeJS
        // The device client library for NodeJS is ECMAScript2015 (ES6) compatible.
        // These MUST be ordered such that classes are declared before they are accessed.
        {
            output: './build/modules/device-library.node.js',
            wrapper: './src/shared/wrapper-node-bundle.js',
            fields: {
                LIBNAME:'iotcs',
                DESCRIPTION:'Oracle IoT Cloud Service JavaScript Device Client Software Library',
                VERSION:'19.1.5.0.0-20',
                FILES: [
                    './src/device/@overview.js',
                    './src/device/@globals.js',
                    './src/shared/$port-node.js',
                    './src/shared/$port-mqtt.js',
                    './src/shared/$impl.js',
                    './src/shared/MqttController.js',
                    './src/device/$impl-dcl.js',
                    './src/device/Platform-Node.js',
                    './src/shared/Client.js',
                    './src/shared/Monitor.js',
                    './src/shared/AbstractVirtualDevice.js',
                    './src/shared/UnifiedTrustStore.js',
                    './src/device/TrustedAssetsManager.js',
                    './src/device/Message.js',
                    './src/device/DataItem.js',
                    './src/device/PersistenceMetaData.js',
                    './src/device/DeviceFunction.js',
                    './src/shared/DeviceModel.js',
                    './src/shared/DeviceModelFormat.js',
                    './src/shared/DeviceModelFormatField.js',
                    './src/device/DevicePolicyFunction.js',
                    './src/device/DevicePolicy.js',
                    './src/shared/DeviceModelParser.js',
                    './src/device/DeviceAnalog.js',
                    './src/device/DirectlyConnectedDeviceImpl.js',
                    './src/device/DirectlyConnectedDeviceUtil.js',
                    './src/device/FormulaParser.js',
                    './src/device/GatewayDeviceUtil.js',
                    './src/device/DeviceModelFactory.js',
                    './src/device/InMemoryPersistenceStore.js',
                    './src/device/TestConnectivity.js',
                    './src/device/MessageDispatcher.js',
                    './src/device/MessagePersistenceImpl-Node.js',
                    './src/device/BatchByPersistence-Node.js',
                    './src/device/RequestDispatcher.js',
                    './src/device/Attribute.js',
                    './src/shared/ActionSpecBase.js',
                    './src/device/ActionSpec.js',
                    './src/device/Alert.js',
                    './src/device/Data.js',
                    './src/device/DirectlyConnectedDevice.js',
                    './src/device/GatewayDevice.js',
                    './src/shared/NamedValue.js',
                    './src/shared/ActionEvent.js',
                    './src/device/VirtualDevice.js',
                    './src/device/DevicePolicyManager.js',
                    './src/device/PersistenceStoreManager.js',
                    './src/device/PersistenceStoreTransaction.js',
                    './src/shared/ExternalObject.js',
                    './src/device/Stack.js',
                    './src/shared/StorageObject.js',
                    './src/device/StorageObject.js',
                    './src/shared/StorageDispatcher.js',
                    './src/device/StorageDispatcher.js',
                    './src/device/MessagingPolicyImpl.js',
                    './src/device/Bucket.js',
                    './src/shared/DeviceModelAction.js',
                    './src/shared/DeviceModelActionArgument.js',
                    './src/shared/DeviceModelAttribute.js',
                    './src/device/NetworkCost.js',
                    './src/device/Pair.js',
                    './src/device/ScheduledPolicyData.js',
                    './src/device/ScheduledPolicyDataKey.js',
                    './src/device/TimedPolicyThread.js',
                    './src/device/VirtualDeviceAttribute.js',
                    './src/device/WritableValue.js'
                ]
            }
        },

        // Device client src web browsers.
        // The device client src for web browsers is ECMAScript2015 (ES6) compatible.
        // These MUST be ordered such that classes are declared before they are accessed.
        {
            output: './build/modules/device-library.web.js',
            wrapper: './src/shared/wrapper-browser-bundle.js',
            fields: {
                LIBNAME:'iotcs',
                DESCRIPTION:'Oracle IoT Cloud Service JavaScript Device Client Software Library',
                VERSION:'19.1.5.0.0-20',
                FILES: [
                    './src/device/@overview.js',
                    './src/device/@globals.js',
                    './src/device/$port-browser.js',
                    './src/shared/$port-mqtt.js',
                    './src/shared/$impl.js',
                    './src/shared/MqttController.js',
                    './src/device/$impl-dcl.js',
                    './src/device/Platform-Browser.js',
                    './src/shared/Client.js',
                    './src/shared/Monitor.js',
                    './src/shared/AbstractVirtualDevice.js',
                    './src/shared/UnifiedTrustStore.js',
                    './src/device/TrustedAssetsManager.js',
                    './src/device/Message.js',
                    './src/device/DataItem.js',
                    './src/device/PersistenceMetaData.js',
                    './src/device/DeviceFunction.js',
                    './src/shared/DeviceModel.js',
                    './src/shared/DeviceModelFormat.js',
                    './src/shared/DeviceModelFormatField.js',
                    './src/device/DevicePolicyFunction.js',
                    './src/device/DevicePolicy.js',
                    './src/shared/DeviceModelParser.js',
                    './src/device/DeviceAnalog.js',
                    './src/device/DirectlyConnectedDeviceImpl.js',
                    './src/device/DirectlyConnectedDeviceUtil.js',
                    './src/device/FormulaParser.js',
                    './src/device/GatewayDeviceUtil.js',
                    './src/device/DeviceModelFactory.js',
                    './src/device/InMemoryPersistenceStore.js',
                    './src/device/TestConnectivity.js',
                    './src/device/MessageDispatcher.js',
                    './src/device/MessagePersistenceImpl-Browser.js',
                    './src/device/BatchByPersistence-Browser.js',
                    './src/device/RequestDispatcher.js',
                    './src/device/Attribute.js',
                    './src/shared/ActionSpecBase.js',
                    './src/device/ActionSpec.js',
                    './src/device/Alert.js',
                    './src/device/Data.js',
                    './src/device/DirectlyConnectedDevice.js',
                    './src/device/GatewayDevice.js',
                    './src/shared/NamedValue.js',
                    './src/shared/ActionEvent.js',
                    './src/device/VirtualDevice.js',
                    './src/device/DevicePolicyManager.js',
                    './src/device/PersistenceStoreManager.js',
                    './src/device/PersistenceStoreTransaction.js',
                    './src/shared/ExternalObject.js',
                    './src/device/Stack.js',
                    './src/shared/StorageObject.js',
                    './src/device/StorageObject.js',
                    './src/shared/StorageDispatcher.js',
                    './src/device/StorageDispatcher.js',
                    './src/device/MessagingPolicyImpl.js',
                    './src/device/Bucket.js',
                    './src/shared/DeviceModelAction.js',
                    './src/shared/DeviceModelActionArgument.js',
                    './src/shared/DeviceModelAttribute.js',
                    './src/device/NetworkCost.js',
                    './src/device/Pair.js',
                    './src/device/ScheduledPolicyData.js',
                    './src/device/ScheduledPolicyDataKey.js',
                    './src/device/TimedPolicyThread.js',
                    './src/device/VirtualDeviceAttribute.js',
                    './src/device/WritableValue.js'
                ]
            }
        },

        // Enterprise client library for NodeJS.
        // The enterprise client library for NodeJS is ECMAScript2015 (ES6) compatible.
        // These MUST be ordered such that classes are declared before they are accessed.
        {
            output: './build/modules/enterprise-library.node.js',
            wrapper: './src/shared/wrapper-node-bundle.js',
            fields: {
                LIBNAME:'iotcs',
                DESCRIPTION:'Oracle IoT Cloud Service JavaScript Enterprise Client Software Library',
                VERSION:'19.1.5.0.0-20',
                FILES: [
                    './src/enterprise/@overview.js',
                    './src/enterprise/@globals.js',
                    './src/shared/$port-node.js',
                    './src/shared/$impl.js',
                    './src/enterprise/Platform-Node.js',
                    './src/shared/Client.js',
                    './src/shared/Monitor.js',
                    './src/shared/AbstractVirtualDevice.js',
                    './src/shared/UnifiedTrustStore.js',
                    './src/enterprise/$impl-ecl.js',
                    './src/shared/ActionSpecBase.js',
                    './src/enterprise/ActionSpec.js',
                    './src/enterprise/Alert.js',
                    './src/enterprise/Data.js',
                    './src/enterprise/Attribute.js',
                    './src/enterprise/AsyncRequestMonitor.js',
                    './src/enterprise/Controller.js',
                    './src/enterprise/Pageable.js',
                    './src/enterprise/MessageEnumerator.js',
                    './src/enterprise/ResourceEnumerator.js',
                    './src/enterprise/DeviceAppEnumerator.js',
                    './src/enterprise/EnterpriseClientImpl.js',
                    './src/enterprise/EnterpriseClient.js',
                    './src/enterprise/Filter.js',
                    './src/enterprise/Message.js',
                    './src/shared/DeviceModel.js',
                    './src/shared/DeviceModelAction.js',
                    './src/shared/DeviceModelActionArgument.js',
                    './src/shared/DeviceModelAttribute.js',
                    './src/shared/DeviceModelFormat.js',
                    './src/shared/DeviceModelFormatField.js',
                    './src/shared/DeviceModelParser.js',
                    './src/enterprise/Action.js',
                    './src/enterprise/VirtualDevice.js',
                    './src/enterprise/TrustedAssetsManager.js',
                    './src/shared/StorageDispatcher.js',
                    './src/shared/ExternalObject.js',
                    './src/shared/StorageObject.js',
                    './src/enterprise/StorageObject.js',
                    './src/enterprise/StorageDispatcher.js'
                ]
            }
        },

        // Enterprise client library for web browsers.
        // The enterprise client library for web browsers is ECMAScript2015 (ES6) compatible.
        // These MUST be ordered such that classes are declared before they are accessed.
        {
            output: './build/modules/enterprise-library.web.js',
            wrapper: './src/shared/wrapper-browser-bundle.js',
            fields: {
                LIBNAME:'iotcs',
                DESCRIPTION:'Oracle IoT Cloud Service JavaScript Enterprise Client Software Library',
                VERSION:'19.1.5.0.0-20',
                FILES: [
                    './src/enterprise/@overview.js',
                    './src/enterprise/@globals.js',
                    './src/enterprise/$port-browser.js',
                    './src/shared/$impl.js',
                    './src/enterprise/Platform-Browser.js',
                    './src/shared/Client.js',
                    './src/shared/Monitor.js',
                    './src/shared/AbstractVirtualDevice.js',
                    './src/shared/UnifiedTrustStore.js',
                    './src/enterprise/$impl-ecl.js',
                    './src/shared/ActionSpecBase.js',
                    './src/enterprise/ActionSpec.js',
                    './src/enterprise/Alert.js',
                    './src/enterprise/Data.js',
                    './src/enterprise/Attribute.js',
                    './src/enterprise/AsyncRequestMonitor.js',
                    './src/enterprise/Controller.js',
                    './src/enterprise/Pageable.js',
                    './src/enterprise/MessageEnumerator.js',
                    './src/enterprise/ResourceEnumerator.js',
                    './src/enterprise/DeviceAppEnumerator.js',
                    './src/enterprise/EnterpriseClientImpl.js',
                    './src/enterprise/EnterpriseClient.js',
                    './src/enterprise/Filter.js',
                    './src/enterprise/Message.js',
                    './src/shared/DeviceModel.js',
                    './src/shared/DeviceModelAction.js',
                    './src/shared/DeviceModelActionArgument.js',
                    './src/shared/DeviceModelAttribute.js',
                    './src/shared/DeviceModelFormat.js',
                    './src/shared/DeviceModelFormatField.js',
                    './src/shared/DeviceModelParser.js',
                    './src/enterprise/Action.js',
                    './src/enterprise/VirtualDevice.js',
                    './src/enterprise/TrustedAssetsManager.js'
               ]
            }
        },

        // JavaScript bundle for Messaging API docs.
        {
            output: './build/temp/docs/iotcs.bundle.ll.web.js',
            wrapper: './src/shared/wrapper-browser-bundle.js',
            fields: {
                LIBNAME:'iotcs',
                DESCRIPTION:'Oracle IoT Cloud Service JavaScript Client Software Library Messaging API',
                VERSION:'19.1.5.0.0-20',
                FILES: [
                    './src/device/@globals.js',
                    './src/device/@overview.js',
                    './src/device/DirectlyConnectedDeviceUtil.js',
                    './src/device/GatewayDeviceUtil.js',
                    './src/device/Message.js',
                    './src/device/MessageDispatcher.js',
                    './src/device/RequestDispatcher.js',
                    './src/device/StorageDispatcher.js',
                    './src/device/TrustedAssetsManager.js',
                    './src/enterprise/@globals.js',
                    './src/enterprise/DeviceAppEnumerator.js',
                    './src/enterprise/MessageEnumerator.js',
                    './src/enterprise/Pageable.js',
                    './src/enterprise/ResourceEnumerator.js',
                    './src/enterprise/TrustedAssetsManager.js',
                    './src/shared/ExternalObject.js',
                    './src/shared/StorageObject.js',
                    './src/shared/UnifiedTrustStore.js'
                ]
            }
        },

        // JavaScript bundle for Virtualization API docs.
        {
            output: './build/temp/docs/iotcs.bundle.hl.web.js',
            wrapper: './src/shared/wrapper-browser-bundle.js',
            fields: {
                LIBNAME:'iotcs',
                DESCRIPTION:'Oracle IoT Cloud Service JavaScript Client Software Library Virtualization API',
                VERSION:'19.1.5.0.0-20',
                FILES: [
                    './src/device/@globals.js',
                    './src/device/Alert.js',
                    './src/device/Data.js',
                    './src/device/DirectlyConnectedDevice.js',
                    './src/device/GatewayDevice.js',
                    './src/device/StorageObject.js',
                    './src/device/VirtualDevice.js',
                    './src/enterprise/@globals.js',
                    './src/enterprise/@overview.js',
                    './src/enterprise/Action.js',
                    './src/enterprise/AsyncRequestMonitor.js',
                    './src/enterprise/EnterpriseClient.js',
                    './src/enterprise/Filter.js',
                    './src/enterprise/Pageable.js',
                    './src/enterprise/VirtualDevice.js',
                    './src/shared/AbstractVirtualDevice.js',
                    './src/shared/ActionEvent.js',
                    './src/shared/Client.js',
                    './src/shared/ExternalObject.js',
                    './src/shared/StatusCode.js'
                ]
            }
        }
    ]
};
