/*
 * Copyright (c) 2018, Oracle and/or its affiliates.  All rights reserved.
 *
 * This software is dual-licensed to you under the MIT License (MIT) and
 * the Universal Permissive License (UPL).  See the LICENSE file in the root
 * directory for license terms.  You may choose either license, or both.
 */

/**
 * SQL database persistence for 'batchBy' policy data for the browser.   Contains empty
 * implementations of the required functions.
 */
class BatchByPersistence {
    // Instance "variables"/properties...see constructor.

    /**
     * Creates the message persistent storage table if it doesn't exist.
     */
    createBatchByTableIfNotExists() {
    }

    /**
     * @param {Set<Message>}
     * @return {boolean}
     */
    delete(messages) {
    }

    /**
     * @param {string} endpointId
     * @return {Set<Message>}
     */
    get(endpointId) {
        return new Promise((resolve, reject) => {
            resolve(new Set());
        });
    }

    /**
     *
     * @param {Set<Message>} messages
     * @param {string} endpointId
     */
    save(messages, endpointId) {
    }
}
