# Oracle IoT Cloud Service Enterprise Client Library

A JavaScript library used by applications acting as enterprise clients of the
Oracle IoT Cloud Service.

Getting Started
------------------

### Node.js

If you want to use iotcs-csl-enterprise with [node.js][], it is available through `npm`:

https://npmjs.org/package/iotcs-csl-enterprise

Installation:

    npm install iotcs-csl-enterprise

You can then use iotcs-csl-enterprise as a regular module:

    var iotcs = require('iotcs-csl-enterprise');

### Requirements

* Runtime dependencies
  * Forge
  * MQTT.js

### Using a browser bundle

Build the Forge bundle dependency. You can see details here:

https://www.npmjs.com/package/node-forge

Include in the browser the Forge bundle as dependency:

```html
<script src="node-modules/iotcs-csl-enterprise/node-modules/node-forge/js/forge.bundle.js"></script>
```

Include the iotcs library browser bundle file via:

```html
<script src="node-modules/iotcs-csl-enterprise/enterprise-library.web.js"></script>
```

The above bundle will synchronously create a global 'iotcs' object.

Library usage and API
------------------------

To get started with the Javascript Client Library:

"Oracle Internet of Things Cloud Service"
https://docs.oracle.com/en/cloud/paas/iot-cloud/index.html
