/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.shared;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class FormulaParser {
    public static List<Token> tokenize(String formula) throws IllegalArgumentException {
        ArrayList<Token> tokens = new ArrayList<Token>();
        int pos = 0;
        Token.Type tokenType = null;
        boolean inString = false;
        int length = 0;
        block20: for (int i = 0; i < formula.length(); ++i) {
            Token.Type type = tokenType;
            length = i - pos;
            char ch = formula.charAt(i);
            if (inString && ch != '\"') continue;
            switch (ch) {
                case '\"': {
                    if (inString) {
                        inString = false;
                        continue block20;
                    }
                    type = Token.Type.STRING;
                    inString = true;
                    break;
                }
                case '(': {
                    type = Token.Type.LPAREN;
                    break;
                }
                case ')': {
                    type = Token.Type.RPAREN;
                    break;
                }
                case ',': {
                    type = Token.Type.COMMA;
                    break;
                }
                case '?': {
                    type = Token.Type.QUESTION_MARK;
                    break;
                }
                case ':': {
                    type = Token.Type.COLON;
                    break;
                }
                case '+': {
                    type = Token.Type.PLUS;
                    break;
                }
                case '-': {
                    if (tokenType == Token.Type.IDENT) break;
                    type = Token.Type.MINUS;
                    break;
                }
                case '*': {
                    type = Token.Type.MUL;
                    break;
                }
                case '/': {
                    type = Token.Type.DIV;
                    break;
                }
                case '%': {
                    type = Token.Type.MOD;
                    break;
                }
                case '=': {
                    type = Token.Type.EQ;
                    char peekChar = FormulaParser.peek(formula, i + 1);
                    if (peekChar != '=') break;
                    ++i;
                    break;
                }
                case '!': {
                    char peekChar = FormulaParser.peek(formula, i + 1);
                    if (peekChar == '=') {
                        type = Token.Type.NEQ;
                        ++i;
                        break;
                    }
                    type = Token.Type.NOT;
                    break;
                }
                case '>': {
                    char peekChar = FormulaParser.peek(formula, i + 1);
                    if (peekChar == '=') {
                        type = Token.Type.GTE;
                        ++i;
                        break;
                    }
                    type = Token.Type.GT;
                    break;
                }
                case '<': {
                    char peekChar = FormulaParser.peek(formula, i + 1);
                    if (peekChar == '=') {
                        type = Token.Type.LTE;
                        ++i;
                        break;
                    }
                    type = Token.Type.LT;
                    break;
                }
                case '|': {
                    char peekChar = FormulaParser.peek(formula, i + 1);
                    if (peekChar != '|') break;
                    type = Token.Type.OR;
                    ++i;
                    break;
                }
                case '&': {
                    char peekChar = FormulaParser.peek(formula, i + 1);
                    if (peekChar != '&') break;
                    type = Token.Type.AND;
                    ++i;
                    break;
                }
                case '$': {
                    char peekChar = FormulaParser.peek(formula, i + 1);
                    if (peekChar == '(') {
                        type = Token.Type.ATTRIBUTE;
                        ++i;
                        break;
                    }
                    type = Token.Type.DOLLAR;
                    break;
                }
                default: {
                    if (Character.isWhitespace(ch)) {
                        type = Token.Type.WS;
                        break;
                    }
                    if (tokenType == Token.Type.IDENT) break;
                    if (Character.isDigit(ch)) {
                        type = Token.Type.NUMBER;
                        break;
                    }
                    if (ch == '.') {
                        if (tokenType == Token.Type.NUMBER) break;
                        char peekChar = FormulaParser.peek(formula, i + 1);
                        if (Character.isDigit(peekChar)) {
                            type = Token.Type.NUMBER;
                            ++i;
                            break;
                        }
                        throw new IllegalArgumentException("Found '" + peekChar + "' @ " + i + 1 + ": expected [0-9]");
                    }
                    type = Token.Type.IDENT;
                }
            }
            if (tokenType == type && (tokenType != Token.Type.LPAREN || type != Token.Type.LPAREN) && (tokenType != Token.Type.RPAREN || type != Token.Type.RPAREN)) continue;
            if (tokenType == Token.Type.IDENT) {
                String token = formula.substring(pos, pos + length);
                if ("AND".equalsIgnoreCase(token)) {
                    tokenType = Token.Type.AND;
                } else if ("OR".equalsIgnoreCase(token)) {
                    tokenType = Token.Type.OR;
                } else if ("NOT".equalsIgnoreCase(token)) {
                    tokenType = Token.Type.NOT;
                } else if ("LIKE".equalsIgnoreCase(token)) {
                    tokenType = Token.Type.LIKE;
                } else if ("TRUE".equalsIgnoreCase(token) || "FALSE".equalsIgnoreCase(token)) {
                    tokenType = Token.Type.BOOL;
                } else if (type == Token.Type.LPAREN) {
                    tokenType = type = Token.Type.FUNCTION;
                    continue;
                }
            }
            if (tokenType != null) {
                if (tokenType != Token.Type.WS) {
                    tokens.add(new Token(tokenType, pos, length));
                }
                pos += length;
            }
            tokenType = type;
        }
        if (tokenType != Token.Type.WS) {
            String token;
            if (tokenType == Token.Type.IDENT && ("TRUE".equalsIgnoreCase(token = formula.substring(pos, pos + length + 1)) || "FALSE".equalsIgnoreCase(token))) {
                tokenType = Token.Type.BOOL;
            }
            tokens.add(new Token(tokenType, pos, formula.length() - pos));
        }
        return tokens;
    }

    static char peek(String str, int offset) {
        return offset < str.length() ? str.charAt(offset) : (char)'\u0000';
    }

    static int comparePrec(Node left, Node right) {
        return left.getOperation().getPrec() - right.getOperation().getPrec();
    }

    public static Node parseFormula(List<Token> tokens, String formula) throws IllegalArgumentException {
        Stack<Node> stack = new Stack<Node>();
        int index = -1;
        try {
            index = FormulaParser.parseNumericExpression(stack, tokens, formula, 0);
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        if (index < tokens.size()) {
            stack.clear();
            try {
                index = FormulaParser.parseTernaryExpression(stack, tokens, formula, 0);
            }
            catch (IllegalArgumentException e) {
            }
            catch (IndexOutOfBoundsException e) {
                // empty catch block
            }
        }
        if (index < tokens.size()) {
            stack.clear();
            index = FormulaParser.parseRelationalExpression(stack, tokens, formula, 0);
        }
        if (index < tokens.size()) {
            Token lastToken = tokens.get(index);
            throw new IllegalArgumentException("formula: parser bailed @ " + lastToken.pos);
        }
        return (Node)stack.get(0);
    }

    static int parseTernaryExpression(Stack<Node> stack, List<Token> tokens, String formula, int index) throws IllegalArgumentException {
        if (index >= tokens.size()) {
            return tokens.size();
        }
        Token token = tokens.get(index = FormulaParser.parseConditionalOrExpression(stack, tokens, formula, index));
        if (token.getType() != Token.Type.QUESTION_MARK) {
            throw new IllegalArgumentException("parseTernaryExpression: found " + String.valueOf(token) + ", expected QUESTION_MARK");
        }
        Node ternary = new Node(Node.Operation.TERNARY, stack.pop());
        token = tokens.get(index = FormulaParser.parseAdditiveExpression(stack, tokens, formula, index + 1));
        if (token.getType() != Token.Type.COLON) {
            throw new IllegalArgumentException("parseTernaryExpression: found " + String.valueOf(token) + ", expected COLON");
        }
        Node alternatives = new Node(Node.Operation.ALTERNATIVE, stack.pop());
        ternary.setRightHandSide(alternatives);
        index = FormulaParser.parseAdditiveExpression(stack, tokens, formula, index + 1);
        alternatives.setRightHandSide(stack.pop());
        stack.push(ternary);
        return index;
    }

    public static int parseConditionalOrExpression(Stack<Node> stack, List<Token> tokens, String formula, int index) throws IllegalArgumentException {
        Node lhs;
        if (index >= tokens.size()) {
            return tokens.size();
        }
        if ((index = FormulaParser.parseConditionalAndExpression(stack, tokens, formula, index)) >= tokens.size()) {
            return tokens.size();
        }
        Token token = tokens.get(index);
        switch (token.getType()) {
            case OR: {
                lhs = new Node(Node.Operation.OR, stack.pop());
                ++index;
                break;
            }
            default: {
                return index;
            }
        }
        index = FormulaParser.parseConditionalOrExpression(stack, tokens, formula, index);
        stack.push(FormulaParser.prioritize(lhs, stack.pop()));
        return index;
    }

    public static int parseConditionalAndExpression(Stack<Node> stack, List<Token> tokens, String formula, int index) throws IllegalArgumentException {
        Node lhs;
        if (index >= tokens.size()) {
            return tokens.size();
        }
        if ((index = FormulaParser.parseValueLogical(stack, tokens, formula, index)) >= tokens.size()) {
            return tokens.size();
        }
        Token token = tokens.get(index);
        switch (token.getType()) {
            case AND: {
                lhs = new Node(Node.Operation.AND, stack.pop());
                ++index;
                break;
            }
            default: {
                return index;
            }
        }
        index = FormulaParser.parseConditionalAndExpression(stack, tokens, formula, index);
        stack.push(FormulaParser.prioritize(lhs, stack.pop()));
        return index;
    }

    static int parseValueLogical(Stack<Node> stack, List<Token> tokens, String formula, int index) throws IllegalArgumentException {
        if (index >= tokens.size()) {
            return tokens.size();
        }
        return FormulaParser.parseRelationalExpression(stack, tokens, formula, index);
    }

    static int parseRelationalExpression(Stack<Node> stack, List<Token> tokens, String formula, int index) throws IllegalArgumentException {
        Node lhs;
        if (index >= tokens.size()) {
            return tokens.size();
        }
        if ((index = FormulaParser.parseNumericExpression(stack, tokens, formula, index)) >= tokens.size()) {
            return tokens.size();
        }
        Token token = tokens.get(index);
        switch (token.getType()) {
            case LIKE: {
                lhs = new Node(Node.Operation.LIKE, stack.pop());
                ++index;
                break;
            }
            case EQ: {
                lhs = new Node(Node.Operation.EQ, stack.pop());
                ++index;
                break;
            }
            case NEQ: {
                lhs = new Node(Node.Operation.NEQ, stack.pop());
                ++index;
                break;
            }
            case LT: {
                lhs = new Node(Node.Operation.LT, stack.pop());
                ++index;
                break;
            }
            case LTE: {
                lhs = new Node(Node.Operation.LTE, stack.pop());
                ++index;
                break;
            }
            case GT: {
                lhs = new Node(Node.Operation.GT, stack.pop());
                ++index;
                break;
            }
            case GTE: {
                lhs = new Node(Node.Operation.GTE, stack.pop());
                ++index;
                break;
            }
            default: {
                return index;
            }
        }
        index = FormulaParser.parseRelationalExpression(stack, tokens, formula, index);
        stack.push(FormulaParser.prioritize(lhs, stack.pop()));
        return index;
    }

    static int parseNumericExpression(Stack<Node> stack, List<Token> tokens, String formula, int index) throws IllegalArgumentException {
        if (index >= tokens.size()) {
            return tokens.size();
        }
        return FormulaParser.parseAdditiveExpression(stack, tokens, formula, index);
    }

    static int parseAdditiveExpression(Stack<Node> stack, List<Token> tokens, String formula, int index) throws IllegalArgumentException {
        Node lhs;
        if (index >= tokens.size()) {
            return tokens.size();
        }
        if ((index = FormulaParser.parseMultiplicativeExpression(stack, tokens, formula, index)) >= tokens.size()) {
            return tokens.size();
        }
        Token token = tokens.get(index);
        switch (token.getType()) {
            case PLUS: {
                lhs = new Node(Node.Operation.PLUS, stack.pop());
                ++index;
                break;
            }
            case MINUS: {
                lhs = new Node(Node.Operation.MINUS, stack.pop());
                ++index;
                break;
            }
            default: {
                return index;
            }
        }
        index = FormulaParser.parseAdditiveExpression(stack, tokens, formula, index);
        stack.push(FormulaParser.prioritize(lhs, stack.pop()));
        return index;
    }

    static int parseMultiplicativeExpression(Stack<Node> stack, List<Token> tokens, String formula, int index) throws IllegalArgumentException {
        Node lhs;
        if (index >= tokens.size()) {
            return tokens.size();
        }
        if ((index = FormulaParser.parseUnaryExpression(stack, tokens, formula, index)) >= tokens.size()) {
            return tokens.size();
        }
        Token token = tokens.get(index);
        switch (token.getType()) {
            case MUL: {
                lhs = new Node(Node.Operation.MUL, stack.pop());
                ++index;
                break;
            }
            case DIV: {
                lhs = new Node(Node.Operation.DIV, stack.pop());
                ++index;
                break;
            }
            case MOD: {
                lhs = new Node(Node.Operation.MOD, stack.pop());
                ++index;
                break;
            }
            default: {
                return index;
            }
        }
        index = FormulaParser.parseMultiplicativeExpression(stack, tokens, formula, index);
        stack.push(FormulaParser.prioritize(lhs, stack.pop()));
        return index;
    }

    static int parseUnaryExpression(Stack<Node> stack, List<Token> tokens, String formula, int index) throws IllegalArgumentException {
        if (index >= tokens.size()) {
            return tokens.size();
        }
        Token token = tokens.get(index);
        switch (token.getType()) {
            case NOT: {
                index = FormulaParser.parsePrimaryExpression(stack, tokens, formula, index + 1);
                stack.push(new Node(Node.Operation.NOT, stack.pop()));
                break;
            }
            case PLUS: {
                index = FormulaParser.parsePrimaryExpression(stack, tokens, formula, index + 1);
                stack.push(new Node(Node.Operation.UNARY_PLUS, stack.pop()));
                break;
            }
            case MINUS: {
                index = FormulaParser.parsePrimaryExpression(stack, tokens, formula, index + 1);
                stack.push(new Node(Node.Operation.UNARY_MINUS, stack.pop()));
                break;
            }
            default: {
                index = FormulaParser.parsePrimaryExpression(stack, tokens, formula, index);
            }
        }
        return index;
    }

    static int parsePrimaryExpression(Stack<Node> stack, List<Token> tokens, String formula, int index) throws IllegalArgumentException {
        if (index >= tokens.size()) {
            return tokens.size();
        }
        int newIndex = FormulaParser.parseBrackettedExpression(stack, tokens, formula, index);
        if (newIndex == index && (newIndex = FormulaParser.parseFunctionElement(stack, tokens, formula, index)) == index) {
            newIndex = FormulaParser.parseExpressionElement(stack, tokens, formula, index);
        }
        if (newIndex == index) {
            throw new IllegalArgumentException("parsePrimaryExpression: expected [brackettedExpression|functionElement|expressionElement]");
        }
        return newIndex;
    }

    static int parseBrackettedExpression(Stack<Node> stack, List<Token> tokens, String formula, int index) throws IllegalArgumentException {
        if (index >= tokens.size()) {
            return tokens.size();
        }
        Token token = tokens.get(index);
        switch (token.getType()) {
            case LPAREN: {
                index = FormulaParser.parseConditionalOrExpression(stack, tokens, formula, index + 1);
                Token current = FormulaParser.peek(tokens, index);
                if (current.getType() != Token.Type.RPAREN) {
                    throw new IllegalArgumentException("term: Found " + (Object)((Object)current.getType()) + " @ " + current.getPos() + " expected RPAREN");
                }
                stack.push(new Node(Node.Operation.GROUP, stack.pop()));
                ++index;
            }
        }
        return index;
    }

    static int parseFunctionElement(Stack<Node> stack, List<Token> tokens, String formula, int index) throws IllegalArgumentException {
        if (index >= tokens.size()) {
            return tokens.size();
        }
        Token token = tokens.get(index);
        switch (token.getType()) {
            case FUNCTION: {
                Token next = FormulaParser.peek(tokens, index + 1);
                String value = formula.substring(token.getPos(), token.getPos() + token.getLength() - 1);
                Node function = new Node(Node.Operation.FUNCTION, new Terminal(Terminal.Type.IDENT, value));
                if (next.getType() != Token.Type.RPAREN) {
                    index = FormulaParser.parseArgs(stack, tokens, formula, index + 1);
                    function.setRightHandSide(stack.pop());
                    Token current = FormulaParser.peek(tokens, index);
                    if (current.getType() != Token.Type.RPAREN) {
                        throw new IllegalArgumentException("term: Found " + (Object)((Object)current.getType()) + " @ " + current.getPos() + ". Expected RPAREN");
                    }
                }
                stack.push(function);
                ++index;
                break;
            }
        }
        return index;
    }

    static int parseExpressionElement(Stack<Node> stack, List<Token> tokens, String formula, int index) throws IllegalArgumentException {
        if (index >= tokens.size()) {
            return tokens.size();
        }
        Token token = tokens.get(index);
        switch (token.getType()) {
            case STRING: {
                String value = formula.substring(token.getPos() + 1, token.getPos() + token.getLength() - 1);
                stack.push(new Terminal(Terminal.Type.STRING, value));
                ++index;
                break;
            }
            case IDENT: {
                String value = formula.substring(token.getPos(), token.getPos() + token.getLength());
                stack.push(new Terminal(Terminal.Type.IDENT, value));
                ++index;
                break;
            }
            case NUMBER: {
                String value = formula.substring(token.getPos(), token.getPos() + token.getLength());
                stack.push(new Terminal(Terminal.Type.NUMBER, value));
                ++index;
                break;
            }
            case BOOL: {
                String value = formula.substring(token.getPos(), token.getPos() + token.getLength());
                stack.push(new Terminal(Terminal.Type.BOOL, value));
                ++index;
            }
            default: {
                index = FormulaParser.parsePropertyRef(stack, tokens, formula, index);
            }
        }
        return index;
    }

    static int parseArgs(Stack<Node> stack, List<Token> tokens, String formula, int index) throws IllegalArgumentException {
        if (index >= tokens.size()) {
            return tokens.size();
        }
        Node previous = null;
        block3: while (index < tokens.size()) {
            Node arg;
            index = FormulaParser.parseConditionalOrExpression(stack, tokens, formula, index);
            Node node = arg = previous == null ? stack.peek() : stack.pop();
            if (previous != null) {
                previous.setRightHandSide(arg);
            }
            previous = arg;
            Token current = tokens.get(index);
            switch (current.getType()) {
                case COMMA: {
                    ++index;
                    continue block3;
                }
            }
            return index;
        }
        return index;
    }

    static int parsePropertyRef(Stack<Node> stack, List<Token> tokens, String formula, int index) throws IllegalArgumentException {
        if (index >= tokens.size()) {
            return tokens.size();
        }
        Token token = tokens.get(index);
        switch (token.getType()) {
            case ATTRIBUTE: 
            case DOLLAR: {
                Token current = token;
                int dollarCount = 0;
                while (current.getType() == Token.Type.DOLLAR) {
                    if (++dollarCount > 1) {
                        throw new IllegalArgumentException("term: " + (Object)((Object)current.getType()) + " @ " + current.getPos() + " not expected");
                    }
                    current = FormulaParser.peek(tokens, ++index);
                }
                Terminal.Type attrType = Terminal.Type.values()[dollarCount];
                if (current.getType() != Token.Type.ATTRIBUTE) {
                    throw new IllegalArgumentException("term: Found " + (Object)((Object)current.getType()) + " @ " + current.getPos() + ". Expected ATTRIBUTE");
                }
                if ((current = FormulaParser.peek(tokens, ++index)).getType() != Token.Type.IDENT) {
                    throw new IllegalArgumentException("term: Found " + (Object)((Object)current.getType()) + " @ " + current.getPos() + ". Expected IDENT");
                }
                String value = formula.substring(current.getPos(), current.getPos() + current.getLength());
                if ((current = FormulaParser.peek(tokens, ++index)).getType() != Token.Type.RPAREN) {
                    throw new IllegalArgumentException("term: Found " + (Object)((Object)current.getType()) + " @ " + current.getPos() + ". Expected RPAREN");
                }
                stack.push(new Terminal(attrType, value));
                ++index;
                break;
            }
        }
        return index;
    }

    static Token peek(List<Token> tokens, int offset) {
        int index = 0 <= offset && offset <= tokens.size() - 1 ? offset : tokens.size() - 1;
        return tokens.get(index);
    }

    static Node prioritize(Node lhs, Node rhs) {
        if (rhs.getOperation() != Node.Operation.TERMINAL) {
            int c = FormulaParser.comparePrec(lhs, rhs);
            if (c == 0) {
                lhs.setRightHandSide(rhs.getLeftHandSide());
                Node rightHandSide = rhs.getRightHandSide();
                rhs.setLeftHandSide(lhs);
                rhs.setRightHandSide(rightHandSide);
                return rhs;
            }
            if (c > 0) {
                Node leftHandSide = rhs.getLeftHandSide();
                rhs.setLeftHandSide(lhs);
                lhs.setRightHandSide(leftHandSide);
                return lhs;
            }
            lhs.setRightHandSide(rhs);
            return lhs;
        }
        lhs.setRightHandSide(rhs);
        return lhs;
    }

    public static String dump(Node node) {
        if (node == null) {
            return null;
        }
        if (node instanceof Terminal) {
            String s = ((Terminal)node).getValue();
            if (((Terminal)node).type == Terminal.Type.IN_PROCESS_ATTRIBUTE) {
                s = "$(".concat(s).concat(")");
            } else if (((Terminal)node).type == Terminal.Type.CURRENT_ATTRIBUTE) {
                s = "$$(".concat(s).concat(")");
            } else if (((Terminal)node).type == Terminal.Type.BOOL) {
                s = "$$(".concat(s).concat(")");
            }
            return s;
        }
        String lhs = FormulaParser.dump(node.getLeftHandSide());
        String rhs = FormulaParser.dump(node.getRightHandSide());
        Node.Operation operation = node.getOperation();
        return "[" + (Object)((Object)operation) + "|" + lhs + "|" + rhs + "]";
    }

    public static class Terminal
    extends Node {
        public final Type type;
        final String value;

        Terminal(Type type, String value) {
            super(Node.Operation.TERMINAL, null);
            this.type = type;
            this.value = value;
        }

        public final String getValue() {
            return this.value;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Terminal other = (Terminal)obj;
            if (this.type != other.type) {
                return false;
            }
            return !(this.value != null ? !this.value.equals(other.value) : other.value != null);
        }

        public static enum Type {
            IN_PROCESS_ATTRIBUTE,
            CURRENT_ATTRIBUTE,
            NUMBER,
            IDENT,
            STRING,
            BOOL;

        }
    }

    public static class Node {
        private final Operation operation;
        private Node leftHandSide;
        private Node rightHandSide;

        Node(Operation operation, Node leftHandSide) {
            this.operation = operation;
            this.leftHandSide = leftHandSide;
        }

        final Operation getOperation() {
            return this.operation;
        }

        Node getLeftHandSide() {
            return this.leftHandSide;
        }

        void setLeftHandSide(Node leftHandSide) {
            this.leftHandSide = leftHandSide;
        }

        Node getRightHandSide() {
            return this.rightHandSide;
        }

        void setRightHandSide(Node rightHandSide) {
            this.rightHandSide = rightHandSide;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Node other = (Node)obj;
            if (this.leftHandSide != null ? !this.leftHandSide.equals(other.leftHandSide) : other.leftHandSide != null) {
                return false;
            }
            return this.rightHandSide != null ? this.rightHandSide.equals(other.rightHandSide) : other.rightHandSide == null;
        }

        static enum Operation {
            UNARY_PLUS(6),
            UNARY_MINUS(6),
            PLUS(3),
            MINUS(3),
            MUL(4),
            DIV(4),
            MOD(4),
            AND(1),
            OR(1),
            EQ(2),
            LIKE(2),
            NEQ(2),
            LT(2),
            LTE(2),
            GT(2),
            GTE(2),
            TERNARY(0),
            ALTERNATIVE(0),
            NOT(6),
            LOWER(6),
            UPPER(6),
            FUNCTION(6),
            GROUP(-1),
            TERMINAL(-1);

            final int prec;

            private Operation(int precedence) {
                this.prec = precedence;
            }

            public int getPrec() {
                return this.prec;
            }
        }
    }

    public static class Token {
        private final Type type;
        private final int pos;
        private final int length;

        Token(Type type, int pos, int length) {
            this.type = type;
            this.pos = pos;
            this.length = length;
        }

        public Type getType() {
            return this.type;
        }

        public int getPos() {
            return this.pos;
        }

        public int getLength() {
            return this.length;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Token other = (Token)obj;
            return this.type == other.type && this.pos == other.pos && this.length == other.length;
        }

        public static enum Type {
            AND,
            COLON,
            COMMA,
            DIV,
            DOLLAR,
            EQ,
            FUNCTION,
            ATTRIBUTE,
            GT,
            GTE,
            IDENT,
            LPAREN,
            LT,
            LTE,
            MINUS,
            MOD,
            MUL,
            NEQ,
            NOT,
            NUMBER,
            OR,
            PLUS,
            QUESTION_MARK,
            RPAREN,
            STRING,
            LIKE,
            BOOL,
            WS;

        }
    }
}

