/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.shared;

import com.oracle.iot.shared.FormulaParser;
import com.oracle.iot.shared.ValueProvider;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Formula {
    FormulaParser.Node tree;
    private static final Logger LOGGER = Logger.getLogger("com.oracle.iot.shared");

    public Formula(String formula) {
        List<FormulaParser.Token> tokens = FormulaParser.tokenize(formula);
        this.tree = FormulaParser.parseFormula(tokens, formula);
    }

    public Object compute(ValueProvider vp) {
        return Formula.compute(this.tree, vp);
    }

    public String dump() {
        return FormulaParser.dump(this.tree);
    }

    public static Object compute(FormulaParser.Node node, ValueProvider vp) {
        if (node == null) {
            return Double.NaN;
        }
        if (node instanceof FormulaParser.Terminal) {
            FormulaParser.Terminal terminal = (FormulaParser.Terminal)node;
            String attr = ((FormulaParser.Terminal)node).getValue();
            switch (terminal.type) {
                case CURRENT_ATTRIBUTE: {
                    try {
                        Object value = vp.getCurrentValue(attr);
                        if (value instanceof Number) {
                            return ((Number)value).doubleValue();
                        }
                        if (value instanceof Boolean) {
                            return (Boolean)value != false ? 1.0 : 0.0;
                        }
                        if (value instanceof String) {
                            return value;
                        }
                    }
                    catch (ClassCastException e) {
                        Formula.getLogger().log(Level.WARNING, e.getMessage());
                    }
                    break;
                }
                case IN_PROCESS_ATTRIBUTE: {
                    try {
                        Object value = vp.getInProcessValue(attr);
                        if (value != null || (value = vp.getCurrentValue(attr)) != null) {
                            if (value instanceof Number) {
                                return ((Number)value).doubleValue();
                            }
                            if (value instanceof Boolean) {
                                return (Boolean)value != false ? 1.0 : 0.0;
                            }
                            if (value instanceof String) {
                                return value;
                            }
                        }
                    }
                    catch (ClassCastException e) {
                        Formula.getLogger().log(Level.WARNING, e.getMessage());
                    }
                    break;
                }
                case NUMBER: {
                    try {
                        Double value = Double.valueOf(attr);
                        return value;
                    }
                    catch (NumberFormatException e) {
                        Formula.getLogger().log(Level.WARNING, e.getMessage());
                    }
                }
                case BOOL: {
                    Boolean value = Boolean.valueOf(attr);
                    return new Double(value != false ? 1.0 : 0.0);
                }
                case STRING: 
                case IDENT: {
                    return attr;
                }
            }
            return Double.NaN;
        }
        if (node.getOperation() == FormulaParser.Node.Operation.TERNARY) {
            Double cond = (Double)Formula.compute(node.getLeftHandSide(), vp);
            if (cond.compareTo(1.0) == 0) {
                return Formula.compute(node.getRightHandSide().getLeftHandSide(), vp);
            }
            return Formula.compute(node.getRightHandSide().getRightHandSide(), vp);
        }
        if (node.getOperation() == FormulaParser.Node.Operation.GROUP) {
            return Formula.compute(node.getLeftHandSide(), vp);
        }
        FormulaParser.Node.Operation operation = node.getOperation();
        Comparable lhsComp = (Comparable)Formula.compute(node.getLeftHandSide(), vp);
        Comparable rhsComp = (Comparable)Formula.compute(node.getRightHandSide(), vp);
        switch (operation) {
            case FUNCTION: {
                String fn = ((FormulaParser.Terminal)node.getLeftHandSide()).getValue();
                if ("LOWER".equalsIgnoreCase(fn)) {
                    String str = (String)String.class.cast(rhsComp);
                    return str != null ? str.toLowerCase(Locale.ROOT) : "";
                }
                if ("UPPER".equalsIgnoreCase(fn)) {
                    String str = (String)String.class.cast(rhsComp);
                    return str != null ? str.toUpperCase(Locale.ROOT) : "";
                }
                Formula.getLogger().log(Level.WARNING, "unknown function '" + fn + "'");
            }
            case LOWER: {
                return ((String)((Object)lhsComp)).toLowerCase(Locale.ROOT);
            }
            case UPPER: {
                return ((String)((Object)lhsComp)).toUpperCase(Locale.ROOT);
            }
            case EQ: {
                if (lhsComp.getClass() == rhsComp.getClass()) {
                    return lhsComp.compareTo(rhsComp) == 0 ? 1.0 : 0.0;
                }
                return 0.0;
            }
            case NEQ: {
                if (lhsComp.getClass() == rhsComp.getClass()) {
                    return lhsComp.compareTo(rhsComp) == 0 ? 0.0 : 1.0;
                }
                return 1.0;
            }
            case PLUS: {
                if (!(lhsComp instanceof String) || !(rhsComp instanceof String)) break;
                String lhsString = (String)((Object)lhsComp);
                String rhsString = (String)((Object)rhsComp);
                return lhsString.concat(rhsString);
            }
            case LIKE: {
                if (lhsComp instanceof String && rhsComp instanceof String) {
                    String lhsString = (String)((Object)lhsComp);
                    String rhsString = (String)((Object)rhsComp);
                    return Formula.sqlMatches(lhsString, rhsString) ? 1.0 : 0.0;
                }
                return 0.0;
            }
        }
        Double lhs = (Double)lhsComp;
        Double rhs = (Double)rhsComp;
        switch (operation) {
            case UNARY_MINUS: {
                return -lhs.doubleValue();
            }
            case UNARY_PLUS: {
                return (double)lhs;
            }
            case DIV: {
                return lhs / rhs;
            }
            case MUL: {
                return lhs * rhs;
            }
            case PLUS: {
                return lhs + rhs;
            }
            case MINUS: {
                return lhs - rhs;
            }
            case MOD: {
                return lhs % rhs;
            }
            case OR: {
                if (lhs.isNaN()) {
                    return rhs.isNaN() ? 0.0 : 1.0;
                }
                return lhs.compareTo(0.0) != 0 || rhs.compareTo(0.0) != 0 ? 1.0 : 0.0;
            }
            case AND: {
                if (lhs.isNaN() || rhs.isNaN()) {
                    return 0.0;
                }
                return lhs.compareTo(0.0) != 0 && rhs.compareTo(0.0) != 0 ? 1.0 : 0.0;
            }
            case GT: {
                if (lhs.isNaN()) {
                    return 0.0;
                }
                if (rhs.isNaN()) {
                    return 1.0;
                }
                return lhs.compareTo(rhs) > 0 ? 1.0 : 0.0;
            }
            case GTE: {
                if (lhs.isNaN()) {
                    return rhs.isNaN() ? 1.0 : 0.0;
                }
                if (rhs.isNaN()) {
                    return 1.0;
                }
                return lhs.compareTo(rhs) >= 0 ? 1.0 : 0.0;
            }
            case LT: {
                if (lhs.isNaN()) {
                    return 0.0;
                }
                if (rhs.isNaN()) {
                    return 1.0;
                }
                return lhs.compareTo(rhs) < 0 ? 1.0 : 0.0;
            }
            case LTE: {
                if (lhs.isNaN()) {
                    return rhs.isNaN() ? 1.0 : 0.0;
                }
                if (rhs.isNaN()) {
                    return 1.0;
                }
                return lhs.compareTo(rhs) <= 0 ? 1.0 : 0.0;
            }
            case TERNARY: {
                break;
            }
            case ALTERNATIVE: {
                break;
            }
            case NOT: {
                return lhs.compareTo(1.0) == 0 ? 0.0 : 1.0;
            }
            case FUNCTION: {
                break;
            }
            case GROUP: {
                break;
            }
        }
        return Double.NaN;
    }

    private static boolean sqlMatches(String s, String regEx) {
        StringBuilder sb = new StringBuilder();
        int prev = 0;
        int len = regEx.length();
        for (int i = 0; i < len; ++i) {
            int next = regEx.charAt(i);
            if (next == 95) {
                if (prev == 92) {
                    sb.deleteCharAt(i - 1);
                } else {
                    next = 46;
                }
            } else if (next == 37) {
                if (prev == 92) {
                    sb.deleteCharAt(i - 1);
                } else {
                    sb.append('.');
                    next = 42;
                }
            }
            sb.append((char)next);
            prev = next;
        }
        return s.matches(sb.toString());
    }

    private static Logger getLogger() {
        return LOGGER;
    }
}

