/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.message;

import com.oracle.iot.client.impl.util.Base64;
import com.oracle.iot.client.message.Message;
import com.oracle.iot.client.message.MessageParsingException;
import com.oracle.iot.client.message.RequestMessage;
import com.oracle.iot.client.message.StatusCode;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class ResponseMessage
extends Message {
    private final Map<String, List<String>> headers;
    private final StatusCode statusCode;
    private final String url;
    private final byte[] body;
    private final String requestId;

    private ResponseMessage(Builder builder) {
        super(builder);
        this.requestId = builder.requestId != null ? builder.requestId : null;
        this.headers = builder.headers == null ? Collections.emptyMap() : Collections.unmodifiableMap(new HashMap(builder.headers));
        this.url = builder.url == null ? "" : builder.url;
        this.body = builder.body == null ? new byte[0] : Arrays.copyOf(builder.body, builder.body.length);
        this.statusCode = builder.statusCode == null ? StatusCode.OK : builder.statusCode;
    }

    public final Map<String, List<String>> getHeaders() {
        return Collections.unmodifiableMap(this.headers);
    }

    public final List<String> getHeaderValues(String name) {
        if (name != null) {
            name = name.toLowerCase(Locale.ROOT);
            return Collections.unmodifiableList(this.headers.get(name));
        }
        return Collections.emptyList();
    }

    public final String getHeaderValue(String name, int index) {
        List<String> values;
        if (name != null) {
            name = name.toLowerCase(Locale.ROOT);
        }
        if ((values = this.headers.get(name)) != null && values.size() > index) {
            return this.headers.get(name).get(index);
        }
        return null;
    }

    public final String getHeaderValue(String name) {
        List<String> values;
        if (name != null) {
            name = name.toLowerCase(Locale.ROOT);
        }
        if ((values = this.headers.get(name)) != null && values.size() > 0) {
            return values.get(0);
        }
        return null;
    }

    public final String getURL() {
        return this.url;
    }

    public final byte[] getBody() {
        return Arrays.copyOf(this.body, this.body.length);
    }

    public final String getBodyString() {
        try {
            return new String(this.getBody(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public final StatusCode getStatusCode() {
        return this.statusCode;
    }

    public String getRequestId() {
        return this.requestId;
    }

    @Override
    public Message.Type getType() {
        return Message.Type.RESPONSE;
    }

    @Override
    public final String toString() {
        return this.toJson().toString();
    }

    @Override
    public final JSONObject toJson() {
        return Message.Utils.bodyToJson(this, null, Message.Type.RESPONSE, this.statusCode, null, this.url, this.requestId, this.headers, this.body);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResponseMessage that = (ResponseMessage)o;
        if (!Arrays.equals(this.body, that.body)) {
            return false;
        }
        if (!this.headers.equals(that.headers)) {
            return false;
        }
        if (this.statusCode != that.statusCode) {
            return false;
        }
        if (!this.url.equals(that.url)) {
            return false;
        }
        return this.requestId.equals(that.requestId);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.headers.hashCode();
        result = 31 * result + this.statusCode.hashCode();
        result = 31 * result + this.url.hashCode();
        result = 31 * result + this.requestId.hashCode();
        result = 31 * result + Message.Utils.hashCodeByteArray(this.body);
        return result;
    }

    public static final class Builder
    extends Message.MessageBuilder<Builder> {
        private final Map<String, List<String>> headers = new HashMap<String, List<String>>();
        private StatusCode statusCode;
        private String url;
        private String requestId;
        private byte[] body;

        public Builder() {
        }

        public Builder(RequestMessage requestMessage) {
            this.source = requestMessage.destination;
            this.destination = requestMessage.source;
            this.requestId = requestMessage.id;
        }

        public final Builder header(String name, List<String> values) {
            String lowerName;
            Message.Utils.checkNullValueThrowsNPE(name, "ResponseMessage: Header name");
            Message.Utils.checkNullValuesThrowsNPE(values, "ResponseMessage: Header values");
            if (!Message.Utils.isHttpHeaderAsciiPrintable(name, values)) {
                throw new IllegalArgumentException("ResponseMessage: Header contains non-ASCII printable characters");
            }
            if (values == null) {
                values = new ArrayList<String>();
            }
            if (this.headers.containsKey(lowerName = name.toLowerCase(Locale.ROOT))) {
                ArrayList<String> newValues = new ArrayList<String>((Collection)this.headers.get(lowerName));
                newValues.addAll(values);
                this.headers.put(lowerName, Collections.unmodifiableList(new ArrayList(newValues)));
            } else {
                this.headers.put(lowerName, Collections.unmodifiableList(new ArrayList<String>(values)));
            }
            return this.self();
        }

        public final Builder contentType(String contentType) {
            Message.Utils.checkNullValueThrowsNPE(contentType, "ResponseMessage: Content type");
            this.header("Content-Type", Arrays.asList(contentType));
            return this.self();
        }

        public final Builder url(String url) {
            this.url = url;
            return this.self();
        }

        public final Builder body(byte[] body) {
            this.body = Arrays.copyOf(body, body.length);
            return this.self();
        }

        public final Builder body(String body) {
            try {
                return this.body(body.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }

        public final Builder statusCode(StatusCode statusCode) {
            this.statusCode = statusCode;
            return this.self();
        }

        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this.self();
        }

        @Override
        public final Builder fromJson(JSONObject jsonObject) {
            byte[] body;
            StatusCode statusCode;
            super.fromJson(jsonObject);
            JSONObject payload = jsonObject.optJSONObject("payload");
            Message.Utils.checkNullValueAndThrowMPE(payload, "response.message.payload.null");
            try {
                statusCode = StatusCode.valueOf(payload.getInt("statusCode"));
            }
            catch (JSONException e) {
                throw new MessageParsingException(e);
            }
            catch (NullPointerException e) {
                throw new MessageParsingException("response.message.status.null", e);
            }
            catch (ClassCastException e) {
                throw new MessageParsingException("response.message.status.notNumber", e);
            }
            catch (IllegalArgumentException e) {
                throw new MessageParsingException("response.message.status.wrong", e);
            }
            String url = payload.optString("url", null);
            String requestId = payload.optString("requestId", null);
            Message.Utils.checkNullOrEmptyStringThrowMPE(requestId, "response.message.requestId.null");
            try {
                body = Base64.getDecoder().decode(payload.optString("body", null));
            }
            catch (IllegalArgumentException e) {
                throw new MessageParsingException("response.message.body.wrong");
            }
            catch (NullPointerException e) {
                throw new MessageParsingException("response.message.body.null");
            }
            this.statusCode(statusCode);
            this.url(url);
            this.body(body);
            this.requestId(requestId);
            JSONObject headers = payload.optJSONObject("headers");
            if (headers != null) {
                ArrayList<String> headerList = new ArrayList<String>();
                Iterator<String> keys = headers.keys();
                while (keys.hasNext()) {
                    String key = keys.next();
                    Object jsonValue = headers.opt(key);
                    if (!(jsonValue instanceof JSONArray)) continue;
                    JSONArray headerValues = (JSONArray)jsonValue;
                    int size = headerValues.length();
                    for (int i = 0; i < size; ++i) {
                        String headerValue = headerValues.optString(i, null);
                        headerList.add(headerValue);
                    }
                    this.header(key, headerList);
                    headerList.clear();
                }
            }
            return this.self();
        }

        @Override
        protected final Builder self() {
            return this;
        }

        @Override
        public ResponseMessage build() {
            return new ResponseMessage(this);
        }
    }
}

