/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.impl.device.mqtt;

import com.oracle.iot.client.HttpResponse;
import com.oracle.iot.client.impl.device.SendReceiveImpl;
import com.oracle.iot.client.impl.device.mqtt.MqttSecureConnection;
import com.oracle.iot.client.impl.device.mqtt.MqttSecureConnectionImpl;
import com.oracle.iot.client.message.Message;
import com.oracle.iot.client.message.StatusCode;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.paho.client.mqttv3.MqttMessage;

public final class MqttSendReceiveImpl
extends SendReceiveImpl {
    static final HttpResponse ACCEPTED = new HttpResponse(StatusCode.ACCEPTED.getCode(), new byte[0], null);
    private final MqttSecureConnectionImpl secureConnection;
    private final String publishMessagesTopic;
    private final String publishMessagesAcceptBytesTopic;
    private final String subscribeMessagesTopic;
    private final String subscribeMessagesErrorTopic;
    private final String subscribeMessagesAcceptBytesTopic;
    private int lastAvaliableBytes = -1;
    private static final int INTEGER_BYTES = 4;
    private static final Logger LOGGER = Logger.getLogger("oracle.iot.client");

    public MqttSendReceiveImpl(MqttSecureConnection secureConnection) {
        super(false);
        this.secureConnection = (MqttSecureConnectionImpl)secureConnection;
        this.publishMessagesTopic = "iotcs/" + this.secureConnection.getEndpointId() + "/messages";
        this.publishMessagesAcceptBytesTopic = "iotcs/" + this.secureConnection.getEndpointId() + "/messages/acceptBytes";
        this.subscribeMessagesTopic = "devices/" + this.secureConnection.getEndpointId() + "/messages";
        this.subscribeMessagesErrorTopic = "devices/" + this.secureConnection.getEndpointId() + "/messages/error";
        this.subscribeMessagesAcceptBytesTopic = "devices/" + this.secureConnection.getEndpointId() + "/messages/acceptBytes";
    }

    public void initialize() {
        this.secureConnection.setMqttSendReceiveImpl(this);
    }

    String[] getSubscribeTo() {
        return new String[]{this.subscribeMessagesTopic, this.subscribeMessagesErrorTopic, this.subscribeMessagesAcceptBytesTopic};
    }

    int[] getSubscribeQos() {
        return new int[]{1, 1, 1};
    }

    @Override
    protected synchronized void post(byte[] payload, int timeout) throws IOException, GeneralSecurityException {
        this.post(payload);
    }

    @Override
    protected synchronized void post(byte[] payload) throws IOException, GeneralSecurityException {
        int usedBytes;
        int requestBufferSize = this.getRequestBufferSize();
        int avaliableBytes = requestBufferSize - (usedBytes = this.getUsedBytes()) - 2;
        if (avaliableBytes != this.lastAvaliableBytes) {
            this.lastAvaliableBytes = avaliableBytes;
            byte[] acceptBytes = MqttSendReceiveImpl.toBytes(avaliableBytes);
            this.post(this.publishMessagesAcceptBytesTopic, acceptBytes, null);
        }
        this.post(this.publishMessagesTopic, payload, this.subscribeMessagesTopic);
    }

    private boolean post(String topic, byte[] payload, String expect) throws IOException, GeneralSecurityException {
        if (MqttSendReceiveImpl.getLogger().isLoggable(Level.FINER)) {
            String msg = "POST " + topic + " : " + Message.prettyPrintJson(payload);
            MqttSendReceiveImpl.getLogger().log(Level.FINER, msg);
        }
        HttpResponse response = this.secureConnection.publish(topic, payload, expect);
        int code = response.getStatus();
        if (MqttSendReceiveImpl.getLogger().isLoggable(Level.FINEST)) {
            MqttSendReceiveImpl.getLogger().log(Level.FINEST, response.getVerboseStatus("POST", topic));
        }
        if (code == 401 || code == 403) {
            response = this.secureConnection.publish(topic, payload, expect);
            code = response.getStatus();
        }
        if (code != 202) {
            MqttSecureConnection.getLogger().log(Level.INFO, response.getVerboseStatus("publish", topic));
            return false;
        }
        return true;
    }

    HttpResponse handleMessage(String topic, MqttMessage mqttMessage) {
        byte[] msgBytes;
        if (!topic.startsWith(this.subscribeMessagesTopic)) {
            return null;
        }
        MqttSecureConnection.getLogger().log(Level.FINEST, topic);
        final byte[] payload = mqttMessage.getPayload();
        if (payload.length == 0) {
            return ACCEPTED;
        }
        if (this.subscribeMessagesTopic.equals(topic)) {
            if (2 < payload.length) {
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        MqttSendReceiveImpl.this.bufferRequest(payload);
                    }
                });
                thread.start();
            }
            return ACCEPTED;
        }
        if (this.subscribeMessagesErrorTopic.equals(topic)) {
            return MqttSecureConnectionImpl.getErrorResponse(payload);
        }
        if (this.subscribeMessagesAcceptBytesTopic.equals(topic)) {
            this.handleAcceptBytes(mqttMessage.getPayload());
            return ACCEPTED;
        }
        String msg = "unexpected topic: " + topic;
        try {
            msgBytes = msg.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        MqttSendReceiveImpl.getLogger().log(Level.SEVERE, msg);
        return new HttpResponse(StatusCode.OTHER.getCode(), msgBytes, null);
    }

    private void handleAcceptBytes(final byte[] payload) {
        if (payload.length > 4) {
            MqttSendReceiveImpl.getLogger().log(Level.SEVERE, this.subscribeMessagesAcceptBytesTopic + " ignored. Expected <= " + 4 + " bytes payload, received:" + Arrays.toString(payload));
            return;
        }
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                int requestBufferSize = MqttSendReceiveImpl.this.getRequestBufferSize();
                int usedBytes = MqttSendReceiveImpl.this.getUsedBytes();
                int availableBytes = requestBufferSize - usedBytes - 2;
                int minAcceptBytes = MqttSendReceiveImpl.toInt(payload);
                if (minAcceptBytes > requestBufferSize) {
                    MqttSendReceiveImpl.getLogger().log(Level.SEVERE, "The server has a request of " + minAcceptBytes + " bytes for this client, which is too large for the " + requestBufferSize + " byte request buffer. Please " + "restart the client with larger value for " + "oracle.iot.client.device.request_buffer_size");
                } else if (minAcceptBytes > availableBytes) {
                    MqttSendReceiveImpl.getLogger().log(Level.WARNING, "The server has a request of " + minAcceptBytes + " bytes for this client, which cannot be sent because " + "the " + requestBufferSize + " byte request buffer is " + "filled with " + usedBytes + " of unprocessed requests");
                }
            }
        });
        thread.setDaemon(false);
        thread.start();
    }

    static int toInt(byte[] buf) {
        int ival = 0;
        for (int n = 0; n < buf.length; ++n) {
            ival <<= 8;
            ival |= buf[n] & 0xFF;
        }
        return ival;
    }

    static byte[] toBytes(int ival) {
        byte[] buf = new byte[4];
        for (int n = 3; 0 <= n; --n) {
            int byteval = ival & 0xFF;
            buf[n] = (byte)byteval;
            ival >>>= 8;
        }
        return buf;
    }

    private static Logger getLogger() {
        return LOGGER;
    }
}

