/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.impl.device;

import com.oracle.iot.client.impl.device.Utils;
import com.oracle.iot.client.message.Message;
import com.oracle.iot.client.message.MessageParsingException;
import com.oracle.iot.client.message.RequestMessage;
import com.oracle.iot.client.message.ResponseMessage;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public abstract class SendReceiveImpl {
    private static final short DEFAULT_REQUEST_BUFFER_SIZE = 4192;
    private static final short DEFAULT_SEND_RECEIVE_TIMEOUT = 100;
    protected static final String REQUEST_BUFFER_SIZE_PROPERTY = "oracle.iot.client.device.request_buffer_size";
    private static final String SEND_RECEIVE_TIMEOUT_PROPERTY = "oracle.iot.client.device.send_receive_timeout";
    private static final String DISABLE_LONG_POLLING_PROPERTY = "com.oracle.iot.client.disable_long_polling";
    private static final int USE_DEFAULT_TIMEOUT_VALUE = -1;
    private final byte[] requestBuffer;
    private int head;
    private int tail;
    protected final boolean useLongPolling;
    private final short sendReceiveTimeLimit;
    private long sendCallTime;
    private static final Logger LOGGER = Logger.getLogger("oracle.iot.client");

    protected static boolean isLongPollingDisabled() {
        String disableLongPollingPropertyValue = System.getProperty(DISABLE_LONG_POLLING_PROPERTY);
        return "".equals(disableLongPollingPropertyValue) || Boolean.parseBoolean(disableLongPollingPropertyValue);
    }

    private static short getShortPropertyValue(String key, short defaultValue) {
        short imax = Utils.getShortProperty(key, defaultValue);
        short max = imax > defaultValue ? imax : defaultValue;
        return max > 0 ? max : defaultValue;
    }

    private static short getSendReceiveTimeout(String key, short defaultValue) {
        short imax = Utils.getShortProperty(key, defaultValue);
        if (imax == 0) {
            return 0;
        }
        short max = imax > defaultValue ? imax : defaultValue;
        return max > 0 ? max : defaultValue;
    }

    protected SendReceiveImpl(boolean useLongPolling) {
        short requestBufferSize = SendReceiveImpl.getShortPropertyValue(REQUEST_BUFFER_SIZE_PROPERTY, (short)4192);
        this.sendReceiveTimeLimit = SendReceiveImpl.getSendReceiveTimeout(SEND_RECEIVE_TIMEOUT_PROPERTY, (short)100);
        this.requestBuffer = new byte[requestBufferSize];
        this.tail = 0;
        this.head = 0;
        this.sendCallTime = -1L;
        this.useLongPolling = useLongPolling;
    }

    public final void send(Message ... messages) throws IOException, GeneralSecurityException {
        byte[] payload = null;
        if (messages != null && messages.length > 0) {
            JSONArray jsonArray = new JSONArray();
            for (Message message : messages) {
                if (message instanceof RequestMessage) {
                    if (message.getDestination() != null && message.getDestination().equals(message.getSource())) {
                        JSONObject jsonObject = message.toJson();
                        String jsonString = "[" + jsonObject.toString() + "]";
                        byte[] buf = jsonString.getBytes(Charset.forName("UTF-8"));
                        if (buf.length < this.getRequestBufferSize() - this.getUsedBytes()) {
                            this.bufferRequest(buf);
                            continue;
                        }
                        throw new IOException("could not loopback request message");
                    }
                } else if (message instanceof ResponseMessage && message.getDestination() != null && message.getDestination().equals(message.getSource())) continue;
                jsonArray.put(message.toJson());
            }
            payload = jsonArray.toString().getBytes(Charset.forName("UTF-8"));
        }
        if (payload != null && payload.length > 2) {
            this.post(payload);
        }
        if (!this.useLongPolling) {
            this.sendCallTime = System.currentTimeMillis();
        }
    }

    public final synchronized RequestMessage receive(long timeout) throws IOException, GeneralSecurityException {
        if (this.head == this.tail) {
            if (!this.useLongPolling) {
                long receiveCallTime = System.currentTimeMillis();
                if (this.sendReceiveTimeLimit == 0 || receiveCallTime - this.sendCallTime < (long)this.sendReceiveTimeLimit) {
                    return null;
                }
                this.post(null, -1);
                this.sendCallTime = System.currentTimeMillis();
            } else {
                this.post(null, (int)timeout);
            }
        }
        if (this.head != this.tail) {
            int nBytes = 0;
            nBytes += (this.requestBuffer[this.head++ % this.requestBuffer.length] & 0xFF) << 8;
            int offset = this.head;
            this.head = (this.head + (nBytes += this.requestBuffer[this.head++ % this.requestBuffer.length] & 0xFF)) % this.requestBuffer.length;
            try {
                byte[] bytes = new byte[nBytes];
                for (int b = 0; b < nBytes; ++b) {
                    bytes[b] = this.requestBuffer[offset++ % this.requestBuffer.length];
                }
                String json = new String(bytes, "UTF-8");
                JSONObject jsonObject = null;
                JSONTokener jsonTokener = new JSONTokener(json);
                while (jsonTokener.more()) {
                    Object obj = jsonTokener.nextValue();
                    if (obj instanceof JSONArray) {
                        JSONArray jsonArray = (JSONArray)obj;
                        for (int e = jsonArray.length() - 1; 0 <= e; --e) {
                            jsonObject = jsonArray.getJSONObject(e);
                            if (e <= 0) continue;
                            String s = jsonObject.toString();
                            byte[] data = s.getBytes("UTF-8");
                            for (int d = data.length - 1; 0 <= d; --d) {
                                this.head = --this.head >= 0 ? this.head : this.requestBuffer.length - 1;
                                this.requestBuffer[this.head % this.requestBuffer.length] = data[d];
                            }
                            this.head = --this.head >= 0 ? this.head : this.requestBuffer.length - 1;
                            this.requestBuffer[this.head % this.requestBuffer.length] = (byte)(0xFF & data.length);
                            this.head = --this.head >= 0 ? this.head : this.requestBuffer.length - 1;
                            this.requestBuffer[this.head % this.requestBuffer.length] = (byte)((0xFF00 & data.length) >> 8);
                        }
                        continue;
                    }
                    if (obj instanceof JSONObject) {
                        jsonObject = (JSONObject)obj;
                        break;
                    }
                    SendReceiveImpl.getLogger().log(Level.WARNING, "unexpected element ignored: " + String.valueOf(obj));
                }
                if (jsonObject != null) {
                    RequestMessage requestMessage = new RequestMessage.Builder().fromJson(jsonObject).build();
                    if (SendReceiveImpl.getLogger().isLoggable(Level.FINER)) {
                        SendReceiveImpl.getLogger().log(Level.FINER, "dequeued '" + requestMessage.getMethod().toUpperCase(Locale.ROOT) + " " + requestMessage.getURL() + " " + requestMessage.getBodyString() + "', destination = " + requestMessage.getDestination());
                    }
                    return requestMessage;
                }
            }
            catch (UnsupportedEncodingException e) {
            }
            catch (JSONException e) {
                SendReceiveImpl.getLogger().log(Level.SEVERE, e.getMessage());
            }
            catch (MessageParsingException e) {
                SendReceiveImpl.getLogger().log(Level.SEVERE, e.getMessage());
            }
            catch (IllegalArgumentException e) {
                SendReceiveImpl.getLogger().log(Level.SEVERE, e.getMessage());
            }
        }
        return null;
    }

    protected abstract void post(byte[] var1) throws IOException, GeneralSecurityException;

    protected abstract void post(byte[] var1, int var2) throws IOException, GeneralSecurityException;

    protected final synchronized int getUsedBytes() {
        this.head %= this.requestBuffer.length;
        this.tail %= this.requestBuffer.length;
        return this.tail >= this.head ? this.tail - this.head : this.tail + this.requestBuffer.length - this.head;
    }

    protected final int getRequestBufferSize() {
        return this.requestBuffer.length;
    }

    protected final synchronized void bufferRequest(byte[] data) {
        if (data != null && data.length > 2) {
            this.requestBuffer[this.tail++ % this.requestBuffer.length] = (byte)((0xFF00 & data.length) >> 8);
            this.requestBuffer[this.tail++ % this.requestBuffer.length] = (byte)(0xFF & data.length);
            for (int pos = 0; pos < data.length; ++pos) {
                this.requestBuffer[this.tail++ % this.requestBuffer.length] = data[pos];
            }
            this.tail %= this.requestBuffer.length;
            if (SendReceiveImpl.getLogger().isLoggable(Level.FINER)) {
                int availableBytes = this.getRequestBufferSize() - this.getUsedBytes() - 2;
                SendReceiveImpl.getLogger().log(Level.FINER, "buffered " + data.length + " bytes of request data from server. " + availableBytes + " available bytes of " + this.getRequestBufferSize() + " remaining in buffer.");
            }
            if (SendReceiveImpl.getLogger().isLoggable(Level.FINEST)) {
                SendReceiveImpl.getLogger().log(Level.FINEST, "buffered: " + Message.prettyPrintJson(data));
            }
        }
    }

    private static Logger getLogger() {
        return LOGGER;
    }
}

