/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.impl.device;

import com.oracle.iot.client.DeviceModelAttribute;
import com.oracle.iot.client.device.DirectlyConnectedDevice;
import com.oracle.iot.client.impl.DeviceModelImpl;
import com.oracle.iot.client.impl.device.DeviceAnalog;
import com.oracle.iot.client.impl.device.DeviceAnalogImpl;
import com.oracle.iot.client.impl.device.DeviceFunction;
import com.oracle.iot.client.impl.device.DevicePolicy;
import com.oracle.iot.client.impl.device.DevicePolicyManager;
import com.oracle.iot.client.impl.util.Pair;
import com.oracle.iot.client.message.AlertMessage;
import com.oracle.iot.client.message.DataItem;
import com.oracle.iot.client.message.DataMessage;
import com.oracle.iot.client.message.Message;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.iot.client.DeviceModel;

public class MessagingPolicyImpl
implements DevicePolicyManager.ChangeListener {
    private final DirectlyConnectedDevice directlyConnectedDevice;
    private final Map<String, List<Map<String, Object>>> pipelineDataCache = new HashMap<String, List<Map<String, Object>>>();
    private final Map<String, DeviceAnalog> deviceAnalogMap = new HashMap<String, DeviceAnalog>();
    private final Map<String, Long> windowMap = new HashMap<String, Long>();
    private final Map<String, Map<String, Set<String>>> computedMetricTriggers = new HashMap<String, Map<String, Set<String>>>();
    private final List<Message> messagesFromExpiredPolicies = new ArrayList<Message>();
    private static final Logger LOGGER = Logger.getLogger("oracle.iot.client");

    public MessagingPolicyImpl(DirectlyConnectedDevice directlyConnectedDevice) {
        this.directlyConnectedDevice = directlyConnectedDevice;
    }

    public Message[] applyPolicies(Message message) throws IOException, GeneralSecurityException {
        if (message == null) {
            return new Message[0];
        }
        long currentTimeMillis = System.currentTimeMillis();
        ArrayList<Message> resultingMessages = new ArrayList<Message>();
        if (message.getType() == Message.Type.DATA) {
            DataMessage dataMessage = this.applyAttributePolicies((DataMessage)message, currentTimeMillis);
            if (dataMessage != null) {
                resultingMessages.add(dataMessage);
            }
        } else {
            resultingMessages.add(message);
        }
        ArrayList<Message> messageList = new ArrayList<Message>();
        if (this.messagesFromExpiredPolicies.size() > 0) {
            messageList.addAll(this.messagesFromExpiredPolicies);
            this.messagesFromExpiredPolicies.clear();
        }
        int maxIndex = resultingMessages.size();
        for (int index = 0; index < maxIndex; ++index) {
            Message[] messagesFromDevicePolicy = this.applyDevicePolicies((Message)resultingMessages.get(index), currentTimeMillis);
            Collections.addAll(messageList, messagesFromDevicePolicy);
        }
        return messageList.toArray(new Message[messageList.size()]);
    }

    @Override
    public void policyAssigned(DevicePolicy devicePolicy, Set<String> assignedDevices) {
    }

    @Override
    public void policyUnassigned(DevicePolicy devicePolicy, Set<String> assignedDevices) {
        long currentTimeMillis = System.currentTimeMillis();
        List<Message> messages = this.expirePolicy(devicePolicy, currentTimeMillis);
        if (messages != null && !messages.isEmpty()) {
            this.messagesFromExpiredPolicies.addAll(messages);
        }
        this.deviceAnalogMap.clear();
        this.pipelineDataCache.clear();
        this.computedMetricTriggers.clear();
        this.windowMap.clear();
    }

    private DataMessage applyAttributePolicies(DataMessage dataMessage, long currentTimeMillis) throws IOException, GeneralSecurityException {
        HashMap<String, Set<String>> triggerMap;
        DeviceAnalog deviceAnalog;
        String format = dataMessage.getFormat();
        String deviceModelUrn = format.substring(0, format.length() - ":attributes".length());
        DeviceModel dm = this.directlyConnectedDevice.getDeviceModel(deviceModelUrn);
        if (!(dm instanceof DeviceModelImpl)) {
            return dataMessage;
        }
        DeviceModelImpl deviceModel = (DeviceModelImpl)dm;
        String endpointId = dataMessage.getSource();
        if (!this.deviceAnalogMap.containsKey(endpointId)) {
            deviceAnalog = new DeviceAnalogImpl(this.directlyConnectedDevice, deviceModel, endpointId);
            this.deviceAnalogMap.put(endpointId, deviceAnalog);
        } else {
            deviceAnalog = this.deviceAnalogMap.get(endpointId);
        }
        if (!this.computedMetricTriggers.containsKey(deviceModelUrn)) {
            triggerMap = new HashMap();
            this.computedMetricTriggers.put(deviceModelUrn, triggerMap);
            Map<String, DeviceModelAttribute> deviceModelAttributeMap = deviceModel.getDeviceModelAttributes();
            for (Map.Entry<String, DeviceModelAttribute> entry : deviceModelAttributeMap.entrySet()) {
                List<DevicePolicy.Function> pipeline;
                DeviceModelAttribute deviceModelAttribute = entry.getValue();
                String attribute = deviceModelAttribute.getName();
                DevicePolicyManager devicePolicyManager = DevicePolicyManager.getDevicePolicyManager(this.directlyConnectedDevice);
                DevicePolicy devicePolicy = devicePolicyManager.getPolicy(deviceModelUrn, endpointId);
                if (devicePolicy == null || (pipeline = devicePolicy.getPipeline(attribute)) == null || pipeline.isEmpty()) continue;
                DevicePolicy.Function function = pipeline.get(0);
                String deviceFunctionId = function.getId();
                Map<String, ?> parameters = function.getParameters();
                if (!"computedMetric".equals(deviceFunctionId)) continue;
                String formula = (String)parameters.get("formula");
                HashSet<String> triggerAttributes = new HashSet<String>();
                int pos = formula.indexOf("$(");
                while (pos != -1) {
                    String attr;
                    int end = formula.indexOf(41, pos + 1);
                    if (!(pos != 0 && formula.charAt(pos - 1) == '$' || (attr = formula.substring(pos + "$(".length(), end)).equals(attribute))) {
                        triggerAttributes.add(attr);
                    }
                    pos = formula.indexOf("$(", end + 1);
                }
                if (triggerAttributes.isEmpty()) continue;
                triggerMap.put(attribute, triggerAttributes);
            }
        } else {
            triggerMap = this.computedMetricTriggers.get(deviceModelUrn);
        }
        List<DataItem<?>> dataMessageDataItems = dataMessage.getDataItems();
        ArrayList policyDataItems = new ArrayList(dataMessageDataItems.size());
        ArrayList skippedDataItems = new ArrayList(dataMessageDataItems.size());
        boolean noPoliciesFound = true;
        for (DataItem<?> dataItem : dataMessageDataItems) {
            DataItem<?> policyDataItem;
            String attribute = dataItem.getKey();
            DeviceModelAttribute deviceModelAttribute = deviceModel.getDeviceModelAttributes().get(attribute);
            if (deviceModelAttribute == null) {
                MessagingPolicyImpl.getLogger().log(Level.INFO, deviceModel.getURN() + " does not contain attribute " + attribute);
                skippedDataItems.add(dataItem);
                continue;
            }
            DevicePolicyManager devicePolicyManager = DevicePolicyManager.getDevicePolicyManager(this.directlyConnectedDevice);
            DevicePolicy devicePolicy = devicePolicyManager.getPolicy(deviceModelUrn, endpointId);
            if (devicePolicy == null) {
                deviceAnalog.setAttributeValue(attribute, this.cast(deviceModelAttribute.getType(), dataItem.getValue()));
                skippedDataItems.add(dataItem);
                continue;
            }
            List<DevicePolicy.Function> pipeline = devicePolicy.getPipeline(attribute);
            if (pipeline == null || pipeline.isEmpty()) {
                deviceAnalog.setAttributeValue(attribute, this.cast(deviceModelAttribute.getType(), dataItem.getValue()));
                skippedDataItems.add(dataItem);
                continue;
            }
            noPoliciesFound = false;
            if (triggerMap.containsKey(attribute) || (policyDataItem = this.applyAttributePolicy(deviceAnalog, dataItem, pipeline, currentTimeMillis)) == null) continue;
            policyDataItems.add(policyDataItem);
        }
        if (noPoliciesFound) {
            return dataMessage;
        }
        if (policyDataItems.isEmpty() && skippedDataItems.isEmpty()) {
            return null;
        }
        if (!policyDataItems.isEmpty()) {
            this.checkComputedMetrics(policyDataItems, deviceAnalog, triggerMap, currentTimeMillis);
        }
        DataMessage.Builder dataMessageBuilder = (DataMessage.Builder)((DataMessage.Builder)((DataMessage.Builder)((DataMessage.Builder)((DataMessage.Builder)((DataMessage.Builder)((DataMessage.Builder)((DataMessage.Builder)new DataMessage.Builder().format(format).clientId(dataMessage.getClientId())).source(dataMessage.getSource())).destination(dataMessage.getDestination())).priority(dataMessage.getPriority())).reliability(dataMessage.getReliability())).eventTime(dataMessage.getEventTime())).properties(dataMessage.getProperties())).sender(dataMessage.getSender());
        if (dataMessage.getDiagnostics() != null) {
            Map<String, Object> diagnostics = dataMessage.getDiagnostics();
            for (Map.Entry<String, Object> entry : diagnostics.entrySet()) {
                dataMessageBuilder.diagnostic(entry.getKey(), entry.getValue());
            }
        }
        dataMessageBuilder.dataItems(policyDataItems);
        dataMessageBuilder.dataItems(skippedDataItems);
        return dataMessageBuilder.build();
    }

    private DataItem<?> applyAttributePolicy(DeviceAnalog deviceAnalog, DataItem<?> dataItem, List<DevicePolicy.Function> pipeline, long currentTimeMillis) {
        DataItem policyDataItem;
        String attribute = dataItem.getKey();
        DeviceModelImpl deviceModel = (DeviceModelImpl)deviceAnalog.getDeviceModel();
        Object policyValue = dataItem.getValue();
        List<Map<String, Object>> pipelineData = this.pipelineDataCache.get(attribute);
        if (pipelineData == null) {
            pipelineData = new ArrayList<Map<String, Object>>();
            this.pipelineDataCache.put(attribute, pipelineData);
        }
        DeviceFunction.putInProcessValue(deviceAnalog.getEndpointId(), deviceModel.getURN(), attribute, policyValue);
        int maxIndex = pipeline.size();
        for (int index = 0; index < maxIndex; ++index) {
            boolean windowExpired;
            HashMap<String, Object> functionData;
            DevicePolicy.Function function = pipeline.get(index);
            if (index < pipelineData.size()) {
                functionData = pipelineData.get(index);
            } else {
                functionData = new HashMap();
                pipelineData.add(functionData);
            }
            String key = function.getId();
            Map<String, ?> parameters = function.getParameters();
            DeviceFunction deviceFunction = DeviceFunction.getDeviceFunction(key);
            if (deviceFunction == null) continue;
            long window = DeviceFunction.getWindow(parameters);
            long slide = DeviceFunction.getSlide(parameters, window);
            if (window > 0L) {
                String k = deviceModel.getURN().concat(":".concat(attribute.concat(":".concat(deviceFunction.getId().concat(".expiry")))));
                Long expiry = this.windowMap.get(k);
                if (expiry == null) {
                    expiry = currentTimeMillis + window;
                    this.windowMap.put(k, expiry);
                }
                boolean bl = windowExpired = expiry <= currentTimeMillis;
                if (windowExpired) {
                    this.windowMap.put(k, expiry + slide);
                }
            } else {
                windowExpired = false;
            }
            if (deviceFunction.apply(deviceAnalog, attribute, parameters, functionData, policyValue) || windowExpired) {
                Object valueFromPolicy = deviceFunction.get(deviceAnalog, attribute, parameters, functionData);
                if (valueFromPolicy != null) {
                    policyValue = valueFromPolicy;
                    DeviceFunction.putInProcessValue(deviceAnalog.getEndpointId(), deviceModel.getURN(), attribute, policyValue);
                    continue;
                }
                MessagingPolicyImpl.getLogger().log(Level.WARNING, attribute + " got null value from policy" + deviceFunction.getDetails(parameters));
                break;
            }
            policyValue = null;
            break;
        }
        if (policyValue != null) {
            DeviceModelAttribute deviceModelAttribute = deviceModel.getDeviceModelAttributes().get(attribute);
            deviceAnalog.setAttributeValue(attribute, this.cast(deviceModelAttribute.getType(), policyValue));
            policyDataItem = this.createDataItem(dataItem.getType(), dataItem.getKey(), policyValue);
        } else {
            policyDataItem = null;
        }
        DeviceFunction.removeInProcessValue(deviceAnalog.getEndpointId(), deviceModel.getURN(), attribute);
        return policyDataItem;
    }

    private void checkComputedMetrics(List<DataItem<?>> dataItems, DeviceAnalog deviceAnalog, Map<String, Set<String>> triggerMap, long currentTimeMillis) throws IOException, GeneralSecurityException {
        if (triggerMap.isEmpty() || dataItems.isEmpty()) {
            return;
        }
        HashSet<String> updatedAttributes = new HashSet<String>();
        for (DataItem<?> dataItem : dataItems) {
            updatedAttributes.add(dataItem.getKey());
        }
        String endpointId = deviceAnalog.getEndpointId();
        DeviceModelImpl deviceModel = (DeviceModelImpl)deviceAnalog.getDeviceModel();
        Map<String, DeviceModelAttribute> deviceModelAttributes = deviceModel.getDeviceModelAttributes();
        String deviceModelUrn = deviceModel.getURN();
        block7: for (Map.Entry<String, Set<String>> entry : triggerMap.entrySet()) {
            DataItem<?> policyDataItem;
            List<DevicePolicy.Function> pipeline;
            DevicePolicyManager devicePolicyManager;
            DevicePolicy devicePolicy;
            DataItem dataItem;
            Set<String> key = entry.getValue();
            if (!updatedAttributes.containsAll(key)) continue;
            String attribute = entry.getKey();
            DeviceModelAttribute deviceModelAttribute = deviceModelAttributes.get(attribute);
            Object attributeValue = deviceAnalog.getAttributeValue(attribute);
            if (attributeValue == null) {
                attributeValue = deviceModelAttribute.getDefaultValue();
            }
            switch (deviceModelAttribute.getType()) {
                case NUMBER: 
                case INTEGER: {
                    Double number = attributeValue != null ? (Number)((Number)Number.class.cast(attributeValue)) : (Number)0.0;
                    dataItem = new DataItem(attribute, number);
                    break;
                }
                case STRING: 
                case URI: {
                    String string = attributeValue != null ? (String)String.class.cast(attributeValue) : "";
                    dataItem = new DataItem(attribute, string);
                    break;
                }
                case BOOLEAN: {
                    Boolean bool = attributeValue != null ? (Boolean)Boolean.class.cast(attributeValue) : Boolean.FALSE;
                    dataItem = new DataItem(attribute, bool);
                    break;
                }
                case DATETIME: {
                    long value = attributeValue instanceof Date ? ((Date)attributeValue).getTime() : (attributeValue != null ? (Long)Long.class.cast(attributeValue) : 0L);
                    dataItem = new DataItem(attribute, value);
                    break;
                }
                default: {
                    MessagingPolicyImpl.getLogger().log(Level.WARNING, "unknown device model attribute type: " + (Object)((Object)deviceModelAttribute.getType()));
                    continue block7;
                }
            }
            if ((devicePolicy = (devicePolicyManager = DevicePolicyManager.getDevicePolicyManager(this.directlyConnectedDevice)).getPolicy(deviceModelUrn, endpointId)) == null || (pipeline = devicePolicy.getPipeline(attribute)) == null || pipeline.isEmpty() || (policyDataItem = this.applyAttributePolicy(deviceAnalog, dataItem, pipeline, currentTimeMillis)) == null) continue;
            dataItems.add(policyDataItem);
        }
    }

    private Message[] applyDevicePolicies(Message message, long currentTimeMillis) throws IOException, GeneralSecurityException {
        List<Map<String, Object>> pipelineData;
        DevicePolicyManager devicePolicyManager;
        DevicePolicy devicePolicy;
        String deviceModelUrn;
        String format;
        String endpointId = message.getSource();
        if (message instanceof DataMessage) {
            format = ((DataMessage)message).getFormat();
            deviceModelUrn = format.substring(0, format.length() - ":attributes".length());
        } else if (message instanceof AlertMessage) {
            format = ((AlertMessage)message).getFormat();
            deviceModelUrn = format.substring(0, format.lastIndexOf(58));
        } else {
            return new Message[]{message};
        }
        DeviceAnalog deviceAnalog = this.deviceAnalogMap.get(endpointId);
        if (deviceAnalog == null) {
            DeviceModel deviceModel = this.directlyConnectedDevice.getDeviceModel(deviceModelUrn);
            if (deviceModel instanceof DeviceModelImpl) {
                deviceAnalog = new DeviceAnalogImpl(this.directlyConnectedDevice, (DeviceModelImpl)deviceModel, endpointId);
                this.deviceAnalogMap.put(endpointId, deviceAnalog);
            }
            if (deviceAnalog == null) {
                return new Message[]{message};
            }
        }
        if ((devicePolicy = (devicePolicyManager = DevicePolicyManager.getDevicePolicyManager(this.directlyConnectedDevice)).getPolicy(deviceModelUrn, endpointId)) == null) {
            return new Message[]{message};
        }
        List<DevicePolicy.Function> pipeline = devicePolicy.getPipeline(DevicePolicy.ALL_ATTRIBUTES());
        if (pipeline == null || pipeline.isEmpty()) {
            return new Message[]{message};
        }
        if (pipeline.size() > 1) {
            int maxIndex = pipeline.size();
            for (int index = 0; index < maxIndex; ++index) {
                DevicePolicy.Function function = pipeline.get(index);
                String id = function.getId();
                Map<String, ?> parameters = function.getParameters();
                DeviceFunction deviceFunction = DeviceFunction.getDeviceFunction(id);
                if (index == 0) {
                    MessagingPolicyImpl.getLogger().log(Level.WARNING, "Only one function allowed for all-attribute pipeline.");
                    MessagingPolicyImpl.getLogger().log(Level.WARNING, "\tApplying: " + deviceFunction.getDetails(parameters));
                    continue;
                }
                MessagingPolicyImpl.getLogger().log(Level.WARNING, "\tIgnoring: " + deviceFunction.getDetails(parameters));
            }
        }
        if ((pipelineData = this.pipelineDataCache.get(null)) == null) {
            pipelineData = new ArrayList<Map<String, Object>>();
            this.pipelineDataCache.put(null, pipelineData);
        }
        int maxIndex = 1;
        for (int index = 0; index < maxIndex; ++index) {
            Object valueFromPolicy;
            boolean alertOverridesPolicy;
            boolean windowExpired;
            HashMap<String, Object> functionData;
            DevicePolicy.Function function = pipeline.get(index);
            if (index < pipelineData.size()) {
                functionData = pipelineData.get(index);
            } else {
                functionData = new HashMap();
                pipelineData.add(functionData);
            }
            String key = function.getId();
            Map<String, ?> parameters = function.getParameters();
            DeviceFunction deviceFunction = DeviceFunction.getDeviceFunction(key);
            if (deviceFunction == null) continue;
            long window = DeviceFunction.getWindow(parameters);
            long slide = DeviceFunction.getSlide(parameters, window);
            if (window > 0L) {
                String k = deviceModelUrn.concat("::".concat(deviceFunction.getId().concat(".expiry")));
                Long expiry = this.windowMap.get(k);
                if (expiry == null) {
                    expiry = currentTimeMillis + window;
                    this.windowMap.put(k, expiry);
                }
                boolean bl = windowExpired = expiry <= currentTimeMillis;
                if (windowExpired) {
                    this.windowMap.put(k, expiry + slide);
                }
            } else {
                windowExpired = false;
            }
            if (message instanceof AlertMessage) {
                AlertMessage alertMessage = (AlertMessage)message;
                AlertMessage.Severity alertMessageSeverity = alertMessage.getSeverity();
                AlertMessage.Severity configuredSeverity = AlertMessage.Severity.CRITICAL;
                String criterion = (String)parameters.get("alertSeverity");
                if (criterion != null) {
                    try {
                        configuredSeverity = AlertMessage.Severity.valueOf(criterion);
                    }
                    catch (IllegalArgumentException e) {
                        configuredSeverity = AlertMessage.Severity.CRITICAL;
                    }
                }
                alertOverridesPolicy = configuredSeverity.compareTo(alertMessageSeverity) <= 0;
            } else {
                alertOverridesPolicy = false;
            }
            Pair<Message, Object> pair = new Pair<Message, Object>(message, null);
            if ((deviceFunction.apply(deviceAnalog, null, parameters, functionData, pair) || windowExpired || alertOverridesPolicy) && (valueFromPolicy = deviceFunction.get(deviceAnalog, null, parameters, functionData)) != null) {
                List messageList = (List)valueFromPolicy;
                Message[] messages = new Message[messageList.size()];
                int mMax = messageList.size();
                for (int m = 0; m < mMax; ++m) {
                    Pair element = (Pair)messageList.get(m);
                    messages[m] = (Message)element.getKey();
                }
                return messages;
            }
            return new Message[0];
        }
        return new Message[0];
    }

    private List<Message> expirePolicy(DevicePolicy devicePolicy, long currentTimeMillis) {
        List<Message> messageList = this.expirePolicy(devicePolicy);
        ArrayList<Message> consolidatedMessageList = new ArrayList<Message>();
        if (!messageList.isEmpty()) {
            ArrayList<DataItem<?>> dataItems;
            HashMap dataItemMap = new HashMap();
            for (Message message : messageList) {
                if (message instanceof DataMessage) {
                    String endpointId = message.getSource();
                    dataItems = (ArrayList)dataItemMap.get(endpointId);
                    if (dataItems == null) {
                        dataItems = new ArrayList();
                        dataItemMap.put(endpointId, dataItems);
                    }
                    dataItems.addAll(((DataMessage)message).getDataItems());
                    continue;
                }
                consolidatedMessageList.add(message);
            }
            for (Map.Entry entry : dataItemMap.entrySet()) {
                Map<String, Set<String>> triggerMap;
                DeviceAnalog deviceAnalog = this.deviceAnalogMap.get(entry.getKey());
                if (deviceAnalog == null) continue;
                dataItems = (List)entry.getValue();
                String format = deviceAnalog.getDeviceModel().getURN();
                if (!this.computedMetricTriggers.isEmpty() && (triggerMap = this.computedMetricTriggers.get(format)) != null && !triggerMap.isEmpty()) {
                    try {
                        this.checkComputedMetrics(dataItems, deviceAnalog, triggerMap, currentTimeMillis);
                    }
                    catch (IOException e) {
                        MessagingPolicyImpl.getLogger().log(Level.WARNING, e.getMessage());
                    }
                    catch (GeneralSecurityException e) {
                        MessagingPolicyImpl.getLogger().log(Level.WARNING, e.getMessage());
                    }
                }
                DataMessage dataMessage = ((DataMessage.Builder)new DataMessage.Builder().source(deviceAnalog.getEndpointId())).format(deviceAnalog.getDeviceModel().getURN()).dataItems(dataItems).build();
                consolidatedMessageList.add(dataMessage);
            }
        }
        return consolidatedMessageList;
    }

    private List<Message> expirePolicy(DevicePolicy devicePolicy) {
        ArrayList<Message> messageList = new ArrayList<Message>();
        for (DeviceAnalog deviceAnalog : this.deviceAnalogMap.values()) {
            List<Message> messages = this.expirePolicy(devicePolicy, deviceAnalog);
            if (messages == null || messages.isEmpty()) continue;
            messageList.addAll(messages);
        }
        return messageList;
    }

    private List<Message> expirePolicy(DevicePolicy devicePolicy, DeviceAnalog deviceAnalog) {
        Set<Map.Entry<String, List<DevicePolicy.Function>>> entries = devicePolicy.getPipelines().entrySet();
        ArrayList<Message> messageList = new ArrayList<Message>();
        for (Map.Entry<String, List<DevicePolicy.Function>> entry : entries) {
            List<Message> messages = this.expirePolicy(entry.getKey(), entry.getValue(), deviceAnalog);
            if (messages == null) continue;
            messageList.addAll(messages);
        }
        return messageList;
    }

    private List<Message> expirePolicy(String attributeName, List<DevicePolicy.Function> pipeline, DeviceAnalog deviceAnalog) {
        if (pipeline == null || pipeline.isEmpty()) {
            return null;
        }
        List<Map<String, Object>> pipelineData = this.pipelineDataCache.remove(attributeName);
        if (pipelineData == null) {
            return null;
        }
        int maxIndex = pipeline.size();
        for (int index = 0; index < maxIndex; ++index) {
            Map<String, Object> functionData;
            DevicePolicy.Function function = pipeline.get(index);
            if (function == null) continue;
            DeviceFunction deviceFunction = DeviceFunction.getDeviceFunction(function.getId());
            if (deviceFunction == null) {
                return null;
            }
            long window = DeviceFunction.getWindow(function.getParameters());
            if (window == -1L) continue;
            Map<String, Object> map = functionData = index < pipelineData.size() ? pipelineData.get(index) : null;
            if (functionData == null) {
                return null;
            }
            Object valueFromPolicy = deviceFunction.get(deviceAnalog, attributeName, function.getParameters(), functionData);
            if (valueFromPolicy == null) {
                return null;
            }
            for (int next = index + 1; next < maxIndex; ++next) {
                function = pipeline.get(next);
                deviceFunction = DeviceFunction.getDeviceFunction(function.getId());
                if (deviceFunction == null) {
                    return null;
                }
                Map<String, Object> map2 = functionData = next < pipelineData.size() ? pipelineData.get(next) : null;
                if (function == null) {
                    return null;
                }
                if (deviceFunction.apply(deviceAnalog, attributeName, function.getParameters(), functionData, valueFromPolicy)) {
                    valueFromPolicy = deviceFunction.get(deviceAnalog, attributeName, function.getParameters(), functionData);
                    if (valueFromPolicy != null) continue;
                    return null;
                }
                return null;
            }
            if (valueFromPolicy instanceof List) {
                return (List)valueFromPolicy;
            }
            DeviceModelImpl deviceModel = (DeviceModelImpl)deviceAnalog.getDeviceModel();
            DataMessage.Builder dataMessageBuilder = ((DataMessage.Builder)new DataMessage.Builder().source(deviceAnalog.getEndpointId())).format(deviceModel.getURN());
            DeviceModelAttribute deviceModelAttribute = deviceModel.getDeviceModelAttributes().get(attributeName);
            switch (deviceModelAttribute.getType()) {
                case NUMBER: 
                case INTEGER: 
                case DATETIME: {
                    dataMessageBuilder.dataItem(attributeName, (Double)this.cast(DeviceModelAttribute.Type.NUMBER, valueFromPolicy));
                    break;
                }
                default: {
                    dataMessageBuilder.dataItem(attributeName, (String)this.cast(DeviceModelAttribute.Type.STRING, valueFromPolicy));
                    break;
                }
                case BOOLEAN: {
                    dataMessageBuilder.dataItem(attributeName, (Double)this.cast(DeviceModelAttribute.Type.BOOLEAN, valueFromPolicy));
                }
            }
            ArrayList<Message> messages = new ArrayList<Message>();
            messages.add(dataMessageBuilder.build());
            return messages;
        }
        return null;
    }

    private DataItem createDataItem(DataItem.Type type, String key, Object newValue) {
        DataItem dataItem = null;
        switch (type) {
            case DOUBLE: {
                Number number = (Number)Number.class.cast(newValue);
                dataItem = new DataItem(key, number.doubleValue());
                break;
            }
            case STRING: {
                dataItem = new DataItem(key, (String)String.class.cast(newValue));
                break;
            }
            case BOOLEAN: {
                dataItem = new DataItem(key, (Boolean)Boolean.class.cast(newValue));
            }
        }
        return dataItem;
    }

    private Object cast(DeviceModelAttribute.Type type, Object newValue) {
        Number castValue = null;
        switch (type) {
            case INTEGER: {
                Number number = (Number)Number.class.cast(newValue);
                Long roundedValue = Math.round(number.doubleValue());
                castValue = roundedValue.intValue();
                break;
            }
            case NUMBER: {
                Number number = (Number)Number.class.cast(newValue);
                castValue = number.doubleValue();
                break;
            }
            case STRING: {
                castValue = (Number)String.class.cast(newValue);
                break;
            }
            case BOOLEAN: {
                castValue = (Number)Boolean.class.cast(newValue);
                break;
            }
            case DATETIME: {
                if (newValue instanceof Date) {
                    castValue = ((Date)Date.class.cast(newValue)).getTime();
                    break;
                }
                Number number = (Number)Number.class.cast(newValue);
                castValue = number.longValue();
                break;
            }
            case URI: {
                castValue = (Number)String.class.cast(newValue);
            }
        }
        return castValue;
    }

    private static Logger getLogger() {
        return LOGGER;
    }
}

