/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.impl.device;

import com.oracle.iot.client.HttpResponse;
import com.oracle.iot.client.RestApi;
import com.oracle.iot.client.SecureConnection;
import com.oracle.iot.client.TransportException;
import com.oracle.iot.client.device.DirectlyConnectedDevice;
import com.oracle.iot.client.device.GatewayDevice;
import com.oracle.iot.client.impl.device.DevicePolicy;
import com.oracle.iot.client.impl.device.PersistenceStore;
import com.oracle.iot.client.impl.device.PersistenceStoreManager;
import com.oracle.iot.client.message.RequestMessage;
import com.oracle.iot.client.message.ResponseMessage;
import com.oracle.iot.client.message.StatusCode;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class DevicePolicyManager {
    private static final Logger LOGGER = Logger.getLogger("oracle.iot.client");
    private final SecureConnection secureConnection;
    private final Map<String, Map<String, String>> policiesByDeviceId = new HashMap<String, Map<String, String>>();
    private final Map<String, DevicePolicy> policiesByPolicyId = new HashMap<String, DevicePolicy>();
    private final Map<String, Map<String, Set<String>>> policiesByDeviceModelUrn = new HashMap<String, Map<String, Set<String>>>();
    private final List<ChangeListener> changeListeners = new ArrayList<ChangeListener>();
    private final Lock policyChangeLock = new ReentrantLock();

    private static Logger getLogger() {
        return LOGGER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener changeListener) {
        if (changeListener == null) {
            return;
        }
        List<ChangeListener> list = this.changeListeners;
        synchronized (list) {
            this.changeListeners.add(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener changeListener) {
        if (changeListener == null) {
            return;
        }
        List<ChangeListener> list = this.changeListeners;
        synchronized (list) {
            this.changeListeners.remove(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyPolicyAssigned(DevicePolicy devicePolicy, Set<String> assignedDevices) {
        if (devicePolicy == null || assignedDevices.isEmpty()) {
            return;
        }
        List<ChangeListener> list = this.changeListeners;
        synchronized (list) {
            for (ChangeListener changeListener : this.changeListeners) {
                try {
                    changeListener.policyAssigned(devicePolicy, assignedDevices);
                }
                catch (Exception e) {
                    DevicePolicyManager.getLogger().log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyPolicyUnassigned(DevicePolicy devicePolicy, Set<String> unassignedDevices) {
        if (devicePolicy == null || unassignedDevices.isEmpty()) {
            return;
        }
        List<ChangeListener> list = this.changeListeners;
        synchronized (list) {
            for (ChangeListener changeListener : this.changeListeners) {
                try {
                    changeListener.policyUnassigned(devicePolicy, unassignedDevices);
                }
                catch (Exception e) {
                    DevicePolicyManager.getLogger().log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }
    }

    public static DevicePolicyManager getDevicePolicyManager(DirectlyConnectedDevice directlyConnectedDevice) {
        PersistenceStore persistenceStore = PersistenceStoreManager.getPersistenceStore(directlyConnectedDevice.getEndpointId());
        Object dpmObj = persistenceStore.getOpaque(DevicePolicyManager.class.getName(), null);
        if (dpmObj == null) {
            DevicePolicyManager.getLogger().log(Level.SEVERE, "cannot access DevicePolicyManager for " + directlyConnectedDevice.getEndpointId());
            return null;
        }
        return (DevicePolicyManager)DevicePolicyManager.class.cast(dpmObj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DevicePolicy getPolicy(String deviceModelURN, String deviceId) {
        Map<String, Map<String, String>> map = this.policiesByDeviceId;
        synchronized (map) {
            Map<String, String> devicePolicies = this.policiesByDeviceId.get(deviceId);
            if (devicePolicies != null && devicePolicies.containsKey(deviceModelURN)) {
                String policyId = devicePolicies.get(deviceModelURN);
                DevicePolicy devicePolicy = policyId != null ? this.policiesByPolicyId.get(policyId) : null;
                return devicePolicy;
            }
        }
        this.policyChangeLock.lock();
        try {
            DevicePolicy devicePolicy = this.lookupPolicyForDevice(deviceModelURN, deviceId);
            Map<String, String> polices = this.policiesByDeviceId.get(deviceId);
            if (polices == null) {
                polices = new HashMap<String, String>();
                this.policiesByDeviceId.put(deviceId, polices);
            }
            String policyId = devicePolicy != null ? devicePolicy.getId() : null;
            polices.put(deviceModelURN, policyId);
            if (devicePolicy != null) {
                HashSet<String> assignedDevices = new HashSet<String>();
                assignedDevices.add(deviceId);
                this.notifyPolicyAssigned(devicePolicy, assignedDevices);
            }
            DevicePolicy devicePolicy2 = devicePolicy;
            return devicePolicy2;
        }
        finally {
            this.policyChangeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseMessage policyChanged(DirectlyConnectedDevice directlyConnectedDevice, RequestMessage requestMessage) {
        boolean dcdIsGatewayDevice = directlyConnectedDevice instanceof GatewayDevice;
        String endpointId = directlyConnectedDevice.getEndpointId();
        String body = requestMessage.getBodyString();
        this.policyChangeLock.lock();
        try {
            JSONArray items = new JSONArray(body);
            int nMax = items.length();
            for (int n = 0; n < nMax; ++n) {
                JSONObject item = items.getJSONObject(n);
                String op = item.optString("op", "changed");
                String deviceModelUrn = item.getString("deviceModelUrn");
                String policyId = item.getString("id");
                long lastModified = item.getLong("lastModified");
                if ("unassigned".equals(op)) {
                    this.processUnassign(deviceModelUrn, policyId, endpointId, dcdIsGatewayDevice, lastModified);
                    continue;
                }
                if ("assigned".equals(op)) {
                    this.processAssign(deviceModelUrn, policyId, endpointId, dcdIsGatewayDevice, lastModified);
                    continue;
                }
                if ("changed".equals(op)) {
                    DevicePolicy policyAfterChange;
                    DevicePolicy policyBeforeChange = this.policiesByPolicyId.get(policyId);
                    if (policyBeforeChange == null) {
                        Set<String> assignedDevices;
                        Map<String, Set<String>> policies = this.policiesByDeviceModelUrn.get(deviceModelUrn);
                        if (policies == null || (assignedDevices = policies.remove(policyId)) == null) continue;
                        Map<String, Map<String, String>> map = this.policiesByDeviceId;
                        synchronized (map) {
                            for (String deviceId : assignedDevices) {
                                Map<String, String> devicePolicies = this.policiesByDeviceId.get(deviceId);
                                if (devicePolicies == null) continue;
                                devicePolicies.remove(policyId);
                            }
                            continue;
                        }
                    }
                    Map<String, Set<String>> policies = this.policiesByDeviceModelUrn.get(deviceModelUrn);
                    Set<String> assignedDevices = policies != null ? policies.get(policyId) : null;
                    if (assignedDevices != null && policyBeforeChange != null) {
                        this.notifyPolicyUnassigned(policyBeforeChange, assignedDevices);
                    }
                    this.processPipelineChanged(directlyConnectedDevice, deviceModelUrn, policyId, lastModified);
                    if (assignedDevices == null || (policyAfterChange = this.policiesByPolicyId.get(policyId)) == null) continue;
                    this.notifyPolicyAssigned(policyAfterChange, assignedDevices);
                    continue;
                }
                DevicePolicyManager.getLogger().log(Level.WARNING, requestMessage.getURL() + " invalid operation: " + item);
            }
        }
        catch (JSONException e) {
            ResponseMessage responseMessage;
            DevicePolicyManager.getLogger().log(Level.SEVERE, requestMessage.getURL() + " body=" + body, e);
            ResponseMessage responseMessage2 = responseMessage = new ResponseMessage.Builder(requestMessage).statusCode(StatusCode.BAD_REQUEST).body(e.getMessage()).build();
            return responseMessage2;
        }
        finally {
            this.policyChangeLock.unlock();
        }
        ResponseMessage responseMessage = new ResponseMessage.Builder(requestMessage).statusCode(StatusCode.OK).build();
        return responseMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPipelineChanged(DirectlyConnectedDevice directlyConnectedDevice, String deviceModelUrn, String policyId, long lastModified) {
        DevicePolicy devicePolicy;
        DevicePolicy currentDevicePolicy = this.policiesByPolicyId.get(policyId);
        if (currentDevicePolicy != null && lastModified < currentDevicePolicy.getLastModified()) {
            return;
        }
        Map<String, Map<String, String>> map = this.policiesByDeviceId;
        synchronized (map) {
            devicePolicy = this.downloadPolicy(deviceModelUrn, policyId);
        }
        if (devicePolicy != null && DevicePolicyManager.getLogger().isLoggable(Level.FINE)) {
            DevicePolicyManager.getLogger().log(Level.FINE, directlyConnectedDevice.getEndpointId() + " : Policy changed : \"" + devicePolicy.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private void processAssign(String deviceModelUrn, String policyId, String endpointId, boolean dcdIsGatewayDevice, long lastModified) {
        assignedDevices = null;
        if (dcdIsGatewayDevice) {
            couldNotGetIcds = true;
            try {
                assignedDevices = this.getIndirectlyConnectedDeviceIdsForPolicy(deviceModelUrn, policyId, endpointId);
                couldNotGetIcds = false;
            }
            catch (IOException e) {
                if (!couldNotGetIcds) ** GOTO lbl45
                deviceModelPolicies = this.policiesByDeviceModelUrn.get(deviceModelUrn);
                if (deviceModelPolicies != null && (assignedDeviceIds = deviceModelPolicies.remove(policyId)) != null) {
                    for (String deviceId : assignedDeviceIds) {
                        assignedPolicies = this.policiesByDeviceId.get(deviceId);
                        if (assignedPolicies == null) continue;
                        assignedPolicies.remove(deviceModelUrn);
                    }
                }
                return;
            }
            catch (GeneralSecurityException e) {
                if (!couldNotGetIcds) ** GOTO lbl45
                deviceModelPolicies = this.policiesByDeviceModelUrn.get(deviceModelUrn);
                if (deviceModelPolicies != null && (assignedDeviceIds = deviceModelPolicies.remove(policyId)) != null) {
                    for (String deviceId : assignedDeviceIds) {
                        assignedPolicies = this.policiesByDeviceId.get(deviceId);
                        if (assignedPolicies == null) continue;
                        assignedPolicies.remove(deviceModelUrn);
                    }
                }
                return;
            }
            finally {
                if (couldNotGetIcds) {
                    deviceModelPolicies = this.policiesByDeviceModelUrn.get(deviceModelUrn);
                    if (deviceModelPolicies != null && (assignedDeviceIds = deviceModelPolicies.remove(policyId)) != null) {
                        for (String deviceId : assignedDeviceIds) {
                            assignedPolicies = this.policiesByDeviceId.get(deviceId);
                            if (assignedPolicies == null) continue;
                            assignedPolicies.remove(deviceModelUrn);
                        }
                    }
                    return;
                }
            }
        } else {
            assignedDevices = new HashSet<String>();
            assignedDevices.add(endpointId);
        }
lbl45:
        // 4 sources

        if (assignedDevices == null || assignedDevices.isEmpty()) {
            return;
        }
        couldNotGetIcds = this.policiesByDeviceId;
        synchronized (couldNotGetIcds) {
            newPolicy = this.downloadPolicy(deviceModelUrn, policyId);
            this.policiesByPolicyId.put(policyId, newPolicy);
            for (String deviceId : assignedDevices) {
                this.assignPolicyToDevice(deviceModelUrn, policyId, deviceId, lastModified);
            }
        }
        devicePolicy = this.policiesByPolicyId.get(policyId);
        if (devicePolicy != null) {
            this.notifyPolicyAssigned(devicePolicy, assignedDevices);
        }
    }

    private void assignPolicyToDevice(String deviceModelUrn, String policyId, String deviceId, long lastModified) {
        Map<String, String> policies = this.policiesByDeviceId.get(deviceId);
        String currentPolicyId = policies != null ? policies.get(deviceModelUrn) : null;
        if (policyId.equals(currentPolicyId)) {
            return;
        }
        DevicePolicy devicePolicy = this.policiesByPolicyId.get(policyId);
        if (devicePolicy == null) {
            devicePolicy = this.downloadPolicy(deviceModelUrn, policyId);
            this.policiesByPolicyId.put(policyId, devicePolicy);
            if (devicePolicy != null && DevicePolicyManager.getLogger().isLoggable(Level.FINE)) {
                DevicePolicyManager.getLogger().log(Level.FINE, deviceId.replaceAll(".", " ") + " : Policy : " + devicePolicy.getId() + "\n" + devicePolicy.toString());
            }
        }
        if (devicePolicy != null) {
            Set<String> assignedDevices;
            Map<String, String> devicePolicies = this.policiesByDeviceId.get(deviceId);
            if (devicePolicies == null) {
                devicePolicies = new HashMap<String, String>();
                this.policiesByDeviceId.put(deviceId, devicePolicies);
            }
            devicePolicies.put(deviceModelUrn, policyId);
            Map<String, Set<String>> deviceModelPolicies = this.policiesByDeviceModelUrn.get(deviceModelUrn);
            if (deviceModelPolicies == null) {
                deviceModelPolicies = new HashMap<String, Set<String>>();
                this.policiesByDeviceModelUrn.put(deviceModelUrn, deviceModelPolicies);
            }
            if ((assignedDevices = deviceModelPolicies.get(policyId)) == null) {
                assignedDevices = new HashSet<String>();
                deviceModelPolicies.put(policyId, assignedDevices);
            }
            assignedDevices.add(deviceId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processUnassign(String deviceModelUrn, String policyId, String endpointId, boolean dcdIsGatewayDevice, long lastModified) {
        Set<String> unassignedDevices;
        Map<String, Set<String>> policies = this.policiesByDeviceModelUrn.get(deviceModelUrn);
        if (policies != null) {
            unassignedDevices = policies.get(policyId);
            if (unassignedDevices == null) {
                return;
            }
        } else {
            return;
        }
        if (!dcdIsGatewayDevice) {
            if (!unassignedDevices.contains(endpointId)) {
                return;
            }
            unassignedDevices.clear();
            unassignedDevices.add(endpointId);
        }
        boolean couldNotGetIcds = dcdIsGatewayDevice;
        if (dcdIsGatewayDevice) {
            try {
                Set<String> serverAssignedDevices = this.getIndirectlyConnectedDeviceIdsForPolicy(deviceModelUrn, policyId, endpointId);
                couldNotGetIcds = false;
                unassignedDevices.removeAll(serverAssignedDevices);
                if (unassignedDevices.isEmpty()) {
                    return;
                }
            }
            catch (IOException e) {
            }
            catch (GeneralSecurityException e) {
                // empty catch block
            }
        }
        DevicePolicy devicePolicy = this.policiesByPolicyId.get(policyId);
        assert (devicePolicy != null);
        this.notifyPolicyUnassigned(devicePolicy, unassignedDevices);
        Map<String, Map<String, String>> map = this.policiesByDeviceId;
        synchronized (map) {
            for (String deviceId : unassignedDevices) {
                Map<String, String> devicePolicies;
                this.unassignPolicyFromDevice(deviceModelUrn, policyId, deviceId, lastModified);
                if (!couldNotGetIcds || (devicePolicies = this.policiesByDeviceId.get(deviceId)) == null) continue;
                devicePolicies.remove(deviceModelUrn);
            }
        }
    }

    private boolean unassignPolicyFromDevice(String deviceModelUrn, String policyId, String deviceId, long lastModified) {
        Map<String, String> policies = this.policiesByDeviceId.get(deviceId);
        String currentPolicyId = policies != null ? policies.get(deviceModelUrn) : null;
        if (currentPolicyId == null) {
            return true;
        }
        boolean badMapping = false;
        if (!policyId.equals(currentPolicyId)) {
            DevicePolicy devicePolicy = this.policiesByPolicyId.get(currentPolicyId);
            if (devicePolicy != null) {
                if (devicePolicy.getLastModified() > lastModified) {
                    return false;
                }
                badMapping = true;
            } else {
                Map<String, String> devicePolicies = this.policiesByDeviceId.get(deviceId);
                if (devicePolicies != null) {
                    devicePolicies.remove(deviceModelUrn);
                }
                return true;
            }
        }
        if (policies != null) {
            if (!badMapping) {
                policies.put(deviceModelUrn, null);
            } else {
                policies.remove(deviceModelUrn);
            }
        }
        return true;
    }

    private DevicePolicy downloadPolicy(String deviceModelUrn, String policyId) {
        String query;
        String urn;
        try {
            urn = URLEncoder.encode(deviceModelUrn, "UTF-8");
        }
        catch (UnsupportedEncodingException cannot_happen) {
            throw new RuntimeException(cannot_happen);
        }
        try {
            String fields = URLEncoder.encode("id,pipelines,enabled,lastModified", "UTF-8");
            query = "?fields=" + fields;
        }
        catch (UnsupportedEncodingException cannot_happen) {
            throw new RuntimeException(cannot_happen);
        }
        String uri = RestApi.V2.getPrivateRoot() + "/deviceModels/" + urn + "/devicePolicies/" + policyId + query;
        byte[] data = null;
        try {
            HttpResponse res = this.secureConnection.get(uri);
            int status = res.getStatus();
            if (status != StatusCode.OK.getCode()) {
                throw new TransportException(status, uri);
            }
            data = res.getData();
        }
        catch (IOException e) {
            DevicePolicyManager.getLogger().log(Level.WARNING, "GET " + uri, e);
        }
        catch (GeneralSecurityException e) {
            DevicePolicyManager.getLogger().log(Level.WARNING, "GET " + uri, e);
        }
        DevicePolicy devicePolicy = null;
        if (data != null && data.length > 2) {
            String jsonString;
            try {
                jsonString = new String(data, "UTF-8");
            }
            catch (UnsupportedEncodingException cannot_happen) {
                throw new RuntimeException(cannot_happen);
            }
            try {
                JSONObject policyJson = new JSONObject(jsonString);
                devicePolicy = DevicePolicyManager.devicePolicyFromJSON(deviceModelUrn, policyJson);
                this.policiesByPolicyId.put(policyId, devicePolicy);
                Map<String, Set<String>> policies = this.policiesByDeviceModelUrn.get(deviceModelUrn);
                if (policies == null) {
                    policies = new HashMap<String, Set<String>>();
                    this.policiesByDeviceModelUrn.put(deviceModelUrn, policies);
                }
                if (devicePolicy != null && DevicePolicyManager.getLogger().isLoggable(Level.FINE)) {
                    DevicePolicyManager.getLogger().log(Level.FINE, policyId.replaceAll(".", " ") + " : Policy : " + devicePolicy.getId() + "\n" + devicePolicy.toString());
                }
            }
            catch (JSONException e) {
                DevicePolicyManager.getLogger().log(Level.SEVERE, e.getMessage());
            }
        }
        return devicePolicy;
    }

    private DevicePolicy lookupPolicyForDevice(String deviceModelUrn, String deviceId) {
        String query;
        String urn;
        DevicePolicy devicePolicy;
        Map<String, Set<String>> policies = this.policiesByDeviceModelUrn.get(deviceModelUrn);
        if (policies != null) {
            for (Map.Entry<String, Set<String>> entry : policies.entrySet()) {
                String policyId = entry.getKey();
                Set<String> deviceIds = entry.getValue();
                if (!deviceIds.contains(deviceId) || (devicePolicy = this.policiesByPolicyId.get(policyId)) == null) continue;
                return devicePolicy;
            }
        }
        try {
            urn = URLEncoder.encode(deviceModelUrn, "UTF-8");
        }
        catch (UnsupportedEncodingException cannot_happen) {
            throw new RuntimeException(cannot_happen);
        }
        try {
            String devicesDotId = URLEncoder.encode("{\"devices.id\":\"" + deviceId + "\"}", "UTF-8");
            String fields = URLEncoder.encode("id,pipelines,enabled,lastModified", "UTF-8");
            query = "?q=" + devicesDotId + "&fields=" + fields;
        }
        catch (UnsupportedEncodingException cannot_happen) {
            throw new RuntimeException(cannot_happen);
        }
        String uri = RestApi.V2.getPrivateRoot() + "/deviceModels/" + urn + "/devicePolicies" + query;
        byte[] data = null;
        try {
            HttpResponse res = this.secureConnection.get(uri);
            int status = res.getStatus();
            if (status != StatusCode.OK.getCode()) {
                DevicePolicyManager.getLogger().log(Level.WARNING, "GET " + uri);
                return null;
            }
            data = res.getData();
        }
        catch (IOException e) {
            DevicePolicyManager.getLogger().log(Level.WARNING, "GET " + uri, e);
        }
        catch (GeneralSecurityException e) {
            DevicePolicyManager.getLogger().log(Level.WARNING, "GET " + uri, e);
        }
        devicePolicy = null;
        if (data != null && data.length > 2) {
            String jsonString;
            try {
                jsonString = new String(data, "UTF-8");
            }
            catch (UnsupportedEncodingException cannot_happen) {
                throw new RuntimeException(cannot_happen);
            }
            try {
                JSONObject devicePolicies = new JSONObject(jsonString);
                JSONArray items = devicePolicies.getJSONArray("items");
                if (items.length() > 0) {
                    JSONObject item = items.getJSONObject(0);
                    devicePolicy = DevicePolicyManager.devicePolicyFromJSON(deviceModelUrn, item);
                }
            }
            catch (JSONException e) {
                DevicePolicyManager.getLogger().log(Level.SEVERE, e.getMessage());
            }
        }
        if (devicePolicy != null) {
            Set<String> deviceIds;
            String policyId = devicePolicy.getId();
            if (!this.policiesByPolicyId.containsKey(policyId)) {
                this.policiesByPolicyId.put(policyId, devicePolicy);
                if (devicePolicy != null && DevicePolicyManager.getLogger().isLoggable(Level.FINE)) {
                    DevicePolicyManager.getLogger().log(Level.FINE, policyId.replaceAll(".", " ") + " : Policy : " + devicePolicy.getId() + "\n" + devicePolicy.toString());
                }
            }
            if ((policies = this.policiesByDeviceModelUrn.get(deviceModelUrn)) == null) {
                policies = new HashMap<String, Set<String>>();
                this.policiesByDeviceModelUrn.put(deviceModelUrn, policies);
            }
            if ((deviceIds = policies.get(policyId)) == null) {
                deviceIds = new HashSet<String>();
                policies.put(policyId, deviceIds);
            }
            deviceIds.add(deviceId);
        }
        return devicePolicy;
    }

    private Set<String> getIndirectlyConnectedDeviceIdsForPolicy(String deviceModelUrn, String policyId, String directlyConnectedOwner) throws IOException, GeneralSecurityException {
        String body;
        byte[] data;
        String query;
        String urn;
        try {
            urn = URLEncoder.encode(deviceModelUrn, "UTF-8");
        }
        catch (UnsupportedEncodingException cannot_happen) {
            throw new RuntimeException(cannot_happen);
        }
        try {
            String icdFilter = URLEncoder.encode("{\"directlyConnectedOwner\":\"" + directlyConnectedOwner + "\"}", "UTF-8");
            query = "?q=" + icdFilter + "&fields=id";
        }
        catch (UnsupportedEncodingException cannot_happen) {
            throw new RuntimeException(cannot_happen);
        }
        String uri = RestApi.V2.getPrivateRoot() + "/deviceModels/" + urn + "/devicePolicies/" + policyId + "/devices" + query;
        HttpResponse res = this.secureConnection.get(uri);
        int status = res.getStatus();
        if (status != StatusCode.OK.getCode()) {
            DevicePolicyManager.getLogger().log(Level.WARNING, res.getVerboseStatus("GET", uri));
        }
        if ((data = res.getData()) == null || data.length == 2) {
            return Collections.emptySet();
        }
        try {
            body = new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException cannot_happen) {
            throw new RuntimeException(cannot_happen);
        }
        HashSet<String> icdIds = new HashSet<String>();
        try {
            JSONObject jsonObject = new JSONObject(body);
            JSONArray items = jsonObject.getJSONArray("items");
            int nMax = items.length();
            for (int n = 0; n < nMax; ++n) {
                JSONObject item = items.getJSONObject(n);
                String icdId = item.getString("id");
                icdIds.add(icdId);
            }
        }
        catch (JSONException e) {
            DevicePolicyManager.getLogger().log(Level.SEVERE, e.getMessage());
        }
        return icdIds;
    }

    private static DevicePolicy devicePolicyFromJSON(String deviceModelURN, JSONObject jsonObject) throws JSONException {
        String id = jsonObject.getString("id");
        String description = jsonObject.optString("description");
        Long lastModified = jsonObject.getLong("lastModified");
        Boolean enabled = jsonObject.optBoolean("enabled", true);
        HashMap<String, List<DevicePolicy.Function>> pipelines = new HashMap<String, List<DevicePolicy.Function>>();
        if (!jsonObject.has("pipelines")) {
            return null;
        }
        JSONArray pipelineArray = jsonObject.getJSONArray("pipelines");
        if (pipelineArray.length() == 0) {
            return null;
        }
        int indexMax = pipelineArray.length();
        for (int index = 0; index < indexMax; ++index) {
            JSONObject attributePipeline = pipelineArray.getJSONObject(index);
            String attributeName = attributePipeline.optString("attributeName", DevicePolicy.ALL_ATTRIBUTES());
            JSONArray pipeline = attributePipeline.getJSONArray("pipeline");
            ArrayList<DevicePolicy.Function> functions = new ArrayList<DevicePolicy.Function>();
            int nMax = pipeline.length();
            for (int n = 0; n < nMax; ++n) {
                JSONObject function = pipeline.getJSONObject(n);
                String functionId = function.getString("id");
                HashMap<String, Object> parameterMap = new HashMap<String, Object>();
                JSONObject parameters = function.getJSONObject("parameters");
                Iterator<String> keys = parameters.keys();
                while (keys.hasNext()) {
                    String parameterName = keys.next();
                    Object parameterValue = parameters.get(parameterName);
                    if ("action".equals(parameterName)) {
                        JSONObject actionObject = (JSONObject)parameterValue;
                        String actionName = actionObject.getString("name");
                        parameterMap.put("name", actionName);
                        JSONArray actionArguments = actionObject.optJSONArray("arguments");
                        if (actionArguments == null || actionArguments.length() <= 0) continue;
                        ArrayList<Object> argumentList = new ArrayList<Object>();
                        parameterMap.put("arguments", argumentList);
                        int maxArg = actionArguments.length();
                        for (int arg = 0; arg < maxArg; ++arg) {
                            Object argument = actionArguments.get(arg);
                            argumentList.add(argument);
                        }
                        continue;
                    }
                    if ("alert".equals(parameterName)) {
                        JSONObject alertObject = (JSONObject)parameterValue;
                        String urn = alertObject.getString("urn");
                        parameterMap.put("urn", urn);
                        JSONObject fields = alertObject.getJSONObject("fields");
                        HashMap<String, Object> fieldList = new HashMap<String, Object>();
                        Iterator<String> fieldNames = fields.keys();
                        while (fieldNames.hasNext()) {
                            String fieldName = fieldNames.next();
                            Object fieldValue = fields.get(fieldName);
                            fieldList.put(fieldName, fieldValue);
                        }
                        parameterMap.put("fields", fieldList);
                        if (!alertObject.has("severity")) continue;
                        parameterMap.put("severity", alertObject.getString("severity"));
                        continue;
                    }
                    parameterMap.put(parameterName, parameterValue);
                }
                functions.add(new DevicePolicy.Function(functionId, parameterMap));
            }
            pipelines.put(attributeName, Collections.unmodifiableList(functions));
        }
        return new DevicePolicy(id, deviceModelURN, pipelines, description, lastModified, enabled);
    }

    public DevicePolicyManager(SecureConnection secureConnection) {
        this.secureConnection = secureConnection;
    }

    public static interface ChangeListener {
        public void policyAssigned(DevicePolicy var1, Set<String> var2);

        public void policyUnassigned(DevicePolicy var1, Set<String> var2);
    }
}

