/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.impl.device;

import com.oracle.iot.client.DeviceModelAction;
import com.oracle.iot.client.DeviceModelAttribute;
import com.oracle.iot.client.ExternalObject;
import com.oracle.iot.client.device.DirectlyConnectedDevice;
import com.oracle.iot.client.device.util.RequestDispatcher;
import com.oracle.iot.client.impl.DeviceModelImpl;
import com.oracle.iot.client.impl.device.DeviceAnalog;
import com.oracle.iot.client.message.Message;
import com.oracle.iot.client.message.RequestMessage;
import com.oracle.iot.client.message.ResponseMessage;
import com.oracle.iot.client.message.StatusCode;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.iot.client.DeviceModel;
import org.json.JSONException;
import org.json.JSONObject;

public final class DeviceAnalogImpl
implements DeviceAnalog {
    private final DirectlyConnectedDevice directlyConnectedDevice;
    private final DeviceModelImpl deviceModel;
    private final String endpointId;
    private final Map<String, Object> attributeValueMap;
    private static final Logger LOGGER = Logger.getLogger("oracle.iot.client");

    public DeviceAnalogImpl(DirectlyConnectedDevice directlyConnectedDevice, DeviceModelImpl deviceModel, String endpointId) {
        this.directlyConnectedDevice = directlyConnectedDevice;
        this.deviceModel = deviceModel;
        this.endpointId = endpointId;
        this.attributeValueMap = new HashMap<String, Object>();
    }

    @Override
    public String getEndpointId() {
        return this.endpointId;
    }

    @Override
    public DeviceModel getDeviceModel() {
        return this.deviceModel;
    }

    @Override
    public void setAttributeValue(String attribute, Object value) {
        boolean badValue;
        if (value == null) {
            throw new IllegalArgumentException("value cannot be null");
        }
        DeviceModelAttribute deviceModelAttribute = this.deviceModel.getDeviceModelAttributes().get(attribute);
        if (deviceModelAttribute == null) {
            throw new IllegalArgumentException(this.deviceModel.getURN() + " does not contain attribute " + attribute);
        }
        DeviceModelAttribute.Type type = deviceModelAttribute.getType();
        switch (type) {
            case NUMBER: {
                badValue = !(value instanceof Number);
                break;
            }
            case STRING: 
            case URI: {
                badValue = !(value instanceof String);
                break;
            }
            case BOOLEAN: {
                badValue = !(value instanceof Boolean);
                break;
            }
            case INTEGER: {
                badValue = !(value instanceof Integer);
                break;
            }
            case DATETIME: {
                badValue = !(value instanceof Long);
                break;
            }
            default: {
                throw new InternalError("unknown type '" + (Object)((Object)type) + "'");
            }
        }
        if (badValue) {
            throw new IllegalArgumentException("cannot set '" + this.deviceModel.getURN() + ":attribute/" + attribute + "' to " + value.toString());
        }
        this.attributeValueMap.put(attribute, value);
    }

    @Override
    public Object getAttributeValue(String attribute) {
        DeviceModelAttribute deviceModelAttribute = this.deviceModel.getDeviceModelAttributes().get(attribute);
        if (deviceModelAttribute == null) {
            throw new IllegalArgumentException(this.deviceModel.getURN() + " does not contain attribute " + attribute);
        }
        Object value = this.attributeValueMap.get(attribute);
        if (value == null) {
            value = deviceModelAttribute.getDefaultValue();
        }
        return value;
    }

    @Override
    public void call(String actionName, Map<String, ?> args) {
        boolean useLongPolling;
        Map<String, DeviceModelAction> deviceModelActionMap = this.deviceModel.getDeviceModelActions();
        if (deviceModelActionMap == null) {
            DeviceAnalogImpl.getLogger().log(Level.WARNING, this.deviceModel.getURN() + " does not contain action '" + actionName + "'");
            return;
        }
        DeviceModelAction deviceModelAction = deviceModelActionMap.get(actionName);
        if (deviceModelAction == null) {
            DeviceAnalogImpl.getLogger().log(Level.WARNING, this.deviceModel.getURN() + " does not contain action '" + actionName + "'");
            return;
        }
        RequestMessage.Builder requestMessageBuilder = ((RequestMessage.Builder)((RequestMessage.Builder)new RequestMessage.Builder().source(this.getEndpointId())).destination(this.getEndpointId())).url("deviceModels/" + this.getDeviceModel().getURN() + "/actions/" + actionName).method("POST");
        List<DeviceModelAction.Argument> argumentList = deviceModelAction.getArguments();
        try {
            JSONObject actionArgs = new JSONObject();
            for (DeviceModelAction.Argument argument : argumentList) {
                Object value = args.get(argument.getName());
                if (value == null && (value = argument.getDefaultValue()) == null) {
                    DeviceAnalogImpl.getLogger().log(Level.WARNING, "Action not called: missing argument '" + argument.getName() + " in call to '" + actionName + "'");
                    return;
                }
                this.encodeArg(actionArgs, deviceModelAction, argument, value);
            }
            requestMessageBuilder.body(actionArgs.toString());
        }
        catch (JSONException e) {
            DeviceAnalogImpl.getLogger().log(Level.WARNING, e.toString());
            return;
        }
        catch (IllegalArgumentException e) {
            DeviceAnalogImpl.getLogger().log(Level.WARNING, e.toString());
            return;
        }
        RequestMessage requestMessage = requestMessageBuilder.build();
        boolean bl = useLongPolling = !Boolean.getBoolean("com.oracle.iot.client.disable_long_polling");
        if (useLongPolling) {
            try {
                ResponseMessage responseMessage = RequestDispatcher.getInstance().dispatch(requestMessage);
                if (responseMessage.getStatusCode() == StatusCode.NOT_FOUND) {
                    DeviceAnalogImpl.getLogger().log(Level.INFO, "Endpoint " + this.getEndpointId() + " has no handler for " + requestMessage.getURL());
                }
            }
            catch (Exception e) {
                DeviceAnalogImpl.getLogger().log(Level.WARNING, e.getMessage());
            }
        } else {
            try {
                this.directlyConnectedDevice.send(requestMessage);
            }
            catch (IOException e) {
                DeviceAnalogImpl.getLogger().log(Level.WARNING, e.getMessage());
            }
            catch (GeneralSecurityException e) {
                DeviceAnalogImpl.getLogger().log(Level.WARNING, e.getMessage());
            }
        }
    }

    private void encodeArg(JSONObject jsonObject, DeviceModelAction deviceModelAction, DeviceModelAction.Argument argument, Object value) throws IllegalArgumentException, JSONException {
        String actionName = deviceModelAction.getName();
        String argumentName = argument.getName();
        switch (argument.getArgType()) {
            case NUMBER: {
                if (!(value instanceof Number)) {
                    throw new IllegalArgumentException(actionName + " value for '" + argument + "' is not a NUMBER");
                }
                this.checkBounds(deviceModelAction, argument, (Number)value);
                jsonObject.put(argumentName, (Number)value);
                break;
            }
            case INTEGER: {
                if (!(value instanceof Integer)) {
                    throw new IllegalArgumentException(actionName + " value for '" + argumentName + "' is not an INTEGER");
                }
                this.checkBounds(deviceModelAction, argument, (Integer)value);
                jsonObject.put(argumentName, (Number)value);
                break;
            }
            case DATETIME: {
                if (!(value instanceof Date) && !(value instanceof Long)) {
                    throw new IllegalArgumentException(actionName + " value for '" + argumentName + "' is not a DATETIME");
                }
                if (value instanceof Date) {
                    jsonObject.put(argumentName, ((Date)value).getTime());
                    break;
                }
                jsonObject.put(argumentName, (Long)value);
                break;
            }
            case BOOLEAN: {
                if (!(value instanceof Boolean)) {
                    throw new IllegalArgumentException(actionName + " value for '" + argumentName + "' is not a BOOLEAN");
                }
                jsonObject.put(argumentName, (Boolean)value);
                break;
            }
            case STRING: {
                if (!(value instanceof String)) {
                    throw new IllegalArgumentException(actionName + " value for '" + argumentName + "' is not a STRING");
                }
                jsonObject.put(argumentName, (String)value);
                break;
            }
            case URI: {
                if (!(value instanceof oracle.iot.client.ExternalObject) && !(value instanceof ExternalObject)) {
                    throw new IllegalArgumentException(actionName + " value for '" + argumentName + "' is not an ExternalObject");
                }
                if (value instanceof oracle.iot.client.ExternalObject) {
                    jsonObject.put(argumentName, ((oracle.iot.client.ExternalObject)value).getURI());
                    break;
                }
                jsonObject.put(argumentName, ((ExternalObject)value).getURI());
                break;
            }
            default: {
                throw new IllegalArgumentException(actionName + " argument '" + argumentName + "' has an unknown type");
            }
        }
    }

    private void checkBounds(DeviceModelAction deviceModelAction, DeviceModelAction.Argument argument, Number value) throws IllegalArgumentException {
        double lower;
        double upper;
        Number upperBound = argument.getUpperBound();
        Number lowerBound = argument.getLowerBound();
        double val = value.doubleValue();
        if (upperBound != null && Double.compare(val, upper = upperBound.doubleValue()) > 0) {
            throw new IllegalArgumentException(deviceModelAction.getName() + " '" + argument.getName() + "' out of range: " + val + " > " + upper);
        }
        if (lowerBound != null && Double.compare(val, lower = lowerBound.doubleValue()) < 0) {
            throw new IllegalArgumentException(deviceModelAction.getName() + " '" + argument.getName() + "' out of range: " + val + " < " + lower);
        }
    }

    @Override
    public void queueMessage(Message message) {
        try {
            this.directlyConnectedDevice.offer(message);
        }
        catch (IOException e) {
            DeviceAnalogImpl.getLogger().log(Level.INFO, e.getMessage());
        }
        catch (GeneralSecurityException e) {
            DeviceAnalogImpl.getLogger().log(Level.INFO, e.getMessage());
        }
    }

    private static Logger getLogger() {
        return LOGGER;
    }
}

