/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.impl.device;

import com.oracle.iot.client.DeviceModelFormat;
import com.oracle.iot.client.impl.DeviceModelImpl;
import com.oracle.iot.client.impl.device.StorageObjectImpl;
import com.oracle.iot.client.impl.device.VirtualDeviceImpl;
import com.oracle.iot.client.message.DataMessage;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import oracle.iot.client.AbstractVirtualDevice;
import oracle.iot.client.DeviceModel;
import oracle.iot.client.ExternalObject;
import oracle.iot.client.StorageObject;
import oracle.iot.client.device.Data;
import oracle.iot.client.device.VirtualDevice;

public class DataImpl
extends Data {
    private final VirtualDeviceImpl virtualDevice;
    private final DeviceModelFormat deviceModelFormat;
    private final Map<String, Object> fieldValues;
    private AbstractVirtualDevice.ErrorCallback<VirtualDevice> errorCallback;
    private static final Logger LOGGER = Logger.getLogger("oracle.iot.client");

    public DataImpl(VirtualDevice virtualDevice, String dataUrn) {
        if (!(virtualDevice instanceof VirtualDeviceImpl)) {
            throw new IllegalArgumentException("expected: " + VirtualDeviceImpl.class.getName());
        }
        this.deviceModelFormat = DataImpl.getDeviceModelFormat(virtualDevice, dataUrn);
        if (this.deviceModelFormat == null) {
            throw new IllegalArgumentException("'" + dataUrn + "' not found");
        }
        if (this.deviceModelFormat.getType() != DeviceModelFormat.Type.DATA) {
            throw new IllegalArgumentException("'" + dataUrn + "' is not an data format");
        }
        this.virtualDevice = (VirtualDeviceImpl)virtualDevice;
        this.fieldValues = new HashMap<String, Object>();
    }

    @Override
    public <T> Data set(String fieldName, T value) {
        DeviceModelFormat.Field field = this.getField(fieldName);
        if (field == null) {
            throw new IllegalArgumentException(fieldName + " not in model");
        }
        switch (field.getType()) {
            case NUMBER: {
                if (value instanceof Number) break;
                throw new IllegalArgumentException("value for '" + fieldName + "' is not a NUMBER");
            }
            case INTEGER: {
                if (value instanceof Integer) break;
                throw new IllegalArgumentException("value for '" + fieldName + "' is not an INTEGER");
            }
            case DATETIME: {
                if (value instanceof Date || value instanceof Long) break;
                throw new IllegalArgumentException("value for '" + fieldName + "' is not a DATETIME");
            }
            case BOOLEAN: {
                if (value instanceof Boolean) break;
                throw new IllegalArgumentException("value for '" + fieldName + "' is not a BOOLEAN");
            }
            case STRING: {
                if (value instanceof String) break;
                throw new IllegalArgumentException("value for '" + fieldName + "' is not a STRING");
            }
            case URI: {
                if (value instanceof ExternalObject) break;
                throw new IllegalArgumentException("value for '" + fieldName + "' is not an ExternalObject");
            }
        }
        this.fieldValues.put(fieldName, value);
        return this;
    }

    @Override
    public void submit() {
        DataMessage.Builder builder = new DataMessage.Builder();
        List<DeviceModelFormat.Field> fieldList = this.deviceModelFormat.getFields();
        ArrayList<StorageObjectImpl> storageObjects = new ArrayList<StorageObjectImpl>();
        block10: for (DeviceModelFormat.Field field : fieldList) {
            String key = field.getName();
            Object value = this.fieldValues.remove(key);
            if (value != null) {
                switch (field.getType()) {
                    case NUMBER: {
                        builder.dataItem(key, ((Number)value).doubleValue());
                        continue block10;
                    }
                    case INTEGER: {
                        builder.dataItem(key, ((Integer)value).intValue());
                        continue block10;
                    }
                    case DATETIME: {
                        if (value instanceof Date) {
                            builder.dataItem(key, ((Date)value).getTime());
                            continue block10;
                        }
                        if (!(value instanceof Long)) continue block10;
                        builder.dataItem(key, ((Long)value).longValue());
                        continue block10;
                    }
                    case BOOLEAN: {
                        builder.dataItem(key, (Boolean)value);
                        continue block10;
                    }
                    case STRING: {
                        builder.dataItem(key, (String)value);
                        continue block10;
                    }
                    case URI: {
                        if (value instanceof StorageObjectImpl) {
                            StorageObjectImpl storageObjectImpl = (StorageObjectImpl)value;
                            if (storageObjectImpl.getSyncStatus() == StorageObject.SyncStatus.NOT_IN_SYNC || storageObjectImpl.getSyncStatus() == StorageObject.SyncStatus.SYNC_PENDING) {
                                storageObjects.add(storageObjectImpl);
                            }
                            storageObjectImpl.setSyncEventInfo(this.virtualDevice, key);
                        }
                        builder.dataItem(key, ((ExternalObject)value).getURI());
                        continue block10;
                    }
                }
                DataImpl.getLogger().info("unknown type: " + (Object)((Object)field.getType()));
                continue;
            }
            if (field.isOptional()) continue;
            this.fieldValues.clear();
            throw new IllegalStateException("non-optional field '" + key + "' not set");
        }
        this.fieldValues.clear();
        builder.format(this.deviceModelFormat.getURN()).source(this.virtualDevice.getEndpointId());
        DataMessage message = builder.build();
        try {
            if (this.errorCallback != null) {
                VirtualDeviceImpl.addOnErrorCallback(message.getClientId(), this.errorCallback);
            }
            this.virtualDevice.queueMessage(message, storageObjects.toArray(new StorageObjectImpl[storageObjects.size()]));
        }
        catch (Throwable t) {
            DataImpl.getLogger().severe(t.toString());
        }
    }

    @Override
    public void setOnError(AbstractVirtualDevice.ErrorCallback<VirtualDevice> callback) {
        AbstractVirtualDevice.ErrorCallback<VirtualDevice> oldCallback = this.errorCallback;
        this.errorCallback = callback;
        VirtualDeviceImpl.replaceOnErrorCallback(oldCallback, this.errorCallback);
    }

    private DeviceModelFormat.Field getField(String fieldName) {
        if (this.deviceModelFormat == null) {
            return null;
        }
        List<DeviceModelFormat.Field> fieldList = this.deviceModelFormat.getFields();
        for (DeviceModelFormat.Field field : fieldList) {
            if (!field.getName().equals(fieldName)) continue;
            return field;
        }
        return null;
    }

    private static DeviceModelFormat getDeviceModelFormat(VirtualDevice virtualDevice, String dataUrn) {
        DeviceModel dm = virtualDevice.getDeviceModel();
        if (!(dm instanceof DeviceModelImpl)) {
            return null;
        }
        DeviceModelImpl deviceModel = (DeviceModelImpl)dm;
        return deviceModel.getDeviceModelFormats().get(dataUrn);
    }

    private static Logger getLogger() {
        return LOGGER;
    }
}

