/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.impl.device;

import com.oracle.iot.client.impl.device.ConnectionPoolManager;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;

class ConnectionPoolManagerImpl
implements ConnectionPoolManager {
    static final int DEFAULT_MIN_POOL_SIZE = 5;
    static final int DEFAULT_MAX_POOL_SIZE = 20;
    private static int MIN_POOL_SIZE = Integer.getInteger("com.oracle.iot.message_persistence_min_pool_size", 5);
    private static int MAX_POOL_SIZE = Integer.getInteger("com.oracle.iot.message_persistence_max_pool_size", 20);
    private final Logger logger;
    Queue<Connection> connectionPool = new LinkedList<Connection>();
    Thread connectionHandlerThread;
    private final DataSource dataSource;

    ConnectionPoolManagerImpl(DataSource dataSource, Logger logger) {
        this.dataSource = dataSource;
        this.logger = logger;
        this.initialize();
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                ConnectionPoolManagerImpl.this.stop();
            }
        }));
    }

    void initialize() {
        this.updateConnectionPool();
        this.startConnectionHandlerThread();
    }

    void startConnectionHandlerThread() {
        this.connectionHandlerThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (!this.isInterrupted()) {
                    ConnectionPoolManagerImpl.this.updateConnectionPool();
                    Queue<Connection> queue = ConnectionPoolManagerImpl.this.connectionPool;
                    synchronized (queue) {
                        try {
                            ConnectionPoolManagerImpl.this.connectionPool.wait();
                        }
                        catch (InterruptedException e) {
                            this.interrupt();
                            break;
                        }
                    }
                }
            }
        };
        this.connectionHandlerThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateConnectionPool() {
        block12: {
            int poolSizeDifference;
            block11: {
                poolSizeDifference = this.checkSizeOfConnectionPool();
                if (poolSizeDifference <= 0) break block11;
                for (int i = 0; i < poolSizeDifference; ++i) {
                    Connection connection = null;
                    while (connection == null) {
                        connection = this.createNewConnection();
                        if (connection == null) continue;
                        Queue<Connection> queue = this.connectionPool;
                        synchronized (queue) {
                            this.connectionPool.offer(connection);
                        }
                    }
                }
                break block12;
            }
            if (poolSizeDifference >= 0) break block12;
            for (int i = poolSizeDifference; i < 0; ++i) {
                Connection connection;
                Queue<Connection> queue = this.connectionPool;
                synchronized (queue) {
                    connection = this.connectionPool.poll();
                }
                try {
                    connection.close();
                    continue;
                }
                catch (SQLException e) {
                    this.logger.log(Level.WARNING, "Unable to close connection to database", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int checkSizeOfConnectionPool() {
        int minSize = 5;
        int maxSize = 10;
        if (minSize <= 0 || maxSize <= 0 || minSize >= maxSize) {
            minSize = 5;
            maxSize = 20;
        }
        Queue<Connection> queue = this.connectionPool;
        synchronized (queue) {
            int currentSize = this.connectionPool.size();
            if (currentSize > maxSize) {
                return maxSize - currentSize;
            }
            if (currentSize < minSize) {
                return minSize - currentSize;
            }
        }
        return 0;
    }

    Connection createNewConnection() {
        Connection connection;
        try {
            connection = this.dataSource.getConnection();
        }
        catch (SQLException e) {
            this.logger.log(Level.WARNING, "Cannot create new connection to database", e);
            return null;
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnectionFromPool() {
        Connection connection = null;
        Queue<Connection> queue = this.connectionPool;
        synchronized (queue) {
            while (this.connectionPool.size() > 0) {
                block8: {
                    connection = this.connectionPool.poll();
                    try {
                        if (connection.isClosed()) {
                            connection = null;
                        }
                        break block8;
                    }
                    catch (SQLException e) {
                        this.logger.log(Level.FINE, "Pre-created connection to database was already closed.", e);
                        connection = null;
                    }
                    continue;
                }
                if (connection == null) continue;
            }
            this.connectionPool.notify();
        }
        if (connection != null) {
            return connection;
        }
        this.logger.log(Level.FINE, "There are no more available connections");
        return this.createNewConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void returnConnectionToPool(Connection connection) {
        block6: {
            try {
                if (!connection.isClosed()) {
                    Queue<Connection> queue = this.connectionPool;
                    synchronized (queue) {
                        connection.setAutoCommit(true);
                        this.connectionPool.offer(connection);
                        this.connectionPool.notify();
                        break block6;
                    }
                }
                this.logger.log(Level.WARNING, "Trying to reuse closed connection");
            }
            catch (SQLException e) {
                this.logger.log(Level.WARNING, "Trying to reuse closed connection", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        this.connectionHandlerThread.interrupt();
        Queue<Connection> queue = this.connectionPool;
        synchronized (queue) {
            while (!this.connectionPool.isEmpty()) {
                try {
                    this.connectionPool.poll().close();
                }
                catch (SQLException e) {
                    this.logger.log(Level.FINE, "Cannot close connection to the database!", e);
                }
            }
        }
    }
}

