/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.impl;

import com.oracle.iot.client.DeviceModelAction;
import com.oracle.iot.client.DeviceModelAttribute;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.List;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

class DeviceModelActionImpl
extends DeviceModelAction {
    private final String name;
    private final String description;
    private final List<DeviceModelAction.Argument> argumentList;
    private final String alias;

    DeviceModelActionImpl(String name, String description, List<DeviceModelAction.Argument> argumentList, String alias) {
        this.name = name;
        this.description = description;
        this.argumentList = argumentList;
        this.alias = alias;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public List<DeviceModelAction.Argument> getArguments() {
        return this.argumentList;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    public String toString() {
        StringBuilder b = new StringBuilder("name = ");
        b.append(this.name);
        b.append(", description = ");
        b.append(this.description);
        b.append(", arguments = [");
        boolean first = true;
        String newline = System.getProperty("line.separator");
        for (DeviceModelAction.Argument argument : this.argumentList) {
            block4: {
                block3: {
                    if (!first) break block3;
                    first = false;
                    if (!false) break block4;
                }
                b.append(',').append(newline);
            }
            b.append('\t').append(argument.toString());
        }
        b.append("], alias = ");
        b.append(this.alias);
        return b.toString();
    }

    static class ArgumentImpl
    extends DeviceModelAction.Argument {
        private final String name;
        private final DeviceModelAttribute.Type argType;
        private final Number lowerBound;
        private final Number upperBound;
        private final Object defaultValue;

        ArgumentImpl(String name, DeviceModelAttribute.Type argType, Number lowerBound, Number upperBound, Object defaultValue) {
            this.name = name;
            this.argType = argType;
            if (this.argType == DeviceModelAttribute.Type.INTEGER || this.argType == DeviceModelAttribute.Type.NUMBER) {
                this.lowerBound = lowerBound;
                this.upperBound = upperBound;
            } else {
                this.upperBound = null;
                this.lowerBound = null;
            }
            this.defaultValue = defaultValue;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public DeviceModelAttribute.Type getArgType() {
            return this.argType;
        }

        @Override
        public Number getLowerBound() {
            return this.lowerBound;
        }

        @Override
        public Number getUpperBound() {
            return this.upperBound;
        }

        @Override
        public Object getDefaultValue() {
            return this.defaultValue;
        }

        public String toString() {
            StringBuilder b = new StringBuilder("{name = ");
            b.append(this.name);
            b.append(", type = ");
            b.append((Object)this.argType);
            b.append(", lowerBound = ");
            b.append(this.lowerBound);
            b.append(", upperBound = ");
            b.append(this.upperBound);
            b.append(", default = ");
            b.append(String.valueOf(this.defaultValue));
            b.append("}");
            return b.toString();
        }

        static DeviceModelAction.Argument fromJSON(JSONObject jsonObject) throws JSONException {
            Number max;
            Number min;
            DeviceModelAttribute.Type argType;
            String name = jsonObject.optString("name", "value");
            String type = jsonObject.getString("type");
            try {
                argType = DeviceModelAttribute.Type.valueOf(type);
            }
            catch (IllegalArgumentException e) {
                throw new JSONException("Invalid type: " + type);
            }
            String range = jsonObject.optString("range", null);
            if (range != null) {
                NumberFormat nf = NumberFormat.getNumberInstance(Locale.ROOT);
                String[] strings = range.split(",");
                try {
                    min = nf.parse(strings[0]);
                    max = nf.parse(strings[1]);
                }
                catch (ParseException e) {
                    throw new JSONException("Invalid range: " + range);
                }
            } else {
                min = null;
                max = null;
            }
            Object defaultValue = jsonObject.opt("defaultValue");
            return new ArgumentImpl(name, argType, min, max, defaultValue);
        }
    }
}

