/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.device.util;

import com.oracle.iot.client.device.util.RequestHandler;
import com.oracle.iot.client.message.Message;
import com.oracle.iot.client.message.RequestMessage;
import com.oracle.iot.client.message.ResponseMessage;
import com.oracle.iot.client.message.StatusCode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class RequestDispatcher {
    static final RequestHandler DEFAULT_HANDLER = new RequestHandler(){

        @Override
        public ResponseMessage handleRequest(RequestMessage request) throws Exception {
            try {
                ResponseMessage.Builder builder = new ResponseMessage.Builder(request).statusCode(StatusCode.NOT_FOUND);
                return builder.build();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
    };
    private static final RequestDispatcher INSTANCE = new RequestDispatcher();
    private final List<RequestHandlerRegistration> requestHandlerRegistrations = new ArrayList<RequestHandlerRegistration>();
    private RequestHandler defaultHandler = DEFAULT_HANDLER;
    private static final Logger LOGGER = Logger.getLogger("oracle.iot.client");

    public static RequestDispatcher getInstance() {
        return INSTANCE;
    }

    private RequestDispatcher() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerRequestHandler(String endpointId, String path, RequestHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("handler may not be null");
        }
        List<RequestHandlerRegistration> list = this.requestHandlerRegistrations;
        synchronized (list) {
            String normalizedPath;
            String normalizedEndpointId = endpointId == null || endpointId.length() == 0 ? "*" : endpointId;
            String string = normalizedPath = path == null || path.length() == 0 ? "*" : path;
            if ("*".equals(normalizedEndpointId) && "*".equals(normalizedPath)) {
                this.defaultHandler = handler;
                return;
            }
            RequestHandlerRegistration registration = new RequestHandlerRegistration(normalizedEndpointId, normalizedPath, handler);
            boolean found = false;
            int nMax = this.requestHandlerRegistrations.size();
            for (int n = 0; n < nMax; ++n) {
                RequestHandlerRegistration other = this.requestHandlerRegistrations.get(n);
                found = registration.equals(other);
                if (!found) continue;
                this.requestHandlerRegistrations.set(n, registration);
                break;
            }
            if (!found) {
                this.requestHandlerRegistrations.add(registration);
                Collections.sort(this.requestHandlerRegistrations);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterRequestHandler(String endpointId, String path) {
        List<RequestHandlerRegistration> list = this.requestHandlerRegistrations;
        synchronized (list) {
            String normalizedPath;
            String normalizedEndpointId = endpointId == null || endpointId.length() == 0 ? "*" : endpointId;
            String string = normalizedPath = path == null || path.length() == 0 ? "*" : path;
            if ("*".equals(normalizedEndpointId) && "*".equals(normalizedPath)) {
                this.defaultHandler = DEFAULT_HANDLER;
                return;
            }
            int nMax = this.requestHandlerRegistrations.size();
            for (int n = 0; n < nMax; ++n) {
                RequestHandlerRegistration other = this.requestHandlerRegistrations.get(n);
                String otherEndpointId = other.endpointId;
                String otherPath = other.path;
                if (!normalizedEndpointId.equals(otherEndpointId) || !normalizedPath.equals(other.path)) continue;
                this.requestHandlerRegistrations.remove(n);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterRequestHandler(RequestHandler handler) {
        List<RequestHandlerRegistration> list = this.requestHandlerRegistrations;
        synchronized (list) {
            if (handler == this.defaultHandler && this.defaultHandler != DEFAULT_HANDLER) {
                this.defaultHandler = DEFAULT_HANDLER;
                return;
            }
            for (int n = this.requestHandlerRegistrations.size() - 1; 0 <= n; --n) {
                RequestHandlerRegistration other = this.requestHandlerRegistrations.get(n);
                if (other.handler != handler) continue;
                this.requestHandlerRegistrations.remove(n);
            }
        }
    }

    public ResponseMessage dispatch(RequestMessage requestMessage) {
        if (requestMessage == null) {
            throw new IllegalArgumentException("requestMessage may not be null");
        }
        String endpointId = requestMessage.getDestination();
        String path = requestMessage.getURL();
        RequestHandler requestHandler = this.getRequestHandler(endpointId, path);
        try {
            ResponseMessage responseMessage = requestHandler.handleRequest(requestMessage);
            if (responseMessage == null) {
                if (RequestDispatcher.getLogger().isLoggable(Level.SEVERE)) {
                    RequestDispatcher.getLogger().log(Level.SEVERE, requestHandler.toString() + " returned null");
                }
                ResponseMessage.Builder builder = this.copyResponseMessage(new ResponseMessage.Builder(requestMessage).build()).statusCode(StatusCode.INTERNAL_SERVER_ERROR);
                return builder.build();
            }
            return responseMessage;
        }
        catch (Exception e) {
            if (RequestDispatcher.getLogger().isLoggable(Level.SEVERE)) {
                RequestDispatcher.getLogger().log(Level.SEVERE, requestHandler.toString() + " threw " + e.getMessage());
                e.printStackTrace();
            }
            ResponseMessage.Builder builder = ((ResponseMessage.Builder)new ResponseMessage.Builder(requestMessage).source(requestMessage.getDestination())).requestId(requestMessage.getId()).statusCode(StatusCode.INTERNAL_SERVER_ERROR);
            if (e.getMessage() != null) {
                builder.body(e.getMessage());
            }
            return builder.build();
        }
    }

    private ResponseMessage.Builder copyResponseMessage(Message message) {
        ResponseMessage responseMsg;
        ResponseMessage.Builder builder = new ResponseMessage.Builder();
        if (message instanceof ResponseMessage) {
            responseMsg = (ResponseMessage)message;
            builder = this.copyMessage(builder, responseMsg);
            Map<String, List<String>> oldHeader = responseMsg.getHeaders();
            Set<Map.Entry<String, List<String>>> headerEntries = oldHeader.entrySet();
            for (Map.Entry<String, List<String>> entry : headerEntries) {
                builder.header(entry.getKey(), entry.getValue());
            }
        } else {
            throw new IllegalArgumentException("Can not copy a different type of message");
        }
        builder = builder.body(Arrays.copyOf(responseMsg.getBody(), responseMsg.getBody().length)).statusCode(responseMsg.getStatusCode()).url(responseMsg.getURL()).requestId(responseMsg.getRequestId());
        return builder;
    }

    private ResponseMessage.Builder copyMessage(ResponseMessage.Builder builder, Message message) {
        builder.id(message.getId());
        builder.clientId(message.getClientId());
        builder.source(message.getSource());
        builder.destination(message.getDestination());
        builder.priority(message.getPriority());
        builder.properties(message.getProperties());
        builder.eventTime((long)message.getEventTime());
        builder.reliability(message.getReliability());
        builder.sender(message.getSender());
        builder = this.copyMap(builder, message.getDiagnostics());
        builder.direction(message.getDirection());
        builder.receivedTime(message.getReceivedTime());
        builder.sentTime(message.getSentTime());
        return builder;
    }

    private ResponseMessage.Builder copyMap(ResponseMessage.Builder builder, Map<String, Object> map) {
        if (map == null) {
            return builder;
        }
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            builder = (ResponseMessage.Builder)builder.diagnostic(entry.getKey(), entry.getValue());
        }
        return builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestHandler getRequestHandler(String endpointId, String path) {
        List<RequestHandlerRegistration> list = this.requestHandlerRegistrations;
        synchronized (list) {
            String normalizedPath;
            String normalizedEndpointId = endpointId == null || endpointId.length() == 0 ? "*" : endpointId;
            String string = normalizedPath = path == null || path.length() == 0 ? "*" : path;
            if ("*".equals(normalizedEndpointId) && "*".equals(normalizedPath)) {
                return this.defaultHandler;
            }
            int nMax = this.requestHandlerRegistrations.size();
            for (int n = 0; n < nMax; ++n) {
                RequestHandlerRegistration registration = this.requestHandlerRegistrations.get(n);
                String otherEndpointId = registration.endpointId;
                if (!normalizedEndpointId.equals(otherEndpointId) && !"*".equals(otherEndpointId)) continue;
                String otherPath = registration.path;
                if ("*".equals(otherPath)) {
                    return registration.handler;
                }
                int diff = otherPath.length() - normalizedPath.length();
                if (diff == 0) {
                    if (!normalizedPath.equals(otherPath)) continue;
                    return registration.handler;
                }
                if (diff >= 0 || !normalizedPath.startsWith(otherPath)) continue;
                return registration.handler;
            }
            return this.defaultHandler;
        }
    }

    private static Logger getLogger() {
        return LOGGER;
    }

    static final class RequestHandlerRegistration
    implements Comparable<RequestHandlerRegistration> {
        final String endpointId;
        final String path;
        final RequestHandler handler;

        RequestHandlerRegistration(String endpointId, String path, RequestHandler handler) {
            this.endpointId = endpointId == null || endpointId.length() == 0 ? "*" : endpointId;
            this.path = path == null || path.length() == 0 ? "*" : path;
            this.handler = handler;
        }

        @Override
        public int compareTo(RequestHandlerRegistration other) {
            int c = other.endpointId.compareTo(this.endpointId);
            if (c != 0) {
                return c;
            }
            int diff = other.path.length() - this.path.length();
            if (diff != 0) {
                return diff;
            }
            return other.path.compareTo(this.path);
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            RequestHandlerRegistration other = (RequestHandlerRegistration)obj;
            if (!this.endpointId.equals(other.endpointId)) {
                return false;
            }
            return this.path.equals(other.path);
        }

        public int hashCode() {
            return this.endpointId.hashCode() + this.path.hashCode();
        }

        public String toString() {
            return "RequestHandlerRegistration{" + this.endpointId + ", " + this.path + "}";
        }
    }
}

