/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.device.util;

import com.oracle.iot.client.device.DirectlyConnectedDevice;
import com.oracle.iot.client.device.util.RequestDispatcher;
import com.oracle.iot.client.impl.device.MessageDispatcherImpl;
import com.oracle.iot.client.message.Message;
import java.io.Closeable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public abstract class MessageDispatcher
implements Closeable {
    private static final Map<DirectlyConnectedDevice, MessageDispatcher> dispatcherMap = new HashMap<DirectlyConnectedDevice, MessageDispatcher>();
    private static final Logger LOGGER = Logger.getLogger("oracle.iot.client");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MessageDispatcher getMessageDispatcher(DirectlyConnectedDevice directlyConnectedDevice) {
        Map<DirectlyConnectedDevice, MessageDispatcher> map = dispatcherMap;
        synchronized (map) {
            MessageDispatcher messageDispatcher = dispatcherMap.get(directlyConnectedDevice);
            if (messageDispatcher == null) {
                messageDispatcher = new MessageDispatcherImpl(directlyConnectedDevice);
                dispatcherMap.put(directlyConnectedDevice, messageDispatcher);
            }
            return messageDispatcher;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setMessageDispatcher(DirectlyConnectedDevice directlyConnectedDevice, MessageDispatcher messageDispatcher) {
        Map<DirectlyConnectedDevice, MessageDispatcher> map = dispatcherMap;
        synchronized (map) {
            dispatcherMap.put(directlyConnectedDevice, messageDispatcher);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MessageDispatcher removeMessageDispatcher(DirectlyConnectedDevice directlyConnectedDevice) {
        Map<DirectlyConnectedDevice, MessageDispatcher> map = dispatcherMap;
        synchronized (map) {
            return dispatcherMap.remove(directlyConnectedDevice);
        }
    }

    public abstract RequestDispatcher getRequestDispatcher();

    public abstract void queue(Message ... var1);

    public void queue(Message message) {
        this.queue(new Message[]{message});
    }

    public abstract void offer(Message ... var1);

    public void offer(Message message) {
        this.offer(new Message[]{message});
    }

    public abstract void setOnError(ErrorCallback var1);

    public abstract void setOnDelivery(DeliveryCallback var1);

    private static Logger getLogger() {
        return LOGGER;
    }

    public static interface ErrorCallback {
        public void failed(List<Message> var1, Exception var2);
    }

    public static interface DeliveryCallback {
        public void delivered(List<Message> var1);
    }
}

