/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.device.persistence;

import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PersistenceMetaData {
    private static final Logger LOGGER = Logger.getLogger("oracle.iot.client");
    private static final String DB_NAME = AccessController.doPrivileged(new PrivilegedAction<String>(){

        @Override
        public String run() {
            String val = System.getProperty("com.oracle.iot.client.device.persistence_db_name");
            return val != null ? val : System.getProperty("com.oracle.iot.client.device.persistence.db_name", "persistence_store");
        }
    });
    private static final File LOCAL_STORE_DIRECTORY = AccessController.doPrivileged(new PrivilegedAction<File>(){

        @Override
        public File run() {
            String userDir = System.getProperty("user.dir");
            String local_store = System.getProperty("com.oracle.iot.client.device.persistence_directory");
            if (local_store == null) {
                local_store = System.getProperty("com.oracle.iot.client.device.persistence.directory", userDir);
            }
            return new File(local_store);
        }
    });
    private static final Integer ISOLATION_LEVEL = AccessController.doPrivileged(new PrivilegedAction<Integer>(){

        @Override
        public Integer run() {
            Integer val = Integer.getInteger("com.oracle.iot.client.device.persistence_isolation_level");
            if (val == null) {
                val = Integer.getInteger("com.oracle.iot.client.device.persistence.isolation_level");
            }
            return val;
        }
    });
    private static final boolean PERSISTENCE_ENABLED = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            String prop = System.getProperty("com.oracle.iot.client.device.persistence_enabled");
            if (prop == null) {
                prop = System.getProperty("com.oracle.iot.client.device.persistence.enabled", "true");
            }
            return Boolean.parseBoolean(prop);
        }
    });

    private static Logger getLogger() {
        return LOGGER;
    }

    public static String getDBName() {
        return DB_NAME;
    }

    public static File getLocalStorageDirectory() {
        return LOCAL_STORE_DIRECTORY;
    }

    public static int getIsolationLevel(Connection connection) {
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            int isolationLevel = ISOLATION_LEVEL == null ? databaseMetaData.getDefaultTransactionIsolation() : (databaseMetaData.supportsTransactions() ? (databaseMetaData.supportsTransactionIsolationLevel(ISOLATION_LEVEL) ? ISOLATION_LEVEL.intValue() : databaseMetaData.getDefaultTransactionIsolation()) : 0);
            return isolationLevel;
        }
        catch (SQLException e) {
            PersistenceMetaData.getLogger().log(Level.WARNING, "Could not get DatabaseMetaData", e);
            return 0;
        }
    }

    public static boolean isPersistenceEnabled() {
        return PERSISTENCE_ENABLED;
    }

    private PersistenceMetaData() {
    }
}

