/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client;

import com.oracle.iot.client.ExternalObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class StorageObject
extends ExternalObject {
    private final String name;
    private final String type;
    private final String encoding;
    private final Map<String, String> metadata;
    private String date;
    private long length;
    private InputStream inputStream;
    private OutputStream outputStream;

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public long getLength() {
        return this.length;
    }

    public String getDate() {
        return this.date;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
        if (inputStream != null) {
            this.outputStream = null;
        }
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
        if (outputStream != null) {
            this.inputStream = null;
        }
    }

    public abstract void sync() throws IOException, GeneralSecurityException;

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StorageObject other = (StorageObject)obj;
        if (!this.getURI().equals(other.getURI())) {
            return false;
        }
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        return !this.getType().equals(other.getType());
    }

    public int hashCode() {
        int hash = 5;
        hash = 61 * hash + this.name.hashCode();
        hash = 61 * hash + this.type.hashCode();
        hash = 61 * hash + this.getURI().hashCode();
        return hash;
    }

    protected void setAttributes(String date, long length) {
        this.date = date;
        this.length = length;
    }

    public void setCustomMetadata(String key, String value) {
        if (key == null || (key = key.trim()).isEmpty()) {
            throw new IllegalArgumentException("Key of metadata cannot be null or empty");
        }
        if (value == null || (value = value.trim()).isEmpty()) {
            throw new IllegalArgumentException("Value of metadata cannot be null or empty");
        }
        this.metadata.put(key, value);
    }

    public Map<String, String> getCustomMetadata() {
        return Collections.unmodifiableMap(this.metadata);
    }

    protected StorageObject(String uri, String name, String type, String encoding, String date, long length) {
        super(uri);
        this.name = name;
        this.type = type != null ? type : "application/octet-stream";
        this.encoding = encoding;
        this.date = date;
        this.length = length;
        this.metadata = new HashMap<String, String>();
    }
}

