/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client;

public enum RestApi {
    V1("v1"),
    V2("v2");

    private final String reqRoot;
    private final String privateRoot;
    private final boolean isWebApi = Boolean.getBoolean("com.oracle.iot.client.use_webapi");

    private RestApi(String version) {
        this.reqRoot = (this.isWebApi ? "/iot/webapi/" : "/iot/api/") + version;
        this.privateRoot = (this.isWebApi ? "/iot/privatewebapi/" : "/iot/privateapi/") + version;
    }

    public String getReqRoot() {
        return this.reqRoot;
    }

    public String getPrivateRoot() {
        return this.privateRoot;
    }

    public boolean isWebApi() {
        return this.isWebApi;
    }
}

