/*
 * Decompiled with CFR 0.152.
 */
package oracle.iot.client.enterprise;

import com.oracle.iot.client.HttpResponse;
import com.oracle.iot.client.SecureConnection;
import com.oracle.iot.client.impl.DeviceModelFactory;
import com.oracle.iot.client.impl.DeviceModelImpl;
import com.oracle.iot.client.impl.StorageConnectionBase;
import com.oracle.iot.client.impl.enterprise.ApplicationEnumerator;
import com.oracle.iot.client.impl.enterprise.ApplicationImpl;
import com.oracle.iot.client.impl.enterprise.DeviceEnumerator;
import com.oracle.iot.client.impl.enterprise.DeviceModelIterator;
import com.oracle.iot.client.impl.enterprise.SecureHttpConnectionMap;
import com.oracle.iot.client.impl.enterprise.StorageConnectionImpl;
import com.oracle.iot.client.impl.enterprise.StorageObjectImpl;
import com.oracle.iot.client.impl.enterprise.VirtualDeviceImpl;
import com.oracle.iot.client.impl.http.HttpSecureConnection;
import com.oracle.iot.client.message.StatusCode;
import com.oracle.iot.client.trust.TrustedAssetsManager;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.security.GeneralSecurityException;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import oracle.iot.client.Client;
import oracle.iot.client.DeviceModel;
import oracle.iot.client.StorageObject;
import oracle.iot.client.enterprise.Application;
import oracle.iot.client.enterprise.Device;
import oracle.iot.client.enterprise.Filter;
import oracle.iot.client.enterprise.Pageable;
import oracle.iot.client.enterprise.VirtualDevice;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class EnterpriseClient
extends Client<VirtualDevice> {
    private final HttpSecureConnection secureConnection;
    private final Application iotApp;

    public static EnterpriseClient newClient(String appName) throws IOException, GeneralSecurityException {
        return EnterpriseClient.newClient(appName, (Object)null);
    }

    public static EnterpriseClient newClient(String appName, Object context) throws IOException, GeneralSecurityException {
        TrustedAssetsManager tam = TrustedAssetsManager.Factory.getTrustedAssetsManager(context);
        return EnterpriseClient.newClientInternal(appName, context, tam);
    }

    public static EnterpriseClient newClient(String configFilePath, String configFilePassword, String appName, Object context) throws IOException, GeneralSecurityException {
        if (configFilePath == null) {
            throw new IllegalArgumentException("configFilePath may not be null");
        }
        TrustedAssetsManager tam = TrustedAssetsManager.Factory.getTrustedAssetsManager(configFilePath, configFilePassword, context);
        return EnterpriseClient.newClientInternal(appName, context, tam);
    }

    public static EnterpriseClient newClient(String configFilePath, String configFilePassword) throws IOException, GeneralSecurityException {
        return EnterpriseClient.newClient(configFilePath, configFilePassword, null, null);
    }

    private static EnterpriseClient newClientInternal(String appName, Object context, TrustedAssetsManager tam) throws IOException, GeneralSecurityException {
        HttpSecureConnection secureConnection = null;
        if (!tam.isActivated()) {
            System.setProperty("com.oracle.iot.client.use_webapi", "true");
            secureConnection = HttpSecureConnection.createUserAuthSecureConnection(tam);
        } else {
            secureConnection = HttpSecureConnection.createHttpSecureConnection(tam, true);
        }
        Filter filter = appName == null ? Filter.eq("integrations.id", tam.getEndpointId()) : Filter.eq("name", appName);
        ApplicationEnumerator.ApplicationEnumerationRequest r = new ApplicationEnumerator.ApplicationEnumerationRequest(null, null, filter, -1, -1);
        JSONObject res = EnterpriseClient.httpGet(secureConnection, r.headers(), r.request());
        try {
            JSONArray apps = res.getJSONArray("items");
            if (apps.length() != 1) {
                throw new IOException("Application " + (appName != null ? "with name=" + appName : "with integration.id=" + tam.getEndpointId()) + " cannot be retrieved");
            }
            Application app = ApplicationImpl.fromJson(apps.getJSONObject(0));
            if (appName != null && !appName.equals(app.getName())) {
                throw new IOException("Incorrect server response. Received [" + app.getName() + "] instead of " + appName);
            }
            EnterpriseClient client = new EnterpriseClient(app, secureConnection, context);
            SecureHttpConnectionMap.putSecureConnection(client, secureConnection);
            return client;
        }
        catch (JSONException e) {
            throw new IOException(e.getMessage());
        }
    }

    EnterpriseClient(Application iotApp, HttpSecureConnection secureConnection, Object context) {
        super(context);
        if (iotApp == null) {
            throw new NullPointerException("iotApp cannot be null");
        }
        this.iotApp = iotApp;
        this.secureConnection = secureConnection;
    }

    @Override
    public VirtualDevice createVirtualDevice(String endpointId, DeviceModel deviceModel) {
        if (endpointId == null) {
            throw new NullPointerException("endpointId may not be null");
        }
        if (deviceModel == null) {
            throw new NullPointerException("deviceModel may not be null");
        }
        if (!(deviceModel instanceof DeviceModelImpl)) {
            throw new IllegalArgumentException("device model must be an instanceof com.oracle.iot.client.impl.DeviceModelImpl");
        }
        return new VirtualDeviceImpl(this, this.secureConnection, endpointId, (DeviceModelImpl)deviceModel);
    }

    @Override
    public void close() throws IOException {
        this.secureConnection.close();
    }

    public Application getApplication() {
        return this.iotApp;
    }

    public Pageable<String> getDeviceModels() throws IOException, GeneralSecurityException {
        return new DeviceModelIterator(this.iotApp.getId(), 0, 200, this.secureConnection);
    }

    @Override
    public DeviceModel getDeviceModel(String deviceModelUrn) throws IOException, GeneralSecurityException {
        return DeviceModelFactory.getDeviceModel(this.iotApp.getId(), this.secureConnection, deviceModelUrn);
    }

    public Pageable<Device> getActiveDevices(String deviceModel) throws IOException, GeneralSecurityException {
        return this.getDevices(Device.Field.all(), Filter.and(Filter.eq(Device.Field.CONNECTIVITY_STATUS.alias(), "ONLINE"), Filter.eq(Device.Field.STATE.alias(), "ACTIVATED"), Filter.eq(Device.Field.DEVICE_MODELS.alias() + ".urn", deviceModel)));
    }

    public Pageable<Device> getDevices(Set<Device.Field> fields, Filter filter) throws IOException, GeneralSecurityException {
        return new DeviceEnumerator(this.iotApp.getId(), 0, 200, false, fields, filter, this.secureConnection);
    }

    private static JSONObject httpGet(HttpSecureConnection secureConnection, Map<String, String> headers, String request) throws IOException, GeneralSecurityException {
        HttpResponse res = secureConnection.get(request);
        int status = res.getStatus();
        if (status != StatusCode.OK.getCode()) {
            throw new IOException(res.getVerboseStatus("GET", request));
        }
        byte[] data = res.getData();
        if (data == null) {
            throw new IOException("GET " + request + ": failed: no data received");
        }
        String json = new String(data, "UTF-8");
        try {
            return new JSONObject(json);
        }
        catch (JSONException e) {
            throw new IOException("GET " + request + ": " + e.getMessage());
        }
    }

    @Override
    public StorageObject createStorageObject(String name, String contentType) throws IOException, GeneralSecurityException {
        StorageConnectionBase storageConnection = StorageConnectionMap.getStorageConnection(this.secureConnection);
        com.oracle.iot.client.StorageObject delegate = storageConnection.createStorageObject(this.secureConnection.getEndpointId(), name, contentType);
        return new StorageObjectImpl(delegate);
    }

    public StorageObject createStorageObject(String uri) throws IOException, GeneralSecurityException {
        StorageConnectionBase storageConnection = StorageConnectionMap.getStorageConnection(this.secureConnection);
        com.oracle.iot.client.StorageObject delegate = storageConnection.createStorageObject(uri);
        return new StorageObjectImpl(delegate);
    }

    private static class StorageConnectionMap {
        private static final Map<SecureConnection, WeakReference<StorageConnectionBase>> STORAGE_CONNECTION_MAP = new WeakHashMap<SecureConnection, WeakReference<StorageConnectionBase>>();

        private StorageConnectionMap() {
        }

        private static StorageConnectionBase getStorageConnection(SecureConnection secureConnection) {
            WeakReference<StorageConnectionBase> reference = STORAGE_CONNECTION_MAP.get(secureConnection);
            StorageConnectionBase storageConnection = null;
            if (reference != null) {
                storageConnection = (StorageConnectionBase)reference.get();
            }
            if (storageConnection == null) {
                storageConnection = new StorageConnectionImpl(secureConnection);
                STORAGE_CONNECTION_MAP.put(secureConnection, new WeakReference<StorageConnectionBase>(storageConnection));
            }
            return storageConnection;
        }
    }
}

