/*
 * Decompiled with CFR 0.152.
 */
package oracle.iot.client.enterprise;

import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class Device {
    public abstract List<String> getDeviceModels();

    public abstract String getValue(Field var1);

    public abstract boolean isDirectlyConnected();

    public abstract String getId();

    public abstract Map<String, String> getMetadata();

    public abstract String getMetadata(String var1);

    public abstract Location getLocation();

    protected Device() {
    }

    public static class Location {
        private final float latitude;
        private final float longitude;
        private final float altitude;
        private final float uncertainty;

        public Location(float latitude, float longitude, float altitude, float uncertainty) {
            this.latitude = latitude;
            this.longitude = longitude;
            this.altitude = altitude;
            this.uncertainty = uncertainty;
        }

        public float getLatitude() {
            return this.latitude;
        }

        public float getLongitude() {
            return this.longitude;
        }

        public float getAltitude() {
            return this.altitude;
        }

        public float getUncertainty() {
            return this.uncertainty;
        }
    }

    public static enum Field {
        ID("id"),
        DEVICE_UID("deviceUID"),
        TYPE("type"),
        DESCRIPTION("description"),
        CREATED("created"),
        STATE("state"),
        NAME("name"),
        MANUFACTURER("manufacturer"),
        MODEL_NUMBER("modelNumber"),
        SERIAL_NUMBER("serialNumber"),
        HARDWARE_REVISION("hardwareRevision"),
        SOFTWARE_REVISION("softwareRevision"),
        SOFTWARE_VERSION("softwareVersion"),
        ENABLED("enabled"),
        CONNECTIVITY_STATUS("connectivityStatus"),
        LAST_HEARD_TIME("lastHeardTime"),
        DEVICE_MODELS("deviceModels"),
        METADATA("metadata"),
        LOCATION("location"),
        DIRECTLY_CONNECTED_OWNER("directlyConnectedOwner");

        final String alias;

        private Field(String alias) {
            this.alias = alias;
        }

        public static Field fromAlias(String alias) {
            for (Field f : Field.values()) {
                if (!f.alias.equals(alias)) continue;
                return f;
            }
            return null;
        }

        public static Set<Field> all() {
            return EnumSet.allOf(Field.class);
        }

        public String alias() {
            return this.alias;
        }
    }
}

