/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.message;

import com.oracle.iot.client.message.Message;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class MessageProperties {
    private final Map<String, List<String>> propertiesTable;

    private MessageProperties(Builder builder) {
        this.propertiesTable = builder.propertiesTable;
    }

    public final boolean containsKey(String key) {
        return this.propertiesTable.containsKey(key);
    }

    public final Set<String> getKeys() {
        return Collections.unmodifiableSet(this.propertiesTable.keySet());
    }

    public final List<String> getProperties(String key) {
        return Collections.unmodifiableList(this.propertiesTable.get(key));
    }

    public final String getProperty(String key) {
        List<String> propertyValues = this.propertiesTable.get(key);
        if (propertyValues != null && propertyValues.size() > 0) {
            return propertyValues.get(0);
        }
        return null;
    }

    public final String getProperty(String key, int index) {
        List<String> propertyValues = this.propertiesTable.get(key);
        if (propertyValues != null && propertyValues.size() > index) {
            return propertyValues.get(index);
        }
        return null;
    }

    public final Map<String, List<String>> getAllProperties() {
        return Collections.unmodifiableMap(this.propertiesTable);
    }

    public final String toString() {
        return this.toJson().toString();
    }

    public final JSONObject toJson() {
        JSONObject properties = new JSONObject();
        for (String k : this.getKeys()) {
            JSONArray jsonValue = new JSONArray();
            List<String> values = this.getProperties(k);
            for (String v : values) {
                jsonValue.put(v);
            }
            try {
                properties.put(k, jsonValue);
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
        }
        return properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageProperties that = (MessageProperties)o;
        return this.propertiesTable.equals(that.propertiesTable);
    }

    public int hashCode() {
        return this.propertiesTable.hashCode();
    }

    public static final class Builder {
        private Map<String, List<String>> propertiesTable = new HashMap<String, List<String>>();

        public final Builder addValue(String key, String value) {
            Message.Utils.checkNullValueThrowsNPE(key, "MessageProperties: Key");
            Message.Utils.checkEmptyStringThrowsIAE(key, "MessageProperties: Key");
            Message.Utils.checkNullValueThrowsNPE(value, "MessageProperties: Value");
            Message.Utils.checkKeyLengthAndThrowIAE(key, "MessageProperties: Key");
            Message.Utils.checkValueLengthAndThrowIAE(value, "MessageProperties: Key");
            List<String> values = this.propertiesTable.containsKey(key) ? this.propertiesTable.get(key) : new ArrayList<String>();
            values.add(value);
            this.propertiesTable.put(key, values);
            return this;
        }

        public final Builder addValues(String key, List<String> values) {
            Message.Utils.checkNullValueThrowsNPE(key, "MessageProperties: Key");
            Message.Utils.checkEmptyStringThrowsIAE(key, "MessageProperties: Key");
            Message.Utils.checkNullValueThrowsNPE(values, "MessageProperties: Values");
            Message.Utils.checkNullValuesThrowsNPE(values, "MessageProperties: Values");
            Message.Utils.checkKeyLengthAndThrowIAE(key, "MessageProperties: Key");
            Message.Utils.checkValuesLengthAndThrowIAE(values, "MessageProperties: Values");
            List<String> existingValues = this.propertiesTable.containsKey(key) ? this.propertiesTable.get(key) : new ArrayList<String>();
            existingValues.addAll(values);
            this.propertiesTable.put(key, existingValues);
            return this;
        }

        public final Builder copy(MessageProperties properties) {
            for (String key : properties.getKeys()) {
                ArrayList<String> values = new ArrayList<String>(properties.getProperties(key).size());
                for (String value : properties.getProperties(key)) {
                    values.add(value);
                }
                this.propertiesTable.put(key, values);
            }
            return this;
        }

        public final MessageProperties build() {
            return new MessageProperties(this);
        }
    }
}

