/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.impl.http;

import com.oracle.iot.client.HttpResponse;
import com.oracle.iot.client.impl.http.HttpClientImpl;
import com.oracle.iot.client.impl.http.HttpSecureConnectionImpl;
import com.oracle.iot.client.trust.TrustedAssetsManager;
import java.io.IOException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class HttpSecureConnectionUserAuthImpl
extends HttpSecureConnectionImpl {
    private static final Logger LOGGER = Logger.getLogger("oracle.iot.client");

    public HttpSecureConnectionUserAuthImpl(TrustedAssetsManager tam) throws GeneralSecurityException {
        super(tam, false);
    }

    protected HttpResponse invoke(String method, String restApi, byte[] payload) throws IOException, GeneralSecurityException {
        return this.invoke(method, restApi, payload, -1);
    }

    protected HttpResponse invoke(String method, String restApi, byte[] payload, int timeout) throws IOException, GeneralSecurityException {
        String serverHost = this.getTrustedAssetsManager().getServerHost();
        int serverPort = this.getTrustedAssetsManager().getServerPort();
        URL url = new URL("https", serverHost, serverPort, restApi);
        HashMap<String, String> headers = new HashMap<String, String>(3);
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/json");
        HttpClientImpl httpClient = new HttpClientImpl(this.getSSLSocketFactory(), url);
        HttpResponse response = this.invoke(httpClient, method, payload, headers, timeout);
        if (HttpSecureConnectionUserAuthImpl.getLogger().isLoggable(Level.FINEST)) {
            HttpSecureConnectionUserAuthImpl.getLogger().log(Level.FINEST, response.getVerboseStatus(method, url.toExternalForm()));
        }
        return response;
    }

    private static Logger getLogger() {
        return LOGGER;
    }
}

