/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.impl.enterprise;

import com.oracle.iot.client.DeviceModelAction;
import com.oracle.iot.client.DeviceModelAttribute;
import com.oracle.iot.client.HttpResponse;
import com.oracle.iot.client.RestApi;
import com.oracle.iot.client.VirtualDeviceAttribute;
import com.oracle.iot.client.impl.DeviceModelImpl;
import com.oracle.iot.client.impl.VirtualDeviceAttributeBase;
import com.oracle.iot.client.impl.VirtualDeviceBase;
import com.oracle.iot.client.impl.enterprise.ActionImpl;
import com.oracle.iot.client.impl.enterprise.Controller;
import com.oracle.iot.client.impl.enterprise.Monitor;
import com.oracle.iot.client.impl.enterprise.StorageObjectImpl;
import com.oracle.iot.client.impl.enterprise.VirtualDeviceAttributeImpl;
import com.oracle.iot.client.impl.http.HttpSecureConnection;
import com.oracle.iot.client.impl.util.Pair;
import com.oracle.iot.client.message.StatusCode;
import java.io.IOException;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.iot.client.AbstractVirtualDevice;
import oracle.iot.client.DeviceModel;
import oracle.iot.client.ExternalObject;
import oracle.iot.client.StorageObject;
import oracle.iot.client.enterprise.Action;
import oracle.iot.client.enterprise.EnterpriseClient;
import oracle.iot.client.enterprise.VirtualDevice;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class VirtualDeviceImpl
extends VirtualDevice
implements VirtualDeviceBase.Adapter<VirtualDevice> {
    private final HttpSecureConnection secureConnection;
    private final VirtualDeviceBase base;
    private final EnterpriseClient enterpriseClient;
    private final Map<String, VirtualDeviceAttributeBase<VirtualDevice, Object>> attributeMap;
    private final Object isDeviceAppLock = new Object();
    private volatile Boolean isDeviceApp;
    private Map<String, VirtualDevice.AlertCallback> alertCallbackMap;
    private Map<String, VirtualDevice.DataCallback> dataCallbackMap;
    private Monitor.NotifyHandler notifyHandler = new Monitor.NotifyHandler(){

        @Override
        public void notifyOnChange(VirtualDeviceImpl virtualDevice, VirtualDeviceAttributeImpl<?>[] attributes) {
            if (attributes == null || attributes.length == 0) {
                assert (false);
                return;
            }
            AbstractVirtualDevice.ChangeCallback<VirtualDeviceImpl> globalCallback = VirtualDeviceImpl.this.base.getOnChangeCallback();
            VirtualDeviceBase.NamedValueImpl root = null;
            VirtualDeviceBase.NamedValueImpl last = null;
            for (VirtualDeviceAttributeImpl<?> attribute : attributes) {
                String attributeName = attribute.getDeviceModelAttribute().getName();
                VirtualDeviceAttributeBase<VirtualDevice, Object> currentField = VirtualDeviceImpl.this.getAttribute(attributeName);
                Object newValue = attribute.get();
                Object oldValue = currentField.get();
                if (oldValue != null ? oldValue.equals(newValue) : newValue == null) continue;
                VirtualDeviceBase.NamedValueImpl nameValue = new VirtualDeviceBase.NamedValueImpl(attributeName, newValue);
                try {
                    currentField.update(newValue);
                    AbstractVirtualDevice.ChangeCallback<VirtualDevice> attributeChangeCallback = currentField.getOnChange();
                    if (globalCallback == null && attributeChangeCallback == null) continue;
                    if (attributeChangeCallback != null) {
                        attributeChangeCallback.onChange(new VirtualDeviceBase.ChangeEvent<VirtualDeviceImpl>(virtualDevice, nameValue));
                    }
                    if (last != null) {
                        last.setNext(nameValue);
                        last = nameValue;
                        continue;
                    }
                    root = last = nameValue;
                }
                catch (Exception e) {
                    VirtualDeviceImpl.getLogger().log(Level.SEVERE, e.getMessage(), e);
                }
            }
            if (globalCallback != null && root != null) {
                try {
                    globalCallback.onChange(new VirtualDeviceBase.ChangeEvent<VirtualDeviceImpl>(virtualDevice, root));
                }
                catch (Exception e) {
                    VirtualDeviceImpl.getLogger().log(Level.SEVERE, e.getMessage(), e);
                }
            }
        }

        @Override
        public void notifyOnAlert(VirtualDeviceImpl virtualDevice, String format, long eventTime, AbstractVirtualDevice.NamedValue<?> namedValues) {
            if (VirtualDeviceImpl.this.alertCallbackMap == null || !VirtualDeviceImpl.this.alertCallbackMap.containsKey(format) && !VirtualDeviceImpl.this.alertCallbackMap.containsKey("*")) {
                VirtualDeviceImpl.getLogger().log(Level.FINEST, "no callbacks for alerts");
                return;
            }
            try {
                Date when = new Date(eventTime);
                VirtualDevice.AlertCallback callback = (VirtualDevice.AlertCallback)virtualDevice.alertCallbackMap.get(format);
                if (callback != null) {
                    callback.onAlert(new AlertEventImpl(virtualDevice, format, namedValues, when));
                }
                if ((callback = (VirtualDevice.AlertCallback)virtualDevice.alertCallbackMap.get("*")) != null) {
                    callback.onAlert(new AlertEventImpl(virtualDevice, format, namedValues, when));
                }
            }
            catch (Exception e) {
                VirtualDeviceImpl.getLogger().log(Level.SEVERE, e.getMessage(), e);
            }
        }

        @Override
        public void notifyOnData(VirtualDeviceImpl virtualDevice, String format, long eventTime, AbstractVirtualDevice.NamedValue<?> namedValues) {
            if (VirtualDeviceImpl.this.dataCallbackMap == null || !VirtualDeviceImpl.this.dataCallbackMap.containsKey(format) && !VirtualDeviceImpl.this.dataCallbackMap.containsKey("*")) {
                VirtualDeviceImpl.getLogger().fine("no callbacks for custom data");
                return;
            }
            try {
                Date when = new Date(eventTime);
                VirtualDevice.DataCallback callback = (VirtualDevice.DataCallback)virtualDevice.dataCallbackMap.get(format);
                if (callback != null) {
                    callback.onData(new DataEventImpl(virtualDevice, format, namedValues, when));
                }
                if ((callback = (VirtualDevice.DataCallback)virtualDevice.dataCallbackMap.get("*")) != null) {
                    callback.onData(new DataEventImpl(virtualDevice, format, namedValues, when));
                }
            }
            catch (Exception e) {
                VirtualDeviceImpl.getLogger().log(Level.SEVERE, e.getMessage(), e);
            }
        }
    };
    private static final String UPDATE_DEVICE_RESOURCE = RestApi.V2.getReqRoot() + "/apps/%1$s/devices/%2$s/deviceModels/%3$s/attributes";
    private static final String UPDATE_DEVICE_APP_RESOURCE = RestApi.V2.getReqRoot() + "/apps/%1$s/deviceApps/%2$s/deviceModels/%3$s/attributes";
    private static final String DEVICE_ATTRIBUTES_FORMAT = RestApi.V2.getReqRoot() + "/apps/%1$s/devices/%2$s/deviceModels/%3$s/attributes/%4$s";
    private static final String DEVICE_APP_ATTRIBUTES_FORMAT = RestApi.V2.getReqRoot() + "/apps/%1$s/deviceApps/%2$s/deviceModels/%3$s/attributes/%4$s";
    static final String DEVICE_ACTION_FORMAT = RestApi.V2.getReqRoot() + "/apps/%1$s/devices/%2$s/deviceModels/%3$s/actions/%4$s";
    static final String DEVICE_APP_ACTION_FORMAT = RestApi.V2.getReqRoot() + "/apps/%1$s/deviceApps/%2$s/deviceModels/%3$s/actions/%4$s";
    private static final String PAYLOAD_FORMAT = "{ \"%1$s\" : \"%2$s\" }";
    private static final String NUMBER_PAYLOAD_FORMAT = "{ \"%1$s\" : %2$s }";
    private static final Logger LOGGER = Logger.getLogger("oracle.iot.client");

    public VirtualDeviceImpl(EnterpriseClient enterpriseClient, HttpSecureConnection secureConnection, String endpointId, DeviceModelImpl model) {
        this.secureConnection = secureConnection;
        this.base = new VirtualDeviceBase<VirtualDevice>(this, endpointId, model);
        this.enterpriseClient = enterpriseClient;
        this.attributeMap = new HashMap<String, VirtualDeviceAttributeBase<VirtualDevice, Object>>();
        try {
            Monitor.startMonitor(this, this.notifyHandler);
        }
        catch (IOException ioe) {
            VirtualDeviceImpl.getLogger().log(Level.WARNING, "Failed to create virtual device", ioe);
            throw new IllegalArgumentException("Failed to create virtual device", ioe);
        }
        catch (GeneralSecurityException gse) {
            VirtualDeviceImpl.getLogger().log(Level.WARNING, "Failed to create virtual device", gse);
            throw new RuntimeException("Failed to create virtual device", gse);
        }
    }

    VirtualDeviceImpl(HttpSecureConnection secureConnection, DeviceModelImpl model) {
        this.enterpriseClient = null;
        this.secureConnection = secureConnection;
        this.base = new VirtualDeviceBase<VirtualDevice>(this, secureConnection.getEndpointId(), model);
        this.attributeMap = new HashMap<String, VirtualDeviceAttributeBase<VirtualDevice, Object>>();
    }

    public EnterpriseClient getEnterpriseClient() {
        return this.enterpriseClient;
    }

    HttpSecureConnection getSecureConnection() {
        return this.secureConnection;
    }

    @Override
    public VirtualDeviceAttributeBase<VirtualDevice, Object> getAttribute(String attributeName) {
        VirtualDeviceAttributeBase<VirtualDevice, Object> virtualDeviceAttribute = null;
        if (!this.attributeMap.containsKey(attributeName)) {
            virtualDeviceAttribute = this.createAttribute(attributeName);
            this.attributeMap.put(attributeName, virtualDeviceAttribute);
        } else {
            virtualDeviceAttribute = this.attributeMap.get(attributeName);
        }
        if (virtualDeviceAttribute == null) {
            throw new IllegalArgumentException("no such attribute '" + attributeName + "'");
        }
        return virtualDeviceAttribute;
    }

    @Override
    public void setValue(VirtualDeviceAttributeBase<VirtualDevice, Object> deviceAttribute, Object value) {
        if (deviceAttribute == null) {
            throw new NullPointerException("attribute cannot be null");
        }
        this.remoteSet(deviceAttribute, value);
    }

    @Override
    public DeviceModel getDeviceModel() {
        return this.base.getDeviceModel();
    }

    @Override
    public String getEndpointId() {
        return this.base.getEndpointId();
    }

    @Override
    public <T> T get(String attributeName) {
        VirtualDeviceAttributeBase<VirtualDevice, Object> attribute = this.getAttribute(attributeName);
        return (T)attribute.get();
    }

    @Override
    public <T> T getLastKnown(String attributeName) {
        VirtualDeviceAttributeBase<VirtualDevice, Object> attribute = this.getAttribute(attributeName);
        return (T)attribute.getLastKnown();
    }

    @Override
    public <T> VirtualDevice set(String attributeName, T value) {
        this.base.set(attributeName, value);
        return this;
    }

    @Override
    public VirtualDevice update() {
        this.base.update();
        return this;
    }

    @Override
    public void finish() {
        this.base.finish();
    }

    @Override
    public void updateFields(final List<Pair<VirtualDeviceAttributeBase<VirtualDevice, Object>, Object>> updatedAttributes) {
        JSONObject objectBuilder = new JSONObject();
        for (Pair<VirtualDeviceAttributeBase<VirtualDevice, Object>, Object> entry : updatedAttributes) {
            VirtualDeviceAttributeBase<VirtualDevice, Object> attribute = entry.getKey();
            Object value = entry.getValue();
            String attributeName = attribute.getDeviceModelAttribute().getName();
            try {
                switch (attribute.getDeviceModelAttribute().getType()) {
                    case NUMBER: 
                    case INTEGER: 
                    case STRING: 
                    case BOOLEAN: {
                        objectBuilder.put(attributeName, value);
                        break;
                    }
                    case DATETIME: {
                        long dateTime = value instanceof Date ? ((Date)value).getTime() : ((Number)value).longValue();
                        objectBuilder.put(attributeName, dateTime);
                        break;
                    }
                    case URI: {
                        if (!this.syncStorageObject(attributeName, value)) {
                            this.processOnError(this, updatedAttributes, "Content sync failed.");
                            return;
                        }
                        objectBuilder.put(attributeName, ((ExternalObject)value).getURI());
                    }
                }
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
        }
        EnterpriseClient ec = this.getEnterpriseClient();
        String resource_format = this.isDeviceApp() ? UPDATE_DEVICE_APP_RESOURCE : UPDATE_DEVICE_RESOURCE;
        String appId = ec.getApplication().getId();
        Controller.update(this, "PATCH", String.format(resource_format, appId, this.getEndpointId(), this.getDeviceModel().getURN()), objectBuilder.toString(), new Controller.Callback(){

            @Override
            public void onError(VirtualDevice virtualDevice, String resource, String payload, String reason) {
                VirtualDeviceImpl.this.processOnError(virtualDevice, updatedAttributes, reason);
            }
        });
    }

    @Override
    public void setOnChange(String attributeName, AbstractVirtualDevice.ChangeCallback callback) {
        VirtualDeviceAttributeBase<VirtualDevice, Object> attribute = this.getAttribute(attributeName);
        ((VirtualDeviceAttribute)attribute).setOnChange(callback);
    }

    @Override
    public void setOnChange(AbstractVirtualDevice.ChangeCallback callback) {
        this.base.setOnChange(callback);
    }

    @Override
    public void setOnError(AbstractVirtualDevice.ErrorCallback callback) {
        this.base.setOnError(callback);
    }

    @Override
    public void setOnError(String attributeName, AbstractVirtualDevice.ErrorCallback callback) {
        VirtualDeviceAttributeBase<VirtualDevice, Object> attribute = this.getAttribute(attributeName);
        ((VirtualDeviceAttribute)attribute).setOnError(callback);
    }

    @Override
    public void setOnAlert(String formatURN, VirtualDevice.AlertCallback callback) {
        if (formatURN == null || formatURN.isEmpty()) {
            throw new IllegalArgumentException("format URN may not be null or empty");
        }
        if (!"*".equals(formatURN)) {
            boolean isValid;
            DeviceModelImpl deviceModelImpl = this.base.getDeviceModel();
            boolean bl = isValid = deviceModelImpl.getDeviceModelFormats().get(formatURN) != null;
            if (!isValid) {
                throw new IllegalArgumentException(formatURN + " not found in model");
            }
        }
        if (this.alertCallbackMap == null) {
            this.alertCallbackMap = new HashMap<String, VirtualDevice.AlertCallback>();
        }
        if (callback != null) {
            this.alertCallbackMap.put(formatURN, callback);
        } else {
            this.alertCallbackMap.remove(formatURN);
        }
    }

    @Override
    public void setOnAlert(VirtualDevice.AlertCallback callback) {
        this.setOnAlert("*", callback);
    }

    @Override
    public void setOnData(String formatURN, VirtualDevice.DataCallback callback) {
        if (formatURN == null || formatURN.isEmpty()) {
            throw new IllegalArgumentException("format URN may not be null or empty");
        }
        if (!"*".equals(formatURN)) {
            boolean isValid;
            DeviceModelImpl deviceModelImpl = this.base.getDeviceModel();
            boolean bl = isValid = deviceModelImpl.getDeviceModelFormats().get(formatURN) != null;
            if (!isValid) {
                throw new IllegalArgumentException(formatURN + " not found in model");
            }
        }
        if (this.dataCallbackMap == null) {
            this.dataCallbackMap = new HashMap<String, VirtualDevice.DataCallback>();
        }
        if (callback != null) {
            this.dataCallbackMap.put(formatURN, callback);
        } else {
            this.dataCallbackMap.remove(formatURN);
        }
    }

    @Override
    public void setOnData(VirtualDevice.DataCallback callback) {
        this.setOnData("*", callback);
    }

    private <T> VirtualDeviceAttributeBase<VirtualDevice, T> createAttribute(String attributeName) {
        if (attributeName == null || attributeName.length() == 0) {
            return null;
        }
        DeviceModelImpl deviceModelImpl = this.base.getDeviceModel();
        DeviceModelAttribute deviceModelAttribute = deviceModelImpl.getDeviceModelAttributes().get(attributeName);
        return deviceModelAttribute != null ? new VirtualDeviceAttributeImpl(this, deviceModelAttribute) : null;
    }

    private void processOnError(VirtualDevice virtualDevice, VirtualDeviceAttributeBase<VirtualDevice, ?> attribute, Object newValue, String reason) {
        if (attribute.getOnError() == null && this.base.getOnErrorCallback() == null) {
            return;
        }
        try {
            String name = ((VirtualDeviceAttributeImpl)attribute).getDeviceModelAttribute().getName();
            VirtualDeviceBase.NamedValueImpl<Object> namedValue = new VirtualDeviceBase.NamedValueImpl<Object>(name, newValue);
            if (attribute.getOnError() != null) {
                attribute.getOnError().onError(new VirtualDeviceBase.ErrorEvent<VirtualDevice>(virtualDevice, namedValue, reason));
            }
            if (this.base.getOnErrorCallback() != null) {
                this.base.getOnErrorCallback().onError(new VirtualDeviceBase.ErrorEvent<VirtualDevice>(virtualDevice, namedValue, reason));
            }
        }
        catch (Exception e) {
            VirtualDeviceImpl.getLogger().log(Level.SEVERE, e.getMessage(), e);
        }
    }

    void processOnError(VirtualDevice virtualDevice, String action, Object data, String reason) {
        if (this.base.getOnErrorCallback() == null) {
            return;
        }
        try {
            VirtualDeviceBase.NamedValueImpl<Object> namedValue = new VirtualDeviceBase.NamedValueImpl<Object>(action, data);
            if (this.base.getOnErrorCallback() != null) {
                this.base.getOnErrorCallback().onError(new VirtualDeviceBase.ErrorEvent<VirtualDevice>(virtualDevice, namedValue, reason));
            }
        }
        catch (Exception e) {
            VirtualDeviceImpl.getLogger().log(Level.SEVERE, e.getMessage(), e);
        }
    }

    private void processOnError(VirtualDevice virtualDevice, List<Pair<VirtualDeviceAttributeBase<VirtualDevice, Object>, Object>> attributes, String reason) {
        try {
            VirtualDeviceBase.NamedValueImpl<Object> namedValueList = null;
            VirtualDeviceBase.NamedValueImpl<Object> namedValuePtr = null;
            for (Pair<VirtualDeviceAttributeBase<VirtualDevice, Object>, Object> entry : attributes) {
                VirtualDeviceAttributeBase<VirtualDevice, Object> attribute = entry.getKey();
                if (this.base.getOnErrorCallback() == null && attribute.getOnError() == null) continue;
                VirtualDeviceBase.NamedValueImpl<Object> namedValue = new VirtualDeviceBase.NamedValueImpl<Object>(((VirtualDeviceAttributeImpl)attribute).getDeviceModelAttribute().getName(), entry.getValue());
                if (attribute.getOnError() != null) {
                    attribute.getOnError().onError(new VirtualDeviceBase.ErrorEvent<VirtualDevice>(virtualDevice, namedValue, reason));
                }
                if (this.base.getOnErrorCallback() == null) continue;
                if (namedValueList == null) {
                    namedValuePtr = namedValueList = namedValue;
                    continue;
                }
                namedValuePtr.setNext(namedValue);
                namedValuePtr = namedValue;
            }
            if (this.base.getOnErrorCallback() != null) {
                this.base.getOnErrorCallback().onError(new VirtualDeviceBase.ErrorEvent<VirtualDevice>(virtualDevice, namedValueList, reason));
            }
        }
        catch (Exception e) {
            VirtualDeviceImpl.getLogger().log(Level.SEVERE, e.getMessage(), e);
        }
    }

    void remoteSet(final VirtualDeviceAttributeBase<VirtualDevice, ?> attribute, final Object value) {
        DeviceModelAttribute<?> deviceModelAttribute = attribute.getDeviceModelAttribute();
        if (deviceModelAttribute.getAccess() != DeviceModelAttribute.Access.WRITE_ONLY && deviceModelAttribute.getAccess() != DeviceModelAttribute.Access.READ_WRITE) {
            throw new IllegalArgumentException(deviceModelAttribute.getName() + "is not writable");
        }
        String appid = this.getEnterpriseClient().getApplication().getId();
        String name = deviceModelAttribute.getName();
        String attributes_format = this.isDeviceApp() ? DEVICE_APP_ATTRIBUTES_FORMAT : DEVICE_ATTRIBUTES_FORMAT;
        String resource = String.format(attributes_format, appid, this.getEndpointId(), this.getDeviceModel().getURN(), name);
        boolean syncFailed = false;
        if (deviceModelAttribute.getType() == DeviceModelAttribute.Type.URI) {
            syncFailed = !this.syncStorageObject(name, value);
        }
        String payload = VirtualDeviceImpl.getPayload(deviceModelAttribute.getType(), "value", value);
        if (syncFailed) {
            this.processOnError((VirtualDevice)this, name, (Object)payload, "Content sync failed.");
            return;
        }
        Controller.update(this, "PUT", resource, payload, new Controller.Callback(){

            @Override
            public void onError(VirtualDevice virtualDevice, String resource, String payload, String reason) {
                VirtualDeviceImpl.this.processOnError(virtualDevice, attribute, value, reason);
            }
        });
    }

    private static String getPayload(DeviceModelAttribute.Type type, String name, Object value) {
        String payload = null;
        if (type != null && value != null) {
            switch (type) {
                case INTEGER: {
                    payload = String.format(NUMBER_PAYLOAD_FORMAT, name, ((Number)value).intValue());
                    break;
                }
                case NUMBER: {
                    payload = String.format(NUMBER_PAYLOAD_FORMAT, name, Float.valueOf(((Number)value).floatValue()));
                    break;
                }
                default: {
                    payload = String.format(PAYLOAD_FORMAT, name, String.valueOf(value));
                    break;
                }
                case BOOLEAN: {
                    payload = String.format(NUMBER_PAYLOAD_FORMAT, name, value);
                    break;
                }
                case DATETIME: {
                    long dateTime = value instanceof Date ? ((Date)value).getTime() : ((Number)value).longValue();
                    payload = String.format(NUMBER_PAYLOAD_FORMAT, name, dateTime);
                    break;
                }
                case URI: {
                    if (value instanceof ExternalObject) {
                        payload = String.format(PAYLOAD_FORMAT, name, ((ExternalObject)value).getURI());
                        break;
                    } else {
                        break;
                    }
                }
            }
        } else {
            payload = "{\"" + name + "\": null}";
        }
        return payload;
    }

    private void checkActionDataType(DeviceModelAttribute.Type type, String name, Object value) throws IllegalArgumentException {
        if (type != null) {
            switch (type) {
                case INTEGER: {
                    if (!(value instanceof Number)) {
                        throw new IllegalArgumentException(name + " requires an Integer or a Number argument");
                    }
                }
                case NUMBER: {
                    if (value instanceof Number) break;
                    throw new IllegalArgumentException(name + " requires a Number argument");
                }
                case STRING: {
                    if (value instanceof String) break;
                    throw new IllegalArgumentException(name + " requires a String argument");
                }
                case BOOLEAN: {
                    if (value instanceof Boolean) break;
                    throw new IllegalArgumentException(name + " requires a Boolean argument");
                }
                case DATETIME: {
                    if (value instanceof Date || value instanceof Long) break;
                    throw new IllegalArgumentException(name + " requires a Date or a Long argument");
                }
                case URI: {
                    if (value instanceof ExternalObject) break;
                    throw new IllegalArgumentException(name + " requires an ExternalObject argument");
                }
                default: {
                    VirtualDeviceImpl.getLogger().log(Level.INFO, "unexpected type: " + (Object)((Object)type));
                }
            }
        }
    }

    @Override
    @Deprecated
    public <T> void call(final String actionName, final T data) {
        DeviceModelImpl deviceModel = (DeviceModelImpl)this.getDeviceModel();
        DeviceModelAction dma = deviceModel.getDeviceModelActions().get(actionName);
        if (dma == null) {
            for (DeviceModelAction act : deviceModel.getDeviceModelActions().values()) {
                if (!actionName.equals(act.getAlias())) continue;
                dma = act;
                break;
            }
        }
        if (dma == null) {
            throw new IllegalArgumentException(actionName + "not found in device model");
        }
        DeviceModelAction action = dma;
        List<DeviceModelAction.Argument> argumentList = action.getArguments();
        if (argumentList.isEmpty()) {
            throw new IllegalArgumentException(actionName + " does not accept argument(s)");
        }
        DeviceModelAttribute.Type argType = argumentList.get(0).getArgType();
        this.checkActionDataType(argType, actionName, data);
        String action_format = this.isDeviceApp() ? DEVICE_APP_ACTION_FORMAT : DEVICE_ACTION_FORMAT;
        String resource = String.format(action_format, this.getEnterpriseClient().getApplication().getId(), this.getEndpointId(), this.getDeviceModel().getURN(), action.getName());
        T value = argType != null ? data : null;
        boolean syncFailed = false;
        if (argType == DeviceModelAttribute.Type.URI) {
            syncFailed = !this.syncStorageObject(actionName, value);
        }
        String payload = VirtualDeviceImpl.getPayload(argType, "value", value);
        if (syncFailed) {
            this.processOnError((VirtualDevice)this, actionName, (Object)payload, "Content sync failed.");
            return;
        }
        Controller.update(this, "POST", resource, payload, new Controller.Callback(){

            @Override
            public void onError(VirtualDevice virtualDevice, String resource, String payload, String reason) {
                VirtualDeviceImpl.this.processOnError(virtualDevice, actionName, data, reason);
            }
        });
    }

    private boolean syncStorageObject(String name, Object value) {
        StorageObjectImpl storageObject = (StorageObjectImpl)value;
        storageObject.setSyncEventInfo(this, name);
        storageObject.sync();
        return storageObject.getSyncStatus() == StorageObject.SyncStatus.IN_SYNC;
    }

    @Override
    @Deprecated
    public void call(final String actionName) {
        DeviceModelImpl deviceModel = (DeviceModelImpl)this.getDeviceModel();
        Map<String, DeviceModelAction> actionMap = deviceModel.getDeviceModelActions();
        DeviceModelAction action = actionMap.get(actionName);
        if (action == null) {
            for (DeviceModelAction act : actionMap.values()) {
                if (!actionName.equals(act.getAlias())) continue;
                action = act;
                break;
            }
        }
        if (action == null) {
            throw new IllegalArgumentException(actionName + " not found in device model");
        }
        List<DeviceModelAction.Argument> argumentList = action.getArguments();
        if (!argumentList.isEmpty()) {
            throw new IllegalArgumentException(actionName + " requires argument(s)");
        }
        String action_format = this.isDeviceApp() ? DEVICE_APP_ACTION_FORMAT : DEVICE_ACTION_FORMAT;
        String resource = String.format(action_format, this.getEnterpriseClient().getApplication().getId(), this.getEndpointId(), this.getDeviceModel().getURN(), action.getName());
        Controller.update(this, "POST", resource, "{}", new Controller.Callback(){

            @Override
            public void onError(VirtualDevice virtualDevice, String resource, String payload, String reason) {
                VirtualDeviceImpl.this.processOnError(virtualDevice, actionName, null, reason);
            }
        });
    }

    @Override
    public Action createAction(String actionName) {
        return new ActionImpl(this, actionName);
    }

    public String toString() {
        return this.base.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDeviceApp() {
        if (this.isDeviceApp == null) {
            Object object = this.isDeviceAppLock;
            synchronized (object) {
                if (this.isDeviceApp == null) {
                    try {
                        JSONObject firstItem;
                        String request = RestApi.V2.getReqRoot() + "/apps/" + this.enterpriseClient.getApplication().getId() + "/deviceApps?fields=type&q=" + URLEncoder.encode("{\"id\":{\"$eq\":\"" + this.getEndpointId() + "\"}}", "UTF-8");
                        this.isDeviceApp = false;
                        JSONObject object2 = this.httpGet(this.secureConnection, request);
                        JSONArray items = object2.optJSONArray("items");
                        if (items != null && items.length() > 0 && (firstItem = items.optJSONObject(0)) != null) {
                            String type = firstItem.optString("type", "");
                            this.isDeviceApp = "DEVICE_APPLICATION".equals(type);
                        }
                    }
                    catch (IOException ignored) {
                    }
                    catch (GeneralSecurityException generalSecurityException) {
                        // empty catch block
                    }
                }
            }
        }
        if (this.isDeviceApp == null) {
            return false;
        }
        return this.isDeviceApp;
    }

    private JSONObject httpGet(HttpSecureConnection secureConnection, String request) throws IOException, GeneralSecurityException {
        HttpResponse res = secureConnection.get(request);
        int status = res.getStatus();
        if (status != StatusCode.OK.getCode()) {
            throw new IOException(res.getVerboseStatus("GET", request));
        }
        byte[] data = res.getData();
        if (data == null) {
            throw new IOException("GET " + request + " failed: no data received");
        }
        String json = new String(data, "UTF-8");
        try {
            return new JSONObject(json);
        }
        catch (JSONException e) {
            throw new IOException("GET " + request + ": " + e.getMessage());
        }
    }

    private static Logger getLogger() {
        return LOGGER;
    }

    private class DataEventImpl
    extends VirtualDevice.DataEvent {
        private final VirtualDevice device;
        private final String urn;
        private final AbstractVirtualDevice.NamedValue<?> value;
        private final Date eventTime;

        private DataEventImpl(VirtualDevice device, String urn, AbstractVirtualDevice.NamedValue<?> value, Date eventTime) {
            this.device = device;
            this.urn = urn;
            this.value = value;
            this.eventTime = eventTime;
        }

        @Override
        public VirtualDevice getVirtualDevice() {
            return this.device;
        }

        @Override
        public AbstractVirtualDevice.NamedValue<?> getNamedValue() {
            return this.value;
        }

        @Override
        public Date getEventTime() {
            return this.eventTime;
        }

        @Override
        public String getURN() {
            return this.urn;
        }
    }

    private class AlertEventImpl
    extends VirtualDevice.AlertEvent {
        private final VirtualDevice device;
        private final String urn;
        private final AbstractVirtualDevice.NamedValue<?> value;
        private final Date eventTime;

        private AlertEventImpl(VirtualDevice device, String urn, AbstractVirtualDevice.NamedValue<?> value, Date eventTime) {
            this.device = device;
            this.urn = urn;
            this.value = value;
            this.eventTime = eventTime;
        }

        @Override
        public VirtualDevice getVirtualDevice() {
            return this.device;
        }

        @Override
        public AbstractVirtualDevice.NamedValue<?> getNamedValue() {
            return this.value;
        }

        @Override
        public Date getEventTime() {
            return this.eventTime;
        }

        @Override
        public String getURN() {
            return this.urn;
        }
    }
}

