/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.impl.enterprise;

import com.oracle.iot.client.RestApi;
import com.oracle.iot.client.impl.enterprise.PageableEnumerator;
import com.oracle.iot.client.impl.http.HttpSecureConnection;
import com.oracle.iot.client.message.Message;
import com.oracle.iot.client.message.MessageParsingException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class MessageIterator
extends PageableEnumerator<Message> {
    private final String appID;
    private final HttpSecureConnection secureConnection;
    private final String deviceID;
    private final Message.Type type;
    private final boolean expand;
    private final long since;
    private final long until;
    private final boolean newestFirst;
    private PageableEnumerator.PagedResponse<Message> firstPage;
    private static final Logger LOGGER = Logger.getLogger("oracle.iot.client");

    public MessageIterator(String appID, int offset, int refillCount, String deviceID, Message.Type type, boolean expand, long since, long until, HttpSecureConnection secureConnection, boolean newestFirst) throws IOException, GeneralSecurityException {
        super(offset, refillCount);
        this.appID = appID;
        this.secureConnection = secureConnection;
        this.deviceID = deviceID;
        this.type = type;
        this.expand = expand;
        this.since = since;
        this.until = until;
        this.newestFirst = newestFirst;
        this.firstPage = this.load(offset, refillCount);
        this.size = this.getCount();
        this.hasMore = !this.firstPage.elements().isEmpty();
    }

    private int getCount() {
        try {
            MessageRequest req = new MessageRequest(this.appID, "count", this.offset, this.limit);
            JSONObject jsonObject = this.get(req.headers(), req.request());
            return jsonObject.optInt("count", -1);
        }
        catch (IOException ignored) {
        }
        catch (GeneralSecurityException generalSecurityException) {
            // empty catch block
        }
        return -1;
    }

    @Override
    protected HttpSecureConnection getSecureConnection() {
        return this.secureConnection;
    }

    @Override
    protected PageableEnumerator.PagedResponse<Message> load(int offset, int limit) throws IOException {
        String request;
        if (this.firstPage != null) {
            PageableEnumerator.PagedResponse<Message> page = this.firstPage;
            this.firstPage = null;
            if (offset == 0) {
                return page;
            }
        }
        HashMap<String, String> headers = new HashMap<String, String>(2);
        headers.put("Accept", "application/json");
        try {
            request = MessageIterator.createMessageRequest(this.appID, limit, offset, this.deviceID, this.type, this.expand, this.since, this.until, this.newestFirst);
        }
        catch (URISyntaxException e) {
            throw new IOException(e.getMessage());
        }
        try {
            JSONObject response = this.get(headers, request);
            return MessageResponse.fromJson(response, offset);
        }
        catch (JSONException e) {
            throw new IOException("GET " + request + ": " + e.getMessage());
        }
        catch (GeneralSecurityException e) {
            throw new IOException("GET " + request + ": " + e.getMessage());
        }
    }

    private static String createMessageRequest(String aid, int limit, int offset, String deviceID, Message.Type type, boolean expand, long since, long until, boolean newestFirst) throws URISyntaxException {
        String query = "expand=" + expand;
        if (deviceID != null) {
            query = query + "&device=" + deviceID;
        }
        if (type != null) {
            query = query + "&type=" + (Object)((Object)type);
        }
        if (limit > 0) {
            query = query + "&limit=" + limit;
        }
        if (offset > 0) {
            query = query + "&offset=" + offset;
        }
        if (since > 0L) {
            query = query + "&since=" + since;
        }
        if (until > 0L) {
            query = query + "&until=" + until;
        }
        query = query + "&orderBy=eventTime:" + (newestFirst ? "desc" : "asc");
        String request = aid == null ? RestApi.V2.getReqRoot() + "/messages" : RestApi.V2.getReqRoot() + "/apps/" + aid + "/messages";
        return new URI(null, null, request, query, null).toString();
    }

    private static Logger getLogger() {
        return LOGGER;
    }

    static class MessageRequest {
        private static final Map<String, String> headers = new HashMap<String, String>();
        private final String request;

        MessageRequest(String appId, String path, int offset, int limit) {
            String query = "totalResults=true";
            String req = appId == null ? RestApi.V2.getReqRoot() : RestApi.V2.getReqRoot() + "/apps/" + appId;
            req = req + "/messages";
            if (path != null) {
                req = req + "/" + path;
            }
            if (limit > 0) {
                query = query + "&limit=" + limit;
            }
            if (offset > 0) {
                query = query + "&offset=" + offset;
            }
            try {
                URI uri = new URI(null, null, req, query, null);
                this.request = uri.toString();
            }
            catch (URISyntaxException e) {
                MessageIterator.getLogger().log(Level.SEVERE, e.toString());
                throw new RuntimeException(e);
            }
        }

        String request() {
            return this.request;
        }

        Map<String, String> headers() {
            return headers;
        }

        public String toString() {
            return "MessageRequest: " + this.request();
        }

        static {
            headers.put("Content-Type", "application/json");
            headers.put("Accept", "application/json");
        }
    }

    static class MessageResponse
    extends PageableEnumerator.PagedResponse<Message> {
        private MessageResponse(Collection<Message> elements, int offset, int total, boolean hasMore) {
            super(elements, offset, total, hasMore, new HashMap<String, String>());
        }

        public static MessageResponse fromJson(Object response, int defaultOffset) throws JSONException {
            try {
                JSONObject jsonObject = (JSONObject)response;
                JSONArray items = jsonObject.getJSONArray("items");
                boolean hasMore = jsonObject.optBoolean("hasMore", false);
                int offset = jsonObject.optInt("offset", defaultOffset);
                int total = jsonObject.optInt("totalResults", -1);
                List<Message> list = Message.fromJson(items);
                return new MessageResponse(list, offset, total, hasMore);
            }
            catch (MessageParsingException mpe) {
                return new MessageResponse(Collections.emptyList(), 0, 0, false);
            }
            catch (ClassCastException e) {
                throw new JSONException("Incorrect response format");
            }
        }
    }
}

