/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.impl.enterprise;

import com.oracle.iot.client.HttpResponse;
import com.oracle.iot.client.RestApi;
import com.oracle.iot.client.impl.enterprise.VirtualDeviceImpl;
import com.oracle.iot.client.impl.http.HttpSecureConnection;
import com.oracle.iot.client.message.Message;
import com.oracle.iot.client.message.StatusCode;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.iot.client.enterprise.VirtualDevice;
import org.json.JSONException;
import org.json.JSONObject;

class Controller {
    private static final String CONTROLLER_POLLING_INTERVAL = "oracle.iot.client.enterprise.controller_polling_interval";
    private static final long pollingInterval = Long.getLong("oracle.iot.client.enterprise.controller_polling_interval", 1000L);
    private static final String CONTROLLER_RETRY_COUNT = "oracle.iot.client.enterprise.controller_retry_count";
    private static int controllerRetryCount = Integer.getInteger("oracle.iot.client.enterprise.controller_retry_count", 20);
    private static final Logger LOGGER = Logger.getLogger("oracle.iot.client");

    Controller() {
    }

    static void update(VirtualDeviceImpl virtualDevice, String method, String resource, String payload, Callback callback) {
        HttpResponse response;
        HttpSecureConnection connmgr;
        try {
            byte[] payloadBytes;
            connmgr = virtualDevice.getSecureConnection();
            String endptid = connmgr.getEndpointId();
            if (Controller.getLogger().isLoggable(Level.FINEST)) {
                StringBuilder builder = new StringBuilder();
                builder.append(method).append(' ').append(resource);
                if (payload != null) {
                    builder.append(' ').append(Message.prettyPrintJson(payload));
                }
                Controller.getLogger().log(Level.FINEST, builder.toString());
            }
            byte[] byArray = payloadBytes = payload != null ? payload.getBytes("UTF-8") : null;
            response = method.equals("GET") ? connmgr.get(resource) : (method.equals("POST") ? connmgr.post(resource, payloadBytes) : (method.equals("PUT") ? connmgr.put(resource, payloadBytes) : connmgr.patch(resource, payloadBytes)));
        }
        catch (Exception e) {
            Controller.getLogger().log(Level.FINEST, "ConnectionManager " + method + " failed. " + e.getMessage());
            if (callback != null) {
                callback.onError(virtualDevice, resource, payload, e.getMessage());
            }
            return;
        }
        if (callback != null) {
            try {
                StatusCode status = Controller.handleResponse(connmgr, response);
                if (status != StatusCode.ACCEPTED && status != StatusCode.OK) {
                    callback.onError(virtualDevice, resource, payload, status.getDescription());
                }
            }
            catch (IOException e) {
                callback.onError(virtualDevice, resource, payload, e.getMessage());
            }
            catch (GeneralSecurityException e) {
                callback.onError(virtualDevice, resource, payload, e.getMessage());
            }
        }
    }

    private static StatusCode handleResponse(HttpSecureConnection secureConnection, HttpResponse response) throws IOException, GeneralSecurityException {
        StatusCode httpstatus = StatusCode.valueOf(response.getStatus());
        if (controllerRetryCount <= 0) {
            controllerRetryCount = 20;
        }
        for (int retryCount = 0; retryCount < controllerRetryCount; ++retryCount) {
            URI uri;
            String reqStatus;
            if (httpstatus != StatusCode.ACCEPTED && httpstatus != StatusCode.OK) {
                return httpstatus;
            }
            JSONObject jsonData = null;
            try {
                byte[] data = response.getData();
                String json = new String(data, "UTF-8");
                jsonData = new JSONObject(json);
                reqStatus = jsonData.get("status").toString();
            }
            catch (JSONException e) {
                Controller.getLogger().log(Level.SEVERE, e.getMessage(), e);
                return StatusCode.INTERNAL_SERVER_ERROR;
            }
            if ("COMPLETED".equals(reqStatus) || "FAILED".equals(reqStatus)) {
                return Controller.getResponseStatusCode(jsonData);
            }
            String respReqHref = Controller.getLinksResponse(jsonData);
            if (respReqHref == null) {
                Controller.getLogger().log(Level.SEVERE, "Could not get request href");
                return StatusCode.INTERNAL_SERVER_ERROR;
            }
            try {
                uri = new URI(respReqHref);
            }
            catch (URISyntaxException e) {
                Controller.getLogger().log(Level.SEVERE, "Cannot decode links:requests:href " + respReqHref);
                return StatusCode.INTERNAL_SERVER_ERROR;
            }
            try {
                Thread.sleep(pollingInterval);
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
            }
            response = secureConnection.get(uri.getPath());
            httpstatus = StatusCode.valueOf(response.getStatus());
        }
        if (Controller.getLogger().isLoggable(Level.FINEST)) {
            Controller.getLogger().log(Level.FINEST, "oracle.iot.client.enterprise.controller_retry_count " + controllerRetryCount + " reached, returning " + StatusCode.REQUEST_TIMEOUT.toString());
        }
        return StatusCode.REQUEST_TIMEOUT;
    }

    private static String getLinksResponse(JSONObject jsonResponse) {
        String id = jsonResponse.optString("id", null);
        return id != null ? RestApi.V2.getReqRoot() + "/requests/".concat(id) : null;
    }

    private static StatusCode getResponseStatusCode(JSONObject jsonResponse) {
        StatusCode statusCode = StatusCode.INTERNAL_SERVER_ERROR;
        try {
            JSONObject asyncResponse = jsonResponse.optJSONObject("response");
            statusCode = StatusCode.valueOf(asyncResponse.getInt("statusCode"));
        }
        catch (IllegalArgumentException e) {
            Controller.getLogger().log(Level.SEVERE, e.getMessage(), e);
        }
        catch (NullPointerException e) {
            Controller.getLogger().log(Level.SEVERE, e.getMessage(), e);
        }
        catch (JSONException e) {
            Controller.getLogger().log(Level.SEVERE, e.getMessage(), e);
        }
        return statusCode;
    }

    private static Logger getLogger() {
        return LOGGER;
    }

    static interface Callback {
        public void onError(VirtualDevice var1, String var2, String var3, String var4);
    }
}

