/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.impl.enterprise;

import com.oracle.iot.client.DeviceModelAction;
import com.oracle.iot.client.impl.DeviceModelImpl;
import com.oracle.iot.client.impl.enterprise.Controller;
import com.oracle.iot.client.impl.enterprise.VirtualDeviceImpl;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.iot.client.DeviceModel;
import oracle.iot.client.ExternalObject;
import oracle.iot.client.enterprise.Action;
import oracle.iot.client.enterprise.VirtualDevice;
import org.json.JSONException;
import org.json.JSONObject;

public class ActionImpl
extends Action {
    private final VirtualDeviceImpl virtualDevice;
    private final DeviceModelAction deviceModelAction;
    private final Map<String, Object> argumentValues;
    private static final Logger LOGGER = Logger.getLogger("oracle.iot.client");

    ActionImpl(VirtualDeviceImpl virtualDevice, String actionName) {
        this.deviceModelAction = ActionImpl.getDeviceModelAction(virtualDevice, actionName);
        if (this.deviceModelAction == null) {
            throw new IllegalArgumentException("'" + actionName + "' not found");
        }
        this.virtualDevice = virtualDevice;
        this.argumentValues = new HashMap<String, Object>();
    }

    @Override
    public <T> Action set(String argumentName, T value) {
        DeviceModelAction.Argument argument = this.getArgument(argumentName);
        if (argument == null) {
            throw new IllegalArgumentException(argumentName + " not in model");
        }
        Object castValue = value;
        switch (argument.getArgType()) {
            case NUMBER: {
                if (!(value instanceof Number)) {
                    throw new IllegalArgumentException("value for '" + argumentName + "' is not a NUMBER");
                }
                this.checkBounds(argument, (Number)value);
                break;
            }
            case INTEGER: {
                if (!(value instanceof Integer)) {
                    throw new IllegalArgumentException("value for '" + argumentName + "' is not an INTEGER");
                }
                this.checkBounds(argument, (Number)value);
                break;
            }
            case DATETIME: {
                if (!(value instanceof Date) && !(value instanceof Long)) {
                    throw new IllegalArgumentException("value for '" + argumentName + "' is not a DATETIME");
                }
                if (!(value instanceof Date)) break;
                castValue = ((Date)value).getTime();
                break;
            }
            case BOOLEAN: {
                if (value instanceof Boolean) break;
                throw new IllegalArgumentException("value for '" + argumentName + "' is not a BOOLEAN");
            }
            case STRING: {
                if (value instanceof String) break;
                throw new IllegalArgumentException("value for '" + argumentName + "' is not a STRING");
            }
            case URI: {
                if (value instanceof ExternalObject) break;
                throw new IllegalArgumentException("value for '" + argumentName + "' is not an ExternalObject");
            }
        }
        this.argumentValues.put(argumentName, castValue);
        return this;
    }

    private void checkBounds(DeviceModelAction.Argument argument, Number value) throws IllegalArgumentException {
        double lower;
        double upper;
        Number upperBound = argument.getUpperBound();
        Number lowerBound = argument.getLowerBound();
        double val = value.doubleValue();
        if (upperBound != null && Double.compare(val, upper = upperBound.doubleValue()) > 0) {
            throw new IllegalArgumentException(this.deviceModelAction.getName() + " '" + argument.getName() + "' out of range: " + val + " > " + upper);
        }
        if (lowerBound != null && Double.compare(val, lower = lowerBound.doubleValue()) < 0) {
            throw new IllegalArgumentException(this.deviceModelAction.getName() + " '" + argument.getName() + "' out of range: " + val + " < " + lower);
        }
    }

    @Override
    public void call() {
        final String actionName = this.deviceModelAction.getName();
        String action_format = this.virtualDevice.isDeviceApp() ? VirtualDeviceImpl.DEVICE_APP_ACTION_FORMAT : VirtualDeviceImpl.DEVICE_ACTION_FORMAT;
        String resource = String.format(action_format, this.virtualDevice.getEnterpriseClient().getApplication().getId(), this.virtualDevice.getEndpointId(), this.virtualDevice.getDeviceModel().getURN(), actionName);
        String payload = this.getPayload();
        Controller.update(this.virtualDevice, "POST", resource, payload, new Controller.Callback(){

            @Override
            public void onError(VirtualDevice virtualDevice, String resource, String payload, String reason) {
                ((VirtualDeviceImpl)virtualDevice).processOnError(virtualDevice, actionName, (Object)payload, reason);
            }
        });
    }

    private DeviceModelAction.Argument getArgument(String fieldName) {
        if (this.deviceModelAction == null) {
            return null;
        }
        List<DeviceModelAction.Argument> argumentList = this.deviceModelAction.getArguments();
        for (DeviceModelAction.Argument argument : argumentList) {
            if (!argument.getName().equals(fieldName)) continue;
            return argument;
        }
        return null;
    }

    private static DeviceModelAction getDeviceModelAction(VirtualDevice virtualDevice, String actionName) {
        DeviceModel dm = virtualDevice.getDeviceModel();
        if (!(dm instanceof DeviceModelImpl)) {
            return null;
        }
        DeviceModelImpl deviceModel = (DeviceModelImpl)dm;
        return deviceModel.getDeviceModelActions().get(actionName);
    }

    private String getPayload() {
        String payload = "{}";
        try {
            JSONObject jsonObject = new JSONObject();
            List<DeviceModelAction.Argument> argumentList = this.deviceModelAction.getArguments();
            for (DeviceModelAction.Argument argument : argumentList) {
                Object value = this.argumentValues.get(argument.getName());
                if (value == null && (value = argument.getDefaultValue()) == null) {
                    throw new IllegalStateException("missing required argument '" + argument.getName() + "' to action '" + this.deviceModelAction.getName() + "'");
                }
                jsonObject.put(argument.getName(), value);
            }
            payload = jsonObject.toString();
        }
        catch (JSONException e) {
            ActionImpl.getLogger().log(Level.WARNING, e.toString());
        }
        return payload;
    }

    private static Logger getLogger() {
        return LOGGER;
    }
}

