/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.impl;

import com.oracle.iot.client.StorageObject;
import com.oracle.iot.client.impl.StorageConnection;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;

public class StorageObjectDelegate
extends StorageObject {
    private final StorageConnection storageConnection;
    protected long transferredBytes;

    protected StorageObjectDelegate(StorageConnection storageConnection, String uri, String name, String contentType, String contentEncoding, String dateOfLastModification, long length) {
        super(uri, name, contentType, contentEncoding, dateOfLastModification, length);
        this.storageConnection = storageConnection;
        this.transferredBytes = 0L;
    }

    @Override
    protected final void setAttributes(String date, long length) {
        super.setAttributes(date, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void sync() throws IOException, GeneralSecurityException {
        try {
            this.storageConnection.sync(this);
        }
        finally {
            InputStream inputStream = this.getInputStream();
            OutputStream outputStream = this.getOutputStream();
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException ignored) {}
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public boolean isCancelled() {
        return false;
    }

    public void setTransferredBytes(long transferredBytes) {
        this.transferredBytes = transferredBytes;
    }
}

