/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.impl;

import com.oracle.iot.client.HttpResponse;
import com.oracle.iot.client.RestApi;
import com.oracle.iot.client.SecureConnection;
import com.oracle.iot.client.StorageObject;
import com.oracle.iot.client.TransportException;
import com.oracle.iot.client.impl.StorageAuthenticationResponse;
import com.oracle.iot.client.impl.StorageConnection;
import com.oracle.iot.client.impl.StorageObjectDelegate;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class StorageConnectionBase
implements StorageConnection {
    private static final String STORAGE_CLOUD_HOST;
    private static final String DEFAULT_STORAGE_CLOUD_HOST = "storage.oraclecloud.com";
    private static final boolean virtualStorageDirectories;
    private static final String REST_STORAGE_AUTHENTICATION;
    private static final String AUTH_TOKEN_HEADER = "X-Auth-Token";
    private static final int DEFAULT_RETRY_LIMIT = 2;
    private static final int ERR_BAD_CHECKSUM = -1;
    private static final int ERR_UPLOAD_CANCELLED = -2;
    private static final int ERR_WRITING_REQUEST_BODY_TO_SERVER = -3;
    private static final int RETRY_LIMIT;
    private static final int DEFAULT_CHUNK_SIZE = 4096;
    private static final String CHUNK_SIZE_PROPERTY = "com.oracle.iot.client.storage_connection_chunk_size";
    private static final int CHUNK_SIZE;
    private final SecureConnection secureConnection;
    private String storageContainerUrl = null;
    private String authToken = null;
    private boolean closed;
    private static final Logger LOGGER;

    protected StorageConnectionBase(SecureConnection secureConnection) {
        this.secureConnection = secureConnection;
        this.closed = false;
    }

    @Override
    public final void sync(StorageObject storageObject) throws IOException, GeneralSecurityException {
        if (storageObject.getInputStream() != null) {
            this.upload(storageObject);
        } else if (storageObject.getOutputStream() != null) {
            this.download(storageObject);
        } else {
            throw new IllegalArgumentException("InputStream and OutputStream are not set.");
        }
    }

    private void upload(StorageObject storageObject) throws IOException {
        int responseCode = this.transfer(storageObject);
        if (responseCode != 201) {
            throw new TransportException(responseCode, "Upload " + storageObject.getURI());
        }
    }

    private void download(StorageObject storageObject) throws IOException {
        int responseCode = this.transfer(storageObject);
        if (responseCode != 200 && responseCode != 206) {
            throw new TransportException(responseCode, "Download " + storageObject.getURI());
        }
    }

    public final StorageObject createStorageObject(String clientId, String name, String contentType) throws IOException, GeneralSecurityException {
        String path = virtualStorageDirectories && clientId != null ? clientId + "/" + name : name;
        String contentStorageLocation = this.getStorageContainerUrl() + "/" + path;
        StorageObject storageObject = this.createStorageObject(contentStorageLocation, name, contentType, null, null, -1);
        return storageObject;
    }

    public final StorageObject createStorageObject(String storageUrl) throws IOException, GeneralSecurityException {
        String name;
        URL url;
        try {
            url = new URL(storageUrl);
            String fullContainerUrl = this.getStorageContainerUrl() + "/";
            if (!storageUrl.startsWith(fullContainerUrl)) {
                throw new GeneralSecurityException("Storage container URL does not match.");
            }
            name = virtualStorageDirectories ? storageUrl.substring(storageUrl.lastIndexOf(47) + 1) : storageUrl.substring(fullContainerUrl.length());
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException("Storage Cloud URL is invalid", ex);
        }
        for (int i = 0; i < RETRY_LIMIT; ++i) {
            if (this.authToken == null) {
                this.authToken = this.authenticate();
            }
            if (this.authToken == null) continue;
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("HEAD");
            connection.setRequestProperty(AUTH_TOKEN_HEADER, this.authToken);
            connection.connect();
            int length = connection.getContentLength();
            String type = connection.getContentType();
            String encoding = connection.getContentEncoding();
            String date = connection.getHeaderField("Last-Modified");
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                return this.createStorageObject(storageUrl, name, type, encoding, date, length);
            }
            if (responseCode != 401) {
                throw new TransportException(responseCode, "HEAD " + storageUrl);
            }
            this.authToken = null;
        }
        throw new TransportException(401, "HEAD " + storageUrl);
    }

    protected abstract StorageObject createStorageObject(String var1, String var2, String var3, String var4, String var5, int var6);

    public static boolean isStorageCloudURI(String uri) {
        try {
            if (new URI(uri).getHost().contains(STORAGE_CLOUD_HOST)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public final synchronized void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
        }
    }

    private String getStorageContainerUrl() throws IOException, GeneralSecurityException {
        if (this.storageContainerUrl == null) {
            StorageAuthenticationResponse storageAuthenticationResponse = this.getStorageAuthentication();
            this.storageContainerUrl = storageAuthenticationResponse.getStorageContainerUrl();
            this.authToken = storageAuthenticationResponse.getAuthToken();
        }
        return this.storageContainerUrl;
    }

    private int transfer(StorageObject storageObject) throws IOException {
        boolean upload;
        InputStream inputStream = storageObject.getInputStream();
        boolean bl = upload = inputStream != null;
        if (upload && inputStream.markSupported()) {
            inputStream.mark(Integer.MAX_VALUE);
        }
        String scPath = storageObject.getURI() == null ? this.storageContainerUrl + "/" + storageObject.getName() : storageObject.getURI();
        block6: for (int retries = 0; retries < RETRY_LIMIT; ++retries) {
            if (retries > 0 && upload) {
                if (inputStream.markSupported()) {
                    inputStream.reset();
                } else if (inputStream instanceof FileInputStream) {
                    FileInputStream fs = (FileInputStream)inputStream;
                    FileChannel fc = fs.getChannel();
                    fc.position(0L);
                } else {
                    StorageConnectionBase.getLogger().log(Level.SEVERE, "Cannot reset input stream for retry");
                    return 500;
                }
            }
            if (this.authToken == null) {
                this.authToken = this.authenticate();
            }
            if (this.authToken == null) {
                return 401;
            }
            int responseCode = this.transferContent(scPath, storageObject);
            switch (responseCode) {
                case 200: 
                case 201: 
                case 206: {
                    return responseCode;
                }
                case -2: {
                    StorageConnectionBase.getLogger().log(Level.INFO, (upload ? "Upload" : "Download") + " cancelled " + storageObject.getURI());
                    return upload ? 201 : 200;
                }
                case 401: {
                    this.authToken = null;
                    continue block6;
                }
                case -3: 
                case -1: {
                    continue block6;
                }
                default: {
                    return responseCode;
                }
            }
        }
        StorageConnectionBase.getLogger().log(Level.INFO, "Retries exceeded " + (upload ? "uploading" : "downloading") + " " + storageObject.getURI());
        return 500;
    }

    private int transferContent(String scPath, StorageObject storageObject) throws IOException {
        String digestOut;
        assert (this.authToken != null);
        if (this.authToken == null) {
            return 401;
        }
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException ex) {
            StorageConnectionBase.getLogger().log(Level.WARNING, "Storage Cloud Service: checksum could not be verified.", ex);
        }
        String contentType = storageObject.getType();
        String encoding = storageObject.getEncoding();
        InputStream inputStream = storageObject.getInputStream();
        OutputStream outputStream = storageObject.getOutputStream();
        boolean upload = inputStream != null;
        URL url = new URL(scPath);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        if (upload) {
            connection.setRequestMethod("PUT");
            connection.setChunkedStreamingMode(CHUNK_SIZE);
            connection.setRequestProperty("Content-Type", contentType != null ? contentType : "application/octet-stream");
            if (encoding != null) {
                connection.setRequestProperty("Content-Encoding", encoding);
            }
            connection.setDoOutput(true);
            Map<String, String> metadata = storageObject.getCustomMetadata();
            for (Map.Entry<String, String> entry : metadata.entrySet()) {
                String k = entry.getKey();
                String v = entry.getValue();
                connection.setRequestProperty("X-Object-Meta-" + k, v);
            }
        } else {
            connection.setRequestMethod("GET");
            connection.setDoOutput(false);
        }
        connection.setRequestProperty(AUTH_TOKEN_HEADER, this.authToken);
        connection.connect();
        long transferredBytes = 0L;
        OutputStream os = upload ? connection.getOutputStream() : outputStream;
        InputStream is = upload ? inputStream : connection.getInputStream();
        byte[] b = new byte[CHUNK_SIZE];
        try {
            while (true) {
                int len;
                if ((len = is.read(b)) != -1) {
                    if (((StorageObjectDelegate)storageObject).isCancelled()) {
                        int n = -2;
                        return n;
                    }
                    os.write(b, 0, len);
                    if (digest != null) {
                        digest.update(b, 0, len);
                    }
                    ((StorageObjectDelegate)storageObject).setTransferredBytes(transferredBytes += (long)len);
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            if ("Error writing request body to server".equalsIgnoreCase(e.getMessage())) {
                StorageConnectionBase.getLogger().log(Level.SEVERE, e.toString());
                connection.disconnect();
                int n = -3;
                return n;
            }
            throw e;
        }
        finally {
            if (upload) {
                try {
                    os.close();
                }
                catch (IOException ignored) {}
            } else {
                try {
                    is.close();
                }
                catch (IOException ignored) {}
            }
        }
        int responseCode = connection.getResponseCode();
        String checksum = connection.getHeaderField("ETag");
        String date = connection.getHeaderField("Last-Modified");
        if (checksum != null && digest != null && !checksum.equals(digestOut = StorageConnectionBase.bytesToHexString(digest.digest()))) {
            StorageConnectionBase.getLogger().log(Level.INFO, "Storage Cloud Service: checksum mismatch");
            return -1;
        }
        if (upload && responseCode == 201) {
            ((StorageObjectDelegate)storageObject).setAttributes(date, transferredBytes);
        } else if (!(upload || responseCode != 200 && responseCode != 206)) {
            Map<String, List<String>> headers = connection.getHeaderFields();
            Set<Map.Entry<String, List<String>>> entrySet = headers.entrySet();
            for (Map.Entry<String, List<String>> entry : entrySet) {
                try {
                    String key = entry.getKey();
                    List<String> values = entry.getValue();
                    if (key == null || values == null || values.size() == 0 || !key.startsWith("X-Object-Meta-")) continue;
                    storageObject.setCustomMetadata(key.substring("X-Object-Meta-".length()), values.get(0));
                }
                catch (IllegalArgumentException | NullPointerException ex) {}
            }
        }
        return responseCode;
    }

    private StorageAuthenticationResponse getStorageAuthentication() throws IOException, GeneralSecurityException {
        JSONObject json;
        HttpResponse response = this.secureConnection.get(REST_STORAGE_AUTHENTICATION);
        int status = response.getStatus();
        if (status != 200) {
            throw new TransportException(status, response.getVerboseStatus("GET", REST_STORAGE_AUTHENTICATION));
        }
        String jsonResponse = new String(response.getData(), "UTF-8");
        try {
            json = new JSONObject(jsonResponse);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        StorageAuthenticationResponse storageAuthenticationResponse = StorageAuthenticationResponse.fromJson(json);
        if (StorageConnectionBase.getLogger().isLoggable(Level.FINER)) {
            StorageConnectionBase.getLogger().log(Level.FINER, storageAuthenticationResponse.toString());
        }
        return storageAuthenticationResponse;
    }

    private String authenticate() {
        try {
            StorageAuthenticationResponse storageAuthenticationResponse = this.getStorageAuthentication();
            this.storageContainerUrl = storageAuthenticationResponse.getStorageContainerUrl();
            return storageAuthenticationResponse.getAuthToken();
        }
        catch (Exception e) {
            StorageConnectionBase.getLogger().log(Level.INFO, "IoT storage API cannot be accessed: " + e.getMessage());
            return null;
        }
    }

    private static String bytesToHexString(byte[] in) {
        StringBuilder sb = new StringBuilder();
        for (byte b : in) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    private static Logger getLogger() {
        return LOGGER;
    }

    static {
        REST_STORAGE_AUTHENTICATION = RestApi.V2.getReqRoot() + "/provisioner/storage";
        CHUNK_SIZE = Integer.getInteger(CHUNK_SIZE_PROPERTY, 4096);
        Integer val = Integer.getInteger("com.oracle.iot.client.storage_connection_retry_limit");
        RETRY_LIMIT = val != null && val > 0 ? val : 2;
        STORAGE_CLOUD_HOST = System.getProperty("com.oracle.iot.client.storage_connection_host_name", DEFAULT_STORAGE_CLOUD_HOST);
        String value = System.getProperty("oracle.iot.client.disable_storage_object_prefix");
        virtualStorageDirectories = value == null || "".equals(value) || !Boolean.parseBoolean(value);
        LOGGER = Logger.getLogger("oracle.iot.client.StorageConnection");
    }
}

