/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.impl;

import com.oracle.iot.client.DeviceModelAction;
import com.oracle.iot.client.DeviceModelAttribute;
import com.oracle.iot.client.DeviceModelFormat;
import com.oracle.iot.client.impl.DeviceModelActionImpl;
import com.oracle.iot.client.impl.DeviceModelAttributeImpl;
import com.oracle.iot.client.impl.DeviceModelFormatImpl;
import com.oracle.iot.client.impl.DeviceModelImpl;
import java.io.IOException;
import java.io.Reader;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import oracle.iot.client.DeviceModel;
import oracle.iot.client.ExternalObject;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DeviceModelParser {
    public static DeviceModel fromJson(String jsonModel) throws JSONException {
        return DeviceModelParser.fromJson(new JSONObject(jsonModel));
    }

    public static DeviceModel fromJson(Reader reader) throws JSONException {
        StringBuilder sb = new StringBuilder();
        try {
            int c;
            while ((c = reader.read()) != -1) {
                sb.append((char)c);
            }
        }
        catch (IOException e) {
            throw new JSONException(e.getMessage());
        }
        return DeviceModelParser.fromJson(sb.toString());
    }

    public static DeviceModel fromJson(JSONObject root) throws JSONException {
        String urn = root.optString("urn", null);
        if (urn == null || urn.length() == 0) {
            throw new JSONException("urn cannot be null or empty");
        }
        String name = root.optString("name", null);
        if (name == null || name.length() == 0) {
            throw new JSONException("name cannot be null or empty");
        }
        String description = root.optString("description", null);
        ArrayList<DeviceModelAttributeImpl> attributes = new ArrayList<DeviceModelAttributeImpl>();
        ArrayList<String> existingAttrNames = new ArrayList<String>();
        JSONArray jsonAtts = root.optJSONArray("attributes");
        if (jsonAtts != null) {
            int size = jsonAtts.length();
            for (int i = 0; i < size; ++i) {
                DeviceModelAttributeImpl attribute = DeviceModelParser.createDeviceModelAttribute(urn, existingAttrNames, jsonAtts.getJSONObject(i));
                attributes.add(attribute);
                existingAttrNames.add(((DeviceModelAttribute)attribute).getName());
            }
        }
        ArrayList<DeviceModelAction> actions = new ArrayList<DeviceModelAction>();
        ArrayList<String> existingActionsNames = new ArrayList<String>();
        JSONArray jsonActions = root.optJSONArray("actions");
        if (jsonActions != null) {
            int size = jsonActions.length();
            for (int i = 0; i < size; ++i) {
                DeviceModelAction action = DeviceModelParser.createDeviceModelAction(existingActionsNames, jsonActions.getJSONObject(i));
                actions.add(action);
                existingActionsNames.add(action.getName());
            }
        }
        ArrayList<DeviceModelFormat> formats = new ArrayList<DeviceModelFormat>();
        JSONArray jsonFormats = root.optJSONArray("formats");
        if (jsonFormats != null) {
            int size = jsonFormats.length();
            for (int i = 0; i < size; ++i) {
                DeviceModelFormat format = DeviceModelParser.createDeviceModelFormat(jsonFormats.getJSONObject(i));
                formats.add(format);
            }
        }
        return new DeviceModelImpl(urn, name, description, attributes.toArray(new DeviceModelAttribute[0]), actions.toArray(new DeviceModelAction[0]), formats.toArray(new DeviceModelFormat[0]));
    }

    private static DeviceModelAttributeImpl createDeviceModelAttribute(String urn, List<String> existingFieldNames, JSONObject root) throws JSONException {
        String name = root.getString("name");
        if (existingFieldNames.contains(name)) {
            throw new JSONException("duplicate attribute: " + name);
        }
        String description = root.optString("description", null);
        String alias = root.optString("alias", null);
        String range = root.optString("range", null);
        DeviceModelAttribute.Access access = root.optBoolean("writable", false) ? DeviceModelAttribute.Access.READ_WRITE : DeviceModelAttribute.Access.READ_ONLY;
        DeviceModelAttribute.Type type = null;
        try {
            String t = root.optString("type", null);
            if (t != null) {
                type = DeviceModelAttribute.Type.valueOf(t);
            }
        }
        catch (IllegalArgumentException e) {
            throw new JSONException("Illegal type: " + root.optString("type", ""));
        }
        Number min = null;
        Number max = null;
        try {
            if (range != null) {
                NumberFormat nf = NumberFormat.getNumberInstance(Locale.ROOT);
                String[] strings = range.split(",");
                min = nf.parse(strings[0]);
                max = nf.parse(strings[1]);
            }
        }
        catch (Exception e) {
            throw new JSONException("Invalid range: " + range);
        }
        Object defaultValue = root.opt("defaultValue");
        if (defaultValue != null) {
            if (type == DeviceModelAttribute.Type.INTEGER && defaultValue instanceof Number) {
                defaultValue = ((Number)defaultValue).intValue();
            } else if (!(type == DeviceModelAttribute.Type.NUMBER && defaultValue instanceof Number || type == DeviceModelAttribute.Type.STRING && defaultValue instanceof String || type == DeviceModelAttribute.Type.BOOLEAN && defaultValue instanceof Boolean)) {
                if (type == DeviceModelAttribute.Type.DATETIME && defaultValue instanceof Number) {
                    defaultValue = new Date(((Number)defaultValue).longValue());
                } else if (type == DeviceModelAttribute.Type.URI && defaultValue instanceof String) {
                    defaultValue = new ExternalObject((String)defaultValue);
                } else {
                    throw new JSONException("Invalid defaultValue: " + defaultValue);
                }
            }
        }
        return new DeviceModelAttributeImpl<Object>(urn, name, description, type, min, max, access, alias, defaultValue);
    }

    private static DeviceModelAction createDeviceModelAction(List<String> existingActionNames, JSONObject root) throws JSONException {
        String name = root.getString("name");
        if (existingActionNames.contains(name)) {
            throw new JSONException("duplicate action:" + name);
        }
        String description = root.optString("description", null);
        String alias = root.optString("alias", null);
        DeviceModelAttribute.Type type = null;
        ArrayList<DeviceModelAction.Argument> argumentList = new ArrayList<DeviceModelAction.Argument>();
        if (root.has("arguments")) {
            JSONArray jsonArray = root.getJSONArray("arguments");
            int iMax = jsonArray.length();
            for (int i = 0; i < iMax; ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                DeviceModelAction.Argument argument = DeviceModelActionImpl.ArgumentImpl.fromJSON(jsonObject);
                argumentList.add(argument);
            }
        } else if (root.has("argType")) {
            String argType = root.optString("argType", null);
            if (argType != null) {
                try {
                    type = DeviceModelAttribute.Type.valueOf(argType);
                }
                catch (IllegalArgumentException e) {
                    throw new JSONException("Invalid action type: " + root.optString("argType", ""));
                }
            }
            DeviceModelActionImpl.ArgumentImpl argument = new DeviceModelActionImpl.ArgumentImpl("value", type, null, null, null);
            argumentList.add(argument);
        }
        return new DeviceModelActionImpl(name, description, argumentList, alias);
    }

    private static DeviceModelFormat createDeviceModelFormat(JSONObject root) throws JSONException {
        String urn = root.getString("urn");
        String name = root.getString("name");
        String description = root.optString("description", "");
        String type = root.getString("type");
        ArrayList<DeviceModelFormat.Field> fields = new ArrayList<DeviceModelFormat.Field>();
        JSONObject value = root.getJSONObject("value");
        JSONArray jsonFields = value.getJSONArray("fields");
        int size = jsonFields.length();
        for (int i = 0; i < size; ++i) {
            DeviceModelFormat.Field field = DeviceModelParser.createMsgFormatField(jsonFields.getJSONObject(i));
            fields.add(field);
        }
        return new DeviceModelFormatImpl(urn, name, description, type, fields);
    }

    private static DeviceModelFormat.Field createMsgFormatField(JSONObject root) throws JSONException {
        String name = root.getString("name");
        String description = root.optString("description", "");
        String type = root.getString("type");
        boolean optional = root.getBoolean("optional");
        return new DeviceModelFormatImpl.FieldImpl(name, description, type, optional);
    }
}

