/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.impl;

import com.oracle.iot.client.DeviceModelAction;
import com.oracle.iot.client.DeviceModelAttribute;
import com.oracle.iot.client.DeviceModelFormat;
import java.util.HashMap;
import java.util.Map;
import oracle.iot.client.DeviceModel;

public class DeviceModelImpl
extends DeviceModel {
    private final String urn;
    private final String name;
    private final String description;
    private final Map<String, DeviceModelAttribute> deviceModelAttributes = new HashMap<String, DeviceModelAttribute>();
    private final Map<String, DeviceModelAction> deviceModelActions = new HashMap<String, DeviceModelAction>();
    private final Map<String, DeviceModelFormat> deviceModelFormats = new HashMap<String, DeviceModelFormat>();

    public DeviceModelImpl(String urn, String name, String description, DeviceModelAttribute[] deviceModelAttributes, DeviceModelAction[] deviceModelActions) {
        this(urn, name, description, deviceModelAttributes, deviceModelActions, null);
    }

    public DeviceModelImpl(String urn, String name, String description, DeviceModelAttribute[] deviceModelAttributes, DeviceModelAction[] deviceModelActions, DeviceModelFormat[] deviceModelFormats) {
        int i;
        this.urn = urn;
        this.name = name;
        this.description = description;
        if (deviceModelAttributes != null) {
            for (i = 0; i < deviceModelAttributes.length; ++i) {
                String attName = deviceModelAttributes[i].getName();
                if (this.deviceModelAttributes.get(attName) != null) continue;
                this.deviceModelAttributes.put(attName, deviceModelAttributes[i]);
            }
        }
        if (deviceModelActions != null) {
            for (i = 0; i < deviceModelActions.length; ++i) {
                String actName = deviceModelActions[i].getName();
                if (this.deviceModelActions.get(actName) != null) continue;
                this.deviceModelActions.put(actName, deviceModelActions[i]);
            }
        }
        if (deviceModelFormats != null) {
            for (i = 0; i < deviceModelFormats.length; ++i) {
                String formatUrn = deviceModelFormats[i].getURN();
                if (this.deviceModelFormats.get(formatUrn) != null) continue;
                this.deviceModelFormats.put(formatUrn, deviceModelFormats[i]);
            }
        }
    }

    @Override
    public String getURN() {
        return this.urn;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public Map<String, DeviceModelAttribute> getDeviceModelAttributes() {
        return this.deviceModelAttributes;
    }

    public Map<String, DeviceModelAction> getDeviceModelActions() {
        return this.deviceModelActions;
    }

    public Map<String, DeviceModelFormat> getDeviceModelFormats() {
        return this.deviceModelFormats;
    }

    public String toString() {
        boolean firstItem = true;
        StringBuilder b = new StringBuilder("urn = ");
        b.append("\t");
        b.append(this.urn);
        b.append(",\n\tname = ");
        b.append(this.name);
        b.append(",\n\tdescription = ");
        b.append(this.description);
        b.append(",\n\tattributes = [");
        for (DeviceModelAttribute attribute : this.deviceModelAttributes.values()) {
            if (!firstItem) {
                b.append(",");
            } else {
                firstItem = false;
            }
            b.append("\n\t{");
            b.append(attribute);
            b.append("}");
        }
        if (!firstItem) {
            b.append("\n\t");
        }
        b.append("],\n\tactions = [");
        firstItem = true;
        for (DeviceModelAction action : this.deviceModelActions.values()) {
            if (!firstItem) {
                b.append(",");
            } else {
                firstItem = false;
            }
            b.append("\n\t{");
            b.append(action);
            b.append("}");
        }
        if (!firstItem) {
            b.append("\n\t");
        }
        b.append("],\n\tformats = [");
        firstItem = true;
        for (DeviceModelFormat format : this.deviceModelFormats.values()) {
            if (!firstItem) {
                b.append(",");
            } else {
                firstItem = false;
            }
            b.append("\n\t{");
            b.append(format);
            b.append("}");
        }
        if (!firstItem) {
            b.append("\n\t");
        }
        b.append("]");
        return b.toString();
    }
}

