/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.impl;

import com.oracle.iot.client.DeviceModelAttribute;

class DeviceModelAttributeImpl<T>
extends DeviceModelAttribute<T> {
    private final String name;
    private final String urn;
    private final String description;
    private final DeviceModelAttribute.Type type;
    private final Number lowerBound;
    private final Number upperBound;
    private final DeviceModelAttribute.Access access;
    private final String alias;
    private final T defaultValue;

    DeviceModelAttributeImpl(String urn, String name, String description, DeviceModelAttribute.Type type, Number lowerBound, Number upperBound, DeviceModelAttribute.Access access, String alias) {
        this(urn, name, description, type, lowerBound, upperBound, access, alias, null);
    }

    DeviceModelAttributeImpl(String urn, String name, String description, DeviceModelAttribute.Type type, Number lowerBound, Number upperBound, DeviceModelAttribute.Access access, String alias, T defaultValue) {
        this.urn = urn;
        this.name = name;
        this.description = description;
        this.type = type;
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.access = access;
        this.alias = alias;
        this.defaultValue = defaultValue;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getModel() {
        return this.urn;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public DeviceModelAttribute.Type getType() {
        return this.type;
    }

    @Override
    public Number getLowerBound() {
        return this.lowerBound;
    }

    @Override
    public Number getUpperBound() {
        return this.upperBound;
    }

    @Override
    public DeviceModelAttribute.Access getAccess() {
        return this.access;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public T getDefaultValue() {
        return this.defaultValue;
    }

    public String toString() {
        return "urn = " + this.urn + ", name = " + this.name + ", description = " + this.description + ", type = " + (Object)((Object)this.type) + ", lowerBound = " + this.lowerBound + ", upperBound = " + this.upperBound + ", access = " + (Object)((Object)this.access) + ", alias = " + this.alias + ", defaultValue = " + this.defaultValue;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DeviceModelAttribute)) {
            return false;
        }
        DeviceModelAttribute other = (DeviceModelAttribute)obj;
        if (this.getModel() != null ? !this.getModel().equals(other.getModel()) : other.getModel() != null) {
            return false;
        }
        return this.getName() != null ? this.getName().equals(other.getName()) : other.getName() == null;
    }

    public int hashCode() {
        int hash = 37;
        hash = 37 * hash + (this.getModel() != null ? this.getModel().hashCode() : 0);
        hash = 37 * hash + (this.getName() != null ? this.getName().hashCode() : 0);
        return hash;
    }
}

