/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.enterprise;

import com.oracle.iot.client.RestApi;
import com.oracle.iot.client.enterprise.Resource;
import com.oracle.iot.client.impl.enterprise.PageableEnumerator;
import com.oracle.iot.client.impl.enterprise.ResourceImpl;
import com.oracle.iot.client.impl.enterprise.SecureHttpConnectionMap;
import com.oracle.iot.client.impl.http.HttpSecureConnection;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.iot.client.enterprise.EnterpriseClient;
import oracle.iot.client.enterprise.Pageable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ResourceEnumerator {
    private final String deviceId;
    private final HttpSecureConnection secureConnection;
    private final String appId;

    public ResourceEnumerator(EnterpriseClient client, String deviceId) {
        if (client == null) {
            throw new NullPointerException("client parameter");
        }
        if (deviceId == null) {
            throw new NullPointerException("deviceId parameter");
        }
        this.deviceId = deviceId;
        this.secureConnection = SecureHttpConnectionMap.getSecureHttpConnection(client);
        this.appId = client.getApplication().getId();
    }

    public Pageable<Resource> getResources() throws IOException, GeneralSecurityException {
        return new ResourcePageable(this.appId, this.deviceId, this.secureConnection);
    }

    static class ResourceResponse
    extends PageableEnumerator.PagedResponse<Resource> {
        ResourceResponse(List<Resource> resources, int offset, int total, boolean hasMore, Map<String, String> links) {
            super(resources, offset, total, hasMore, links);
        }

        static ResourceResponse fromJson(JSONObject jsonObject, String appId, HttpSecureConnection secureConnection) throws JSONException {
            JSONArray items = jsonObject.optJSONArray("items");
            JSONArray links = jsonObject.optJSONArray("links");
            boolean hasMore = jsonObject.optBoolean("hasMore", false);
            int offset = jsonObject.optInt("offset", -1);
            int total = jsonObject.optInt("totalResults", -1);
            ArrayList<Resource> resources = new ArrayList<Resource>();
            int size = items.length();
            for (int i = 0; i < size; ++i) {
                Object r = items.opt(i);
                resources.add(ResourceResponse.createResource((JSONObject)r, appId, secureConnection));
            }
            HashMap<String, String> map = new HashMap<String, String>();
            if (links != null) {
                int size2 = links.length();
                for (int i = 0; i < size2; ++i) {
                    JSONObject object = (JSONObject)links.opt(i);
                    String rel = object.optString("rel", null);
                    String href = object.optString("href", null);
                    if (rel == null || href == null) continue;
                    map.put(rel, href);
                }
            }
            return new ResourceResponse((List<Resource>)resources, offset, total, hasMore, (Map<String, String>)map);
        }

        private static Resource createResource(JSONObject resource, String appId, HttpSecureConnection secureConnection) throws JSONException {
            String endpointId = resource.getString("endpointId");
            String id = resource.getString("id");
            String description = resource.optString("description", "");
            String url = resource.getString("url");
            ArrayList<String> mList = new ArrayList<String>();
            JSONArray methods = resource.getJSONArray("methods");
            int size = methods.length();
            for (int i = 0; i < size; ++i) {
                String method = methods.getString(i);
                mList.add(method);
            }
            return new ResourceImpl(secureConnection, appId, endpointId, id, description, url, mList);
        }
    }

    static class ResourcePageable
    extends PageableEnumerator<Resource> {
        private final String appId;
        private final String deviceId;
        private final HttpSecureConnection secureConnection;
        private PageableEnumerator.PagedResponse<Resource> firstPage;

        private ResourcePageable(String appId, String deviceId, HttpSecureConnection secureConnection) throws IOException, GeneralSecurityException {
            super(0, 200);
            this.appId = appId;
            this.deviceId = deviceId;
            this.secureConnection = secureConnection;
            this.firstPage = this.load(this.offset, this.limit);
            this.hasMore = !this.firstPage.elements().isEmpty();
        }

        @Override
        protected HttpSecureConnection getSecureConnection() {
            return this.secureConnection;
        }

        @Override
        protected PageableEnumerator.PagedResponse<Resource> load(int offset, int limit) throws IOException {
            if (this.firstPage != null) {
                PageableEnumerator.PagedResponse<Resource> page = this.firstPage;
                this.firstPage = null;
                if (offset == 0) {
                    return page;
                }
            }
            HashMap<String, String> headers = new HashMap<String, String>(2);
            headers.put("Accept", "application/json");
            String request = RestApi.V2.getReqRoot() + "/apps/" + this.appId + "/devices/" + this.deviceId + "/resources?offset=" + offset + "&limit=" + limit;
            this.hasMore = false;
            try {
                JSONObject response = this.get(headers, request);
                return ResourceResponse.fromJson(response, this.appId, this.secureConnection);
            }
            catch (GeneralSecurityException e) {
                throw new IOException("GET " + request + ": " + e.getMessage());
            }
            catch (JSONException e) {
                throw new IOException("GET " + request + ": " + e.getMessage());
            }
        }
    }
}

