/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client;

import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;

public class HttpResponse {
    private final int status;
    private final byte[] data;
    private final Map<String, List<String>> headers;

    public HttpResponse(int responseCode, byte[] data, Map<String, List<String>> headers) {
        this.status = responseCode;
        this.data = data;
        this.headers = headers;
    }

    public int getStatus() {
        return this.status;
    }

    public byte[] getData() {
        return this.data;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public String getVerboseStatus(String method, String path) {
        StringBuilder builder = new StringBuilder();
        if (method != null) {
            builder.append(method).append(' ');
        }
        if (path != null) {
            builder.append(path).append(": ");
        }
        builder.append("HTTP ").append(this.status);
        if ((this.status < 200 || this.status >= 400) && this.data != null && this.data.length > 0) {
            try {
                builder.append(' ').append(new String(this.data, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
        return builder.toString();
    }

    public String toString() {
        return this.getVerboseStatus(null, null);
    }
}

