/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.message;

import com.oracle.iot.client.impl.TimeManager;
import com.oracle.iot.client.impl.util.Base64;
import com.oracle.iot.client.message.AlertMessage;
import com.oracle.iot.client.message.DataItem;
import com.oracle.iot.client.message.DataMessage;
import com.oracle.iot.client.message.MessageParsingException;
import com.oracle.iot.client.message.MessageProperties;
import com.oracle.iot.client.message.RequestMessage;
import com.oracle.iot.client.message.ResourceMessage;
import com.oracle.iot.client.message.ResponseMessage;
import com.oracle.iot.client.message.StatusCode;
import java.io.UnsupportedEncodingException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public abstract class Message {
    public static final String DIAG_CREATED_TIME = "createdTime";
    public static final String DIAG_CLIENT_ADDRESS = "clientAddress";
    final String id;
    private final String clientId;
    final String source;
    final String destination;
    private final Priority priority;
    private final Reliability reliability;
    private final Long eventTime;
    private final MessageProperties properties;
    private String sender;
    private Map<String, Object> diagnostics;
    private Direction direction;
    private Long receivedTime;
    private Long sentTime;
    private long ordinal;
    static AtomicLong ordinalValue = new AtomicLong(0L);
    private static final int BASE_NUMBER_OF_RETRIES;
    private int remainingRetries;
    private static final int indentFactor;
    private static final Logger LOGGER;

    static long nextOrdinal() {
        Long l = ordinalValue.addAndGet(1L);
        if (l == Long.MAX_VALUE) {
            ordinalValue.set(0L);
        }
        return l;
    }

    Message(MessageBuilder<?> builder) {
        this.clientId = builder.clientId != null ? builder.clientId : UUID.randomUUID().toString();
        this.id = builder.id;
        if (builder.source == null || builder.source.length() == 0) {
            throw new IllegalArgumentException("Source cannot be null or empty.");
        }
        this.source = builder.source;
        this.destination = builder.destination == null ? "" : builder.destination;
        this.sender = builder.sender == null ? "" : builder.sender;
        this.eventTime = builder.eventTime == null ? Long.valueOf(TimeManager.currentTimeMillis()) : builder.eventTime;
        this.priority = builder.priority == null ? Priority.LOW : builder.priority;
        this.reliability = builder.reliability == null ? Reliability.BEST_EFFORT : builder.reliability;
        switch (this.reliability) {
            default: {
                this.remainingRetries = BASE_NUMBER_OF_RETRIES;
                break;
            }
            case BEST_EFFORT: {
                this.remainingRetries = BASE_NUMBER_OF_RETRIES * 2;
                break;
            }
            case GUARANTEED_DELIVERY: {
                this.remainingRetries = Integer.MAX_VALUE;
            }
        }
        if (builder.properties == null) {
            MessageProperties.Builder propertyBuilder = new MessageProperties.Builder();
            this.properties = propertyBuilder.build();
        } else {
            this.properties = builder.properties;
        }
        this.diagnostics = builder.diagnostics;
        this.diagnostics = builder.diagnostics != null ? Collections.unmodifiableMap(builder.diagnostics) : null;
        this.direction = builder.direction;
        this.receivedTime = builder.receivedTime;
        this.sentTime = builder.sentTime;
        this.ordinal = Message.nextOrdinal();
    }

    public final String getId() {
        return this.id;
    }

    public abstract Type getType();

    public final String getClientId() {
        return this.clientId;
    }

    public final String getSource() {
        return this.source;
    }

    public final String getDestination() {
        return this.destination;
    }

    public final Priority getPriority() {
        return this.priority;
    }

    public final Reliability getReliability() {
        return this.reliability;
    }

    public final Long getEventTime() {
        return this.eventTime;
    }

    public final MessageProperties getProperties() {
        return this.properties;
    }

    public final String getSender() {
        return this.sender;
    }

    public final long getOrdinal() {
        return this.ordinal;
    }

    public final int getRemainingRetries() {
        return this.reliability == Reliability.GUARANTEED_DELIVERY ? Integer.MAX_VALUE : this.remainingRetries;
    }

    public void setRemainingRetries(int remainingRetries) {
        this.remainingRetries = remainingRetries;
    }

    public final Map<String, Object> getDiagnostics() {
        return this.diagnostics;
    }

    public final Object getDiagnosticValue(String diagName) {
        if (diagName != null && this.diagnostics != null) {
            return this.diagnostics.get(diagName);
        }
        return null;
    }

    public final Direction getDirection() {
        return this.direction;
    }

    public final Long getReceivedTime() {
        return this.receivedTime;
    }

    public final Long getSentTime() {
        return this.sentTime;
    }

    public String toString() {
        return this.toJson().toString();
    }

    public JSONObject toJson() {
        return Utils.commonFieldsToJson(this);
    }

    public static JSONArray toJson(List<? extends Message> messages) {
        JSONArray jsonArray = new JSONArray();
        for (Message message : messages) {
            if (message == null) continue;
            jsonArray.put(message.toJson());
        }
        return jsonArray;
    }

    public static JSONArray toJson(List<Message> messages, boolean expand) {
        JSONArray jsonArray = new JSONArray();
        for (Message message : messages) {
            if (message == null) continue;
            if (expand) {
                jsonArray.put(message.toJson());
                continue;
            }
            JSONObject jsonObject = Utils.commonFieldsToJson(message, false);
            jsonArray.put(jsonObject);
        }
        return jsonArray;
    }

    public static List<Message> fromJson(byte[] messagesByteArray) {
        String jsonString;
        if (messagesByteArray == null) {
            throw new MessageParsingException("message.byteArray.null");
        }
        try {
            jsonString = new String(messagesByteArray, "UTF-8");
        }
        catch (UnsupportedEncodingException cannot_happen) {
            throw new RuntimeException(cannot_happen);
        }
        return Message.fromJson(jsonString);
    }

    public static List<Message> fromJson(String jsonString) {
        if (jsonString == null) {
            throw new MessageParsingException("message.jsonString.null");
        }
        try {
            return Message.fromJson(new JSONTokener(jsonString).nextValue());
        }
        catch (JSONException e) {
            throw new MessageParsingException(e);
        }
    }

    public static List<Message> fromJson(Object structure) {
        if (structure == null) {
            throw new MessageParsingException("message.structure.null");
        }
        ArrayList<Message> messageCollection = new ArrayList<Message>();
        if (structure instanceof JSONArray) {
            JSONArray jsonArray = (JSONArray)structure;
            int size = jsonArray.length();
            for (int i = 0; i < size; ++i) {
                JSONObject jsonObject = jsonArray.optJSONObject(i);
                try {
                    messageCollection.add(Message.getMessage(jsonObject));
                    continue;
                }
                catch (MessageParsingException mpe) {
                    if (mpe.getErrorCode() == 1019) continue;
                    throw mpe;
                }
                catch (Exception e) {
                    throw new MessageParsingException("message.parsing.unknown", e);
                }
            }
        } else if (structure instanceof JSONObject) {
            JSONObject jsonObject = (JSONObject)structure;
            messageCollection.add(Message.getMessage(jsonObject));
        }
        return messageCollection;
    }

    public static List<MessageBuilder> createBuilderFromJson(byte[] messagesByteArray) {
        Object structure;
        if (messagesByteArray == null) {
            throw new MessageParsingException("message.byteArray.null");
        }
        try {
            structure = new JSONTokener(new String(messagesByteArray, "UTF-8")).nextValue();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (JSONException e) {
            throw new MessageParsingException(e);
        }
        return Message.createBuilderFromJson(structure);
    }

    private static List<MessageBuilder> createBuilderFromJson(Object structure) {
        if (structure == null) {
            throw new MessageParsingException("message.structure.null");
        }
        ArrayList<MessageBuilder> messageBuilderList = new ArrayList<MessageBuilder>();
        if (structure instanceof JSONArray) {
            JSONArray jsonArray = (JSONArray)structure;
            int size = jsonArray.length();
            for (int i = 0; i < size; ++i) {
                JSONObject jsonObject = jsonArray.optJSONObject(i);
                try {
                    messageBuilderList.add(Message.getMessageBuilder(jsonObject));
                    continue;
                }
                catch (Exception e) {
                    if (e instanceof MessageParsingException) {
                        throw (MessageParsingException)e;
                    }
                    throw new MessageParsingException("message.parsing.unknown", e);
                }
            }
        } else if (structure instanceof JSONObject) {
            JSONObject jsonObject = (JSONObject)structure;
            messageBuilderList.add(Message.getMessageBuilder(jsonObject));
        }
        return messageBuilderList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Message message = (Message)o;
        if (this.id == null ? message.id != null : !this.id.equals(message.id)) {
            return false;
        }
        return this.clientId.equals(message.clientId);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + this.clientId.hashCode();
        return result;
    }

    private static Message getMessage(JSONObject jsonObject) {
        return Message.getMessageBuilder(jsonObject).build();
    }

    private static MessageBuilder getMessageBuilder(JSONObject jsonObject) {
        Type type;
        if (jsonObject == null) {
            throw new MessageParsingException("message.structure.null");
        }
        String t = jsonObject.optString("type", null);
        if (t == null) {
            throw new MessageParsingException("message.type.null");
        }
        try {
            type = Type.valueOf(t);
        }
        catch (IllegalArgumentException e) {
            throw new MessageParsingException("message.type.illegal", e);
        }
        switch (type) {
            case REQUEST: {
                return new RequestMessage.Builder().fromJson(jsonObject);
            }
            case RESPONSE: {
                return new ResponseMessage.Builder().fromJson(jsonObject);
            }
            case RESOURCE: {
                return new ResourceMessage.Builder().fromJson(jsonObject);
            }
            case DATA: {
                return new DataMessage.Builder().fromJson(jsonObject);
            }
            case ALERT: {
                return new AlertMessage.Builder().fromJson(jsonObject);
            }
        }
        throw new MessageParsingException("message.type.wrong");
    }

    public static String prettyPrintJson(JSONObject json) {
        if (json == null) {
            return "{}";
        }
        try {
            return json.toString(indentFactor);
        }
        catch (JSONException e) {
            Message.getLogger().log(Level.SEVERE, e.getMessage());
            return e.getMessage();
        }
    }

    public static String prettyPrintJson(JSONArray json) {
        if (json == null) {
            return "{}";
        }
        try {
            return json.toString(indentFactor);
        }
        catch (JSONException e) {
            Message.getLogger().log(Level.SEVERE, e.getMessage());
            return e.getMessage();
        }
    }

    public static String prettyPrintJson(String jsonString) {
        if (jsonString == null || jsonString.length() == 0) {
            return "{}";
        }
        try {
            JSONTokener tokener = new JSONTokener(jsonString);
            Object obj = tokener.nextValue();
            if (obj instanceof JSONObject) {
                return Message.prettyPrintJson((JSONObject)obj);
            }
            if (obj instanceof JSONArray) {
                return Message.prettyPrintJson((JSONArray)obj);
            }
            return jsonString;
        }
        catch (JSONException e) {
            return jsonString;
        }
    }

    public static String prettyPrintJson(byte[] json) {
        String jsonString;
        if (json == null || json.length == 0) {
            return "{}";
        }
        try {
            jsonString = new String(json, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return Message.prettyPrintJson(jsonString);
    }

    private static Logger getLogger() {
        return LOGGER;
    }

    static {
        int max_retries = Integer.getInteger("oracle.iot.client.device.dispatcher_base_number_of_retries", 3);
        BASE_NUMBER_OF_RETRIES = max_retries > 3 ? max_retries : 3;
        String propertyValue = System.getProperty("oracle.iot.client.pretty_print_messages", "true");
        boolean prettyPrint = Boolean.parseBoolean(propertyValue);
        indentFactor = prettyPrint ? 4 : 0;
        LOGGER = Logger.getLogger("oracle.iot.client");
    }

    static final class Utils {
        static final int MAX_KEY_LENGTH = 2048;
        static final int MAX_STRING_VALUE_LENGTH = 65536;
        private static final ThreadLocal<SimpleDateFormat> DATE_FORMATTER = new ThreadLocal<SimpleDateFormat>(){

            @Override
            protected SimpleDateFormat initialValue() {
                return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX", Locale.ROOT);
            }
        };

        private Utils() {
        }

        public static void checkKeyLengthAndThrowMPE(String key, String message) {
            try {
                if (key.getBytes("UTF-8").length >= 2048) {
                    throw new MessageParsingException(message);
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }

        public static void checkValueLengthAndThrowMPE(String value, String message) {
            try {
                if (value.getBytes("UTF-8").length >= 65536) {
                    throw new MessageParsingException(message);
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }

        public static void checkNullValueAndThrowMPE(Object value, String message) {
            if (value == null) {
                throw new MessageParsingException(message);
            }
        }

        public static void checkNullOrEmptyStringThrowMPE(String value, String message) {
            if (value == null || value.length() == 0) {
                throw new MessageParsingException(message);
            }
        }

        public static void checkKeyLengthAndThrowIAE(String key, String message) {
            try {
                if (key.getBytes("UTF-8").length >= 2048) {
                    throw new IllegalArgumentException(message + " is longer than " + 2048 + " bytes.");
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }

        public static void checkValueLengthAndThrowIAE(String value, String message) {
            if (value == null) {
                return;
            }
            try {
                if (value.getBytes("UTF-8").length >= 65536) {
                    throw new IllegalArgumentException(message + " is longer than " + 65536 + " bytes.");
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }

        public static void checkValuesLengthAndThrowIAE(Collection<String> values, String message) {
            if (values == null) {
                return;
            }
            for (String value : values) {
                try {
                    if (value.getBytes("UTF-8").length < 65536) continue;
                    throw new IllegalArgumentException(message + " contains value longer than " + 65536 + " bytes.");
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
        }

        public static void checkNullValuesThrowsNPE(Collection<String> values, String message) {
            if (values == null) {
                return;
            }
            for (String value : values) {
                if (value != null) continue;
                throw new NullPointerException(message + " contains null value");
            }
        }

        public static void checkNullValueThrowsNPE(Object checkedValue, String message) {
            if (checkedValue == null) {
                throw new NullPointerException(message + " is null");
            }
        }

        public static void checkEmptyStringThrowsIAE(String checkedValue, String message) {
            if (checkedValue.length() == 0) {
                throw new IllegalArgumentException(message + " is empty");
            }
        }

        public static int hashCodeByteArray(byte[] a) {
            if (a == null) {
                return 0;
            }
            int result = 1;
            for (byte element : a) {
                result = 31 * result + element;
            }
            return result;
        }

        public static boolean isAsciiPrintable(String text) {
            if (text == null) {
                return true;
            }
            for (char ch : text.toCharArray()) {
                if (ch >= ' ' && ch <= '~') continue;
                return false;
            }
            return true;
        }

        public static boolean isAsciiPrintable(Collection<String> texts) {
            if (texts == null) {
                return true;
            }
            for (String text : texts) {
                if (Utils.isAsciiPrintable(text)) continue;
                return false;
            }
            return true;
        }

        public static boolean isHttpHeaderAsciiPrintable(String name, List<String> values) {
            return Utils.isAsciiPrintable(name) && Utils.isAsciiPrintable(values);
        }

        public static JSONObject commonFieldsToJson(Message message) {
            return Utils.commonFieldsToJson(message, true);
        }

        public static JSONObject commonFieldsToJson(Message message, boolean expand) {
            JSONObject jsonObject = new JSONObject();
            try {
                MessageProperties messageProperties;
                if (message.getId() != null) {
                    jsonObject.put("id", message.getId());
                }
                if (message.getClientId() != null) {
                    jsonObject.put("clientId", message.getClientId());
                }
                jsonObject.put("source", message.getSource());
                jsonObject.put("destination", message.getDestination());
                jsonObject.put("priority", message.getPriority().toString());
                jsonObject.put("reliability", message.getReliability().toString());
                jsonObject.put("eventTime", message.getEventTime());
                jsonObject.put("sender", message.getSender());
                jsonObject.put("type", message.getType().name());
                if (expand && (messageProperties = message.getProperties()) != null && !messageProperties.getAllProperties().isEmpty()) {
                    jsonObject.put("properties", messageProperties.toJson());
                }
                if (message.getDirection() != null) {
                    jsonObject.put("direction", message.getDirection().name());
                }
                if (message.getReceivedTime() != null) {
                    jsonObject.put("receivedTime", message.getReceivedTime());
                }
                if (message.getSentTime() != null) {
                    jsonObject.put("sentTime", message.getSentTime());
                }
                if (message.getDiagnostics() != null) {
                    jsonObject.put("diagnostics", Utils.toJson(message.getDiagnostics()));
                }
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
            return jsonObject;
        }

        public static JSONObject toJson(Map<String, Object> map) {
            JSONObject jsonObject = new JSONObject();
            Set<Map.Entry<String, Object>> entries = map.entrySet();
            for (Map.Entry<String, Object> entry : entries) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if (!(value instanceof Boolean) && !(value instanceof Number) && !(value instanceof String)) continue;
                try {
                    jsonObject.put(key, value);
                }
                catch (JSONException e) {
                    throw new RuntimeException(e);
                }
            }
            return jsonObject;
        }

        public static String dateToString(Date date) {
            SimpleDateFormat dateFormat = DATE_FORMATTER.get();
            return dateFormat.format(date);
        }

        public static Date stringToDate(String date) {
            SimpleDateFormat dateFormat = DATE_FORMATTER.get();
            return dateFormat.parse(date, new ParsePosition(0));
        }

        static void dataFromJson(JSONObject jsonObject, List<DataItem<?>> items) {
            try {
                JSONObject payload = jsonObject.optJSONObject("payload");
                if (payload == null) {
                    return;
                }
                JSONObject data = payload.getJSONObject("data");
                Iterator<String> keys = data.keys();
                while (keys.hasNext()) {
                    String key = keys.next();
                    Object value = data.opt(key);
                    Utils.addItem(key, value, items);
                }
            }
            catch (JSONException e) {
                throw new MessageParsingException(e);
            }
        }

        private static List<DataItem<?>> addItem(String key, Object newValue, List<DataItem<?>> dataItems) {
            if (newValue instanceof Number) {
                dataItems.add(new DataItem(key, ((Number)newValue).doubleValue()));
            } else if (newValue instanceof String) {
                dataItems.add(new DataItem(key, (String)newValue));
            } else if (newValue instanceof Boolean) {
                dataItems.add(new DataItem(key, (Boolean)newValue));
            }
            return dataItems;
        }

        static JSONObject dataToJson(Message message, List<DataItem<?>> items, String format, String description, String severity) {
            JSONObject jsonObject = Utils.commonFieldsToJson(message);
            JSONObject payload = new JSONObject();
            JSONObject dataItems = new JSONObject();
            try {
                for (DataItem<?> item : items) {
                    switch (item.getType()) {
                        case STRING: 
                        case BOOLEAN: 
                        case DOUBLE: {
                            dataItems.put(item.getKey(), item.getValue());
                        }
                    }
                }
                payload.put("data", dataItems);
                if (format != null) {
                    payload.put("format", format);
                }
                if (description != null) {
                    payload.put("description", description);
                }
                if (severity != null) {
                    payload.put("severity", severity);
                }
                jsonObject.put("payload", payload);
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
            return jsonObject;
        }

        static JSONObject bodyToJson(Message message, Map<String, String> params, Type type, StatusCode statusCode, String method, String url, String requestId, Map<String, List<String>> headers, byte[] body) {
            JSONObject jsonObject = Utils.commonFieldsToJson(message);
            JSONObject payload = new JSONObject();
            JSONObject headerObject = new JSONObject();
            try {
                if (type != null) {
                    jsonObject.put("type", type.name());
                }
                if (statusCode != null) {
                    payload.put("statusCode", statusCode.getCode());
                }
                if (method != null) {
                    payload.put("method", method);
                }
                if (url != null) {
                    payload.put("url", url);
                }
                if (requestId != null) {
                    payload.put("requestId", requestId);
                }
                Set<Map.Entry<String, List<String>>> entries = headers.entrySet();
                for (Map.Entry<String, List<String>> entry : entries) {
                    JSONArray headerValues = new JSONArray();
                    String key = entry.getKey();
                    List<String> values = entry.getValue();
                    for (String v : values) {
                        headerValues.put(v);
                    }
                    headerObject.put(key, headerValues);
                }
                payload.put("headers", headerObject);
                if (params != null) {
                    JSONObject paramsObject = new JSONObject();
                    for (Map.Entry<String, String> entry : params.entrySet()) {
                        paramsObject.put(entry.getKey(), entry.getValue());
                    }
                    payload.put("params", paramsObject);
                }
                try {
                    payload.put("body", new String(Base64.getEncoder().encode(body), "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
                jsonObject.put("payload", payload);
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
            return jsonObject;
        }
    }

    public static abstract class MessageBuilder<T extends MessageBuilder<T>> {
        String id;
        String clientId;
        String source;
        String destination;
        Priority priority;
        Reliability reliability;
        Long eventTime;
        MessageProperties properties;
        String sender;
        Map<String, Object> diagnostics;
        Direction direction;
        Long receivedTime;
        Long sentTime;

        protected abstract T self();

        public final T id(String id) {
            this.id = id;
            return this.self();
        }

        public final T clientId(String id) {
            this.clientId = id;
            return this.self();
        }

        public final T source(String source) {
            this.source = source;
            return this.self();
        }

        public final T destination(String destination) {
            this.destination = destination;
            return this.self();
        }

        public final T priority(Priority priority) {
            this.priority = priority;
            return this.self();
        }

        public final T reliability(Reliability reliability) {
            this.reliability = reliability;
            return this.self();
        }

        public final T eventTime(Long eventTime) {
            if (eventTime != null) {
                this.eventTime = eventTime;
            }
            return this.self();
        }

        public final T eventTime(long eventTime) {
            this.eventTime = eventTime;
            return this.self();
        }

        public final T properties(MessageProperties properties) {
            this.properties = properties;
            return this.self();
        }

        public final T sender(String sender) {
            this.sender = sender;
            return this.self();
        }

        public final T direction(Direction direction) {
            this.direction = direction;
            return this.self();
        }

        public final T receivedTime(Long time) {
            this.receivedTime = time;
            return this.self();
        }

        public final T sentTime(Long time) {
            this.sentTime = time;
            return this.self();
        }

        public final T diagnostic(String name, Object value) {
            if (this.diagnostics == null) {
                this.diagnostics = new HashMap<String, Object>();
            }
            this.diagnostics.put(name, value);
            return this.self();
        }

        public T fromJson(JSONObject jsonObject) {
            try {
                Object value;
                String direction;
                this.id(jsonObject.optString("id", null));
                this.clientId = jsonObject.optString("clientId", null);
                String source = jsonObject.optString("source", null);
                String destination = jsonObject.optString("destination", null);
                String sender = jsonObject.optString("sender", null);
                if (!(source != null && source.length() != 0 || destination != null && destination.length() != 0)) {
                    throw new MessageParsingException("message.source.destination.null");
                }
                this.source(source);
                this.destination(destination);
                this.sender(sender);
                String priority = jsonObject.optString("priority", null);
                Utils.checkNullValueAndThrowMPE(priority, "message.priority.null");
                try {
                    this.priority(Priority.valueOf(priority));
                }
                catch (IllegalArgumentException e) {
                    throw new MessageParsingException("message.priority.illegal", e);
                }
                String reliability = jsonObject.optString("reliability", null);
                Utils.checkNullValueAndThrowMPE(reliability, "message.reliability.null");
                try {
                    this.reliability(Reliability.valueOf(reliability));
                }
                catch (IllegalArgumentException e) {
                    throw new MessageParsingException("message.reliability.illegal", e);
                }
                long eventTime = jsonObject.optLong("eventTime", -1L);
                if (eventTime == -1L) {
                    throw new MessageParsingException("message.eventTime.wrong");
                }
                this.eventTime(eventTime);
                MessageProperties.Builder properties = new MessageProperties.Builder();
                JSONObject propertiesObject = jsonObject.optJSONObject("properties");
                if (propertiesObject != null) {
                    Iterator<String> keys = propertiesObject.keys();
                    while (keys.hasNext()) {
                        String key = keys.next();
                        Utils.checkKeyLengthAndThrowMPE(key, "message.property.key.long");
                        JSONArray keyValues = propertiesObject.optJSONArray(key);
                        if (keyValues == null) {
                            List<String> values = Collections.emptyList();
                            properties.addValues(key, values);
                            continue;
                        }
                        for (int j = 0; j < keyValues.length(); ++j) {
                            String value2 = keyValues.optString(j, null);
                            Utils.checkValueLengthAndThrowMPE(value2, "message.property.value.long");
                            properties.addValue(key, value2);
                        }
                    }
                }
                this.properties(properties.build());
                JSONObject diagnosticsObject = jsonObject.optJSONObject("diagnostics");
                if (diagnosticsObject != null) {
                    Iterator<String> keys = diagnosticsObject.keys();
                    while (keys.hasNext()) {
                        String key = keys.next();
                        Object value3 = diagnosticsObject.get(key);
                        if (value3 instanceof Number || value3 instanceof Boolean) {
                            this.diagnostic(key, value3);
                            continue;
                        }
                        this.diagnostic(key, value3.toString());
                    }
                }
                if ((direction = jsonObject.optString("direction", null)) != null) {
                    try {
                        this.direction(Direction.valueOf(direction));
                    }
                    catch (IllegalArgumentException e) {
                        throw new MessageParsingException("message.direction.wrong", e);
                    }
                }
                if ((value = jsonObject.opt("receivedTime")) != null && value instanceof Number) {
                    this.receivedTime(((Number)value).longValue());
                }
                if ((value = jsonObject.opt("sentTime")) != null && value instanceof Number) {
                    this.sentTime(((Number)value).longValue());
                }
            }
            catch (JSONException e) {
                throw new MessageParsingException(e);
            }
            return this.self();
        }

        public abstract Message build();
    }

    public static enum Direction {
        FROM_DEVICE,
        TO_DEVICE;

    }

    public static enum Type {
        DATA("DATA"),
        REQUEST("REQUEST"),
        RESPONSE("RESPONSE"),
        RESOURCE("RESOURCES_REPORT"),
        ALERT("ALERT");

        private final String alias;

        private Type(String alias) {
            this.alias = alias;
        }

        public String alias() {
            return this.alias;
        }
    }

    public static enum Reliability {
        NO_GUARANTEE(0),
        BEST_EFFORT(1),
        GUARANTEED_DELIVERY(2);

        private final int value;

        private Reliability(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum Priority {
        LOWEST(0),
        LOW(1),
        MEDIUM(2),
        HIGH(3),
        HIGHEST(4);

        private final int value;

        private Priority(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

