/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.iot.client.impl.trust;

import com.oracle.iot.client.impl.trust.SelfSignedX509CertificateFactory;
import com.oracle.iot.client.impl.trust.TrustedAssetsManagerBase;
import com.oracle.iot.client.impl.util.Base64;
import com.oracle.iot.client.trust.TrustException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class DefaultTrustedAssetsManager
extends TrustedAssetsManagerBase {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final String IOT_SCHEME = "iotcs";
    private static final String IOT_SCHEME_PREFIX = "iotcs".concat("+");
    private static final String EP_NOT_SET = "__EP_NOT_SET__";
    private X509Certificate certificate;
    private KeyStore taStore;
    private KeyStore.ProtectionParameter taProtection;
    private File taStoreFile;
    private KeyStore.Builder taStoreBuilder;
    private static final Logger LOGGER = Logger.getLogger("oracle.iot.client");

    static DefaultTrustedAssetsManager create(File file, KeyStore.PasswordProtection password, Object context) throws TrustException {
        DefaultTrustedAssetsManager trustedAssetsManager = new DefaultTrustedAssetsManager();
        trustedAssetsManager.load(file, password);
        return trustedAssetsManager;
    }

    static DefaultTrustedAssetsManager create(KeyStore.Builder builder, Object context) throws TrustException {
        DefaultTrustedAssetsManager trustedAssetsManager = new DefaultTrustedAssetsManager();
        trustedAssetsManager.load(builder);
        return trustedAssetsManager;
    }

    public DefaultTrustedAssetsManager(String path, String password, Object context) throws TrustException {
        this.load(path, password);
    }

    private DefaultTrustedAssetsManager() {
    }

    private void load(KeyStore.Builder builder) throws TrustException {
        try {
            this.taStoreFile = null;
            this.taStore = builder.getKeyStore();
            this.taProtection = null;
            this.taStoreBuilder = builder;
            this.load();
        }
        catch (Exception e) {
            DefaultTrustedAssetsManager.getLogger().log(Level.SEVERE, "Error loading trusted assets...", e);
            throw new TrustException("Error loading trusted assets...", e);
        }
    }

    private void load(String path, String password) throws TrustException {
        if (path == null) {
            throw new TrustException("Store path is null");
        }
        if (password == null) {
            throw new TrustException("Store password is null");
        }
        this.load(new File(path), new KeyStore.PasswordProtection(password.toCharArray()));
    }

    private void load(File file, KeyStore.PasswordProtection password) throws TrustException {
        FileInputStream fis = null;
        try {
            this.taStoreFile = file;
            String keyStoreType = KeyStore.getDefaultType();
            if (keyStoreType.equals("jks")) {
                keyStoreType = "jceks";
            }
            this.taStore = KeyStore.getInstance(keyStoreType);
            this.taProtection = password;
            fis = new FileInputStream(this.taStoreFile);
            this.taStore.load(fis, ((KeyStore.PasswordProtection)this.taProtection).getPassword());
            this.load();
        }
        catch (FileNotFoundException fnfe) {
            DefaultTrustedAssetsManager.getLogger().log(Level.SEVERE, "File not found: " + file);
            throw new TrustException("Error loading trusted assets...", fnfe);
        }
        catch (IOException ie) {
            DefaultTrustedAssetsManager.getLogger().log(Level.SEVERE, "Invalid trusted assets");
            throw new TrustException("Error loading trusted assets...", ie);
        }
        catch (Exception e) {
            DefaultTrustedAssetsManager.getLogger().log(Level.SEVERE, "Error loading trusted assets file " + file, e);
            throw new TrustException("Error loading trusted assets...", e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    private void load() throws GeneralSecurityException, URISyntaxException, UnsupportedEncodingException {
        URI uri;
        String alias;
        this.trustAnchors = new HashSet();
        Enumeration<String> aliases = this.taStore.aliases();
        while (aliases.hasMoreElements()) {
            alias = aliases.nextElement();
            if (!this.taStore.entryInstanceOf(alias, KeyStore.SecretKeyEntry.class)) continue;
            uri = null;
            try {
                uri = new URI(alias);
            }
            catch (URISyntaxException ex) {
                // empty catch block
            }
            if (uri == null || uri.getScheme() == null || !IOT_SCHEME.regionMatches(0, uri.getScheme(), 0, IOT_SCHEME.length())) continue;
            this.parseURI(uri);
            KeyStore.SecretKeyEntry entry = (KeyStore.SecretKeyEntry)this.taStore.getEntry(alias, this.getProtection(alias));
            this.sharedSecret = entry.getSecretKey();
            break;
        }
        aliases = this.taStore.aliases();
        while (aliases.hasMoreElements()) {
            alias = aliases.nextElement();
            if (this.taStore.entryInstanceOf(alias, KeyStore.PrivateKeyEntry.class)) {
                uri = null;
                try {
                    uri = new URI(alias);
                }
                catch (URISyntaxException ex) {
                    // empty catch block
                }
                if (uri == null || uri.getScheme() == null || !IOT_SCHEME.regionMatches(0, uri.getScheme(), 0, IOT_SCHEME.length())) continue;
                this.parseURI(uri);
                KeyStore.ProtectionParameter password = this.getProtection(alias);
                if (password instanceof KeyStore.PasswordProtection) {
                    password = this.derivePassword((KeyStore.PasswordProtection)password);
                }
                KeyStore.PrivateKeyEntry entry = (KeyStore.PrivateKeyEntry)this.taStore.getEntry(alias, password);
                this.privateKey = entry.getPrivateKey();
                this.certificate = (X509Certificate)entry.getCertificate();
                continue;
            }
            if (!this.taStore.entryInstanceOf(alias, KeyStore.TrustedCertificateEntry.class)) continue;
            KeyStore.TrustedCertificateEntry entry = (KeyStore.TrustedCertificateEntry)this.taStore.getEntry(alias, null);
            Certificate certificate = entry.getTrustedCertificate();
            this.trustAnchors.add((X509Certificate)certificate);
        }
        if (this.serverHost == null || this.serverPort == -1) {
            DefaultTrustedAssetsManager.getLogger().log(Level.SEVERE, "Trusted assets not properly provisioned");
            throw new GeneralSecurityException("Trusted assets not properly provisioned");
        }
    }

    private void parseURI(URI uri) throws GeneralSecurityException, UnsupportedEncodingException {
        String serverHost = uri.getHost();
        if (this.serverHost != null && serverHost != null && !this.serverHost.equals(serverHost)) {
            throw new KeyStoreException("Mismatching server host...");
        }
        this.serverHost = serverHost;
        int serverPort = uri.getPort();
        if (this.serverPort >= 0 && serverPort >= 0 && this.serverPort != serverPort) {
            throw new KeyStoreException("Mismatching server port...");
        }
        this.serverPort = serverPort;
        String serverScheme = uri.getScheme();
        if (serverScheme != null && IOT_SCHEME_PREFIX.regionMatches(0, uri.getScheme(), 0, IOT_SCHEME_PREFIX.length())) {
            serverScheme = serverScheme.substring(IOT_SCHEME_PREFIX.length());
        } else if (serverScheme == null || IOT_SCHEME.equals(serverScheme)) {
            serverScheme = "https";
        }
        if (this.serverScheme != null && serverScheme != null && !this.serverScheme.equals(serverScheme)) {
            throw new KeyStoreException("Mismatching server scheme...");
        }
        this.serverScheme = serverScheme;
        if (!"https".equals(this.serverScheme)) {
            System.setProperty("com.oracle.iot.client.disable_long_polling", "true");
        } else {
            String value = System.getProperty("com.oracle.iot.client.disable_long_polling");
            if ("".equals(value)) {
                System.setProperty("com.oracle.iot.client.disable_long_polling", "true");
            }
        }
        String clientId = uri.getUserInfo();
        if (clientId != null) {
            clientId = URLDecoder.decode(clientId, UTF_8.name());
        }
        if (this.clientId != null && clientId != null && !this.clientId.equals(clientId)) {
            throw new KeyStoreException("Mismatching client Id...");
        }
        this.clientId = clientId;
        String endpointId = uri.getFragment();
        if (endpointId != null && EP_NOT_SET.equals(endpointId = URLDecoder.decode(endpointId, UTF_8.name()))) {
            endpointId = null;
        }
        if (this.endpointId != null && endpointId != null && !this.endpointId.equals(endpointId)) {
            throw new KeyStoreException("Mismatching endpoint Id...");
        }
        if (this.endpointId == null && !EP_NOT_SET.equals(this.endpointId)) {
            this.endpointId = endpointId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void store() throws Exception {
        if (this.privateKey != null) {
            KeyStore.PrivateKeyEntry entry = new KeyStore.PrivateKeyEntry(this.privateKey, new Certificate[]{this.certificate});
            URI uri = new URI(IOT_SCHEME_PREFIX + this.serverScheme, DefaultTrustedAssetsManager.caseEncode(this.clientId), this.serverHost, this.serverPort, null, null, DefaultTrustedAssetsManager.caseEncode(this.endpointId != null ? this.endpointId : EP_NOT_SET));
            String alias = uri.toString();
            KeyStore.ProtectionParameter password = this.getProtection(alias);
            if (password instanceof KeyStore.PasswordProtection) {
                password = this.derivePassword((KeyStore.PasswordProtection)password);
            }
            this.taStore.setEntry(alias, entry, password);
        } else {
            URI uri = new URI(IOT_SCHEME_PREFIX + this.serverScheme, DefaultTrustedAssetsManager.caseEncode(this.clientId), this.serverHost, this.serverPort, null, null, DefaultTrustedAssetsManager.caseEncode(this.endpointId != null ? this.endpointId : EP_NOT_SET));
            this.taStore.deleteEntry(uri.toString());
        }
        if (this.taStoreFile != null) {
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(this.taStoreFile);
                this.taStore.store(fos, ((KeyStore.PasswordProtection)this.taProtection).getPassword());
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private KeyStore.ProtectionParameter getProtection(String alias) throws KeyStoreException {
        return this.taStoreBuilder != null ? this.taStoreBuilder.getProtectionParameter(alias) : this.taProtection;
    }

    private byte[] char2bytes(char[] chars) {
        CharBuffer charBuffer = CharBuffer.wrap(chars);
        ByteBuffer byteBuffer = Charset.forName("UTF-8").encode(charBuffer);
        byte[] bytes = Arrays.copyOfRange(byteBuffer.array(), byteBuffer.position(), byteBuffer.limit());
        Arrays.fill(byteBuffer.array(), (byte)0);
        return bytes;
    }

    private KeyStore.PasswordProtection derivePassword(KeyStore.PasswordProtection password) throws GeneralSecurityException {
        if (this.sharedSecret != null) {
            Mac mac;
            byte[] data = this.char2bytes(password.getPassword());
            String algorithm = "HmacSHA256";
            try {
                mac = Mac.getInstance(algorithm, this.taStore.getProvider());
            }
            catch (NoSuchAlgorithmException nsae) {
                mac = Mac.getInstance(algorithm);
            }
            mac.init(this.sharedSecret);
            mac.update(data);
            byte[] digest = mac.doFinal();
            String pass = Base64.getEncoder().encodeToString(digest);
            Arrays.fill(data, (byte)0);
            return new KeyStore.PasswordProtection(pass.toCharArray());
        }
        return password;
    }

    @Override
    public PublicKey getPublicKey() {
        if (this.publicKey == null && this.certificate == null) {
            throw new IllegalStateException("Key pair not yet generated or certificate not yet assigned.");
        }
        return this.publicKey != null ? this.publicKey : this.certificate.getPublicKey();
    }

    @Override
    public void setEndPointCredentials(String endpointId, byte[] certificate) throws TrustException {
        block11: {
            if (this.privateKey == null) {
                throw new IllegalStateException("Private key not yet generated.");
            }
            if (this.endpointId != null) {
                throw new IllegalStateException("EndpointId already assigned.");
            }
            if (endpointId == null) {
                throw new NullPointerException("EndpointId can't be null.");
            }
            if (certificate == null) {
                throw new NullPointerException("Certificate can't be null.");
            }
            this.endpointId = endpointId;
            try {
                if (certificate.length != 0) {
                    CertificateFactory factory;
                    try {
                        factory = CertificateFactory.getInstance("X.509", this.taStore.getProvider());
                    }
                    catch (CertificateException ce) {
                        factory = CertificateFactory.getInstance("X.509");
                    }
                    this.certificate = (X509Certificate)factory.generateCertificate(new ByteArrayInputStream(certificate));
                    break block11;
                }
                this.certificate = DefaultTrustedAssetsManager.generateSelfSignedCertificate(this.privateKey, this.publicKey, this.clientId);
            }
            catch (Exception e) {
                throw new TrustException("Error generating certificate...", e);
            }
        }
        try {
            this.store();
        }
        catch (Exception e) {
            throw new TrustException("Error storing the trusted assets...", e);
        }
    }

    @Override
    public byte[] getEndpointCertificate() {
        if (this.certificate == null) {
            throw new IllegalStateException("Endpoint certificate not assigned.");
        }
        try {
            if (!DefaultTrustedAssetsManager.isSelfSigned(this.certificate)) {
                return this.certificate.getEncoded();
            }
            return new byte[0];
        }
        catch (CertificateEncodingException e) {
            throw new RuntimeException("Unexpected error retrieving certificate encoding...", e);
        }
    }

    @Override
    public void generateKeyPair(String algorithm, int keySize) throws TrustException {
        KeyPairGenerator keyPairGenerator;
        if (this.endpointId != null) {
            throw new IllegalStateException("Already activated: EndpointId already assigned.");
        }
        if (algorithm == null) {
            throw new NullPointerException("Algorithm cannot be null.");
        }
        if (keySize <= 0) {
            throw new IllegalArgumentException("Key size cannot be negative or 0.");
        }
        try {
            try {
                keyPairGenerator = KeyPairGenerator.getInstance(algorithm, this.taStore.getProvider());
            }
            catch (NoSuchAlgorithmException nsae) {
                keyPairGenerator = KeyPairGenerator.getInstance(algorithm);
            }
        }
        catch (GeneralSecurityException e) {
            throw new TrustException(e.getMessage(), e);
        }
        keyPairGenerator.initialize(keySize);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        this.privateKey = keyPair.getPrivate();
        this.publicKey = keyPair.getPublic();
        try {
            this.certificate = DefaultTrustedAssetsManager.generateSelfSignedCertificate(this.privateKey, this.publicKey, this.clientId);
            this.store();
        }
        catch (GeneralSecurityException e) {
            throw new TrustException(e.getMessage(), e);
        }
        catch (Exception e) {
            throw new TrustException("Error storing the trusted assets...", e);
        }
    }

    @Override
    public byte[] signWithPrivateKey(byte[] data, String algorithm) throws TrustException {
        byte[] sig;
        if (this.privateKey == null) {
            throw new IllegalStateException("Private key not yet generated.");
        }
        if (algorithm == null) {
            throw new NullPointerException("Algorithm cannot be null.");
        }
        if (data == null) {
            throw new NullPointerException("Data cannot be null.");
        }
        try {
            Signature signature;
            try {
                signature = Signature.getInstance(algorithm, this.taStore.getProvider());
            }
            catch (NoSuchAlgorithmException nsae) {
                signature = Signature.getInstance(algorithm);
            }
            signature.initSign(this.privateKey);
            signature.update(data);
            sig = signature.sign();
        }
        catch (GeneralSecurityException e) {
            throw new TrustException("Error signing with private key...", e);
        }
        return sig;
    }

    @Override
    public void reset() throws TrustException {
        this.certificate = null;
        super.reset();
    }

    private static X509Certificate generateSelfSignedCertificate(PrivateKey privateKey, PublicKey publicKey, String clientId) throws GeneralSecurityException {
        if (!(privateKey instanceof RSAPrivateKey) || !(publicKey instanceof RSAPublicKey)) {
            throw new GeneralSecurityException("Unsupported Algorithm");
        }
        Date firstDate = new Date();
        Date lastDate = new Date(firstDate.getTime() + 31536000000L);
        return SelfSignedX509CertificateFactory.generateSelfSignedCertificate((RSAPrivateKey)privateKey, (RSAPublicKey)publicKey, "SHA1WithRSA", clientId, firstDate, lastDate);
    }

    private static boolean isSelfSigned(X509Certificate cert) {
        return cert.getSubjectDN().equals(cert.getIssuerDN());
    }

    private static String caseEncode(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder b = new StringBuilder();
        for (char c : s.toCharArray()) {
            if (Character.isUpperCase(c)) {
                b.append('%').append(Integer.toHexString(c));
                continue;
            }
            b.append(c);
        }
        return b.toString();
    }

    private static Logger getLogger() {
        return LOGGER;
    }

    public static class ProvisioningSupport {
        private KeyStore.Builder taStoreBuilder = null;
        private File taStoreFile = null;
        private String taStorePassword = null;
        private String clientId;
        private String sharedSecret;
        private String serverScheme;
        private String serverHost;
        private int serverPort;
        private String endpointId;
        private PrivateKey privateKey;
        private final Map<String, Certificate> trustAnchors = new HashMap<String, Certificate>();
        private Certificate certificate;

        public static ProvisioningSupport create(KeyStore.Builder taStoreBuilder) {
            return new ProvisioningSupport(taStoreBuilder);
        }

        public static ProvisioningSupport create(File taStoreFile, String taStorePassword) {
            return new ProvisioningSupport(taStoreFile, taStorePassword);
        }

        public static ProvisioningSupport create() {
            return new ProvisioningSupport(new File(System.getProperty("oracle.iot.client.trustedAssetsStore", "trustedAssetsStore.jks")), System.getProperty("oracle.iot.client.trustedAssetsStorePassword"));
        }

        public ProvisioningSupport setServer(String serverScheme, String serverHost, int serverPort) {
            if (serverScheme == null) {
                throw new IllegalArgumentException("Server scheme cannot be null");
            }
            if (serverHost == null) {
                throw new IllegalArgumentException("Server host cannot be null");
            }
            if (serverPort < 0) {
                throw new IllegalArgumentException("Server port cannot be negative");
            }
            this.serverScheme = serverScheme;
            this.serverHost = serverHost;
            this.serverPort = serverPort;
            return this;
        }

        public ProvisioningSupport setEnterpriseClientCredentials(String endpointId, String sharedSecret) {
            if (this.privateKey != null) {
                throw new IllegalStateException("Client cannot be provisioned with both a shared secret and a private key...");
            }
            if (endpointId == null || sharedSecret == null) {
                throw new IllegalArgumentException("Client Id and shared secret cannot be null...");
            }
            this.clientId = endpointId;
            this.endpointId = endpointId;
            this.sharedSecret = sharedSecret;
            return this;
        }

        public ProvisioningSupport setClientCredentials(String clientId, String sharedSecret) {
            if (this.privateKey != null) {
                throw new IllegalStateException("Client cannot be provisioned with both a shared secret and a private key...");
            }
            if (clientId == null || sharedSecret == null) {
                throw new IllegalArgumentException("Client Id and shared secret cannot be null...");
            }
            this.clientId = clientId;
            this.sharedSecret = sharedSecret;
            return this;
        }

        public ProvisioningSupport setClientCredentials(String endpointId, PrivateKey privateKey, Certificate certificate) {
            if (this.sharedSecret != null) {
                throw new IllegalStateException("Client cannot be provisioned with both a shared secret and a private key...");
            }
            if (endpointId == null || privateKey == null || certificate == null) {
                throw new IllegalArgumentException("Endpoint Id, private key and certificate cannot be null...");
            }
            this.clientId = endpointId;
            this.endpointId = endpointId;
            this.privateKey = privateKey;
            this.certificate = certificate;
            return this;
        }

        public ProvisioningSupport addTrustAnchor(String alias, Certificate trustAnchor) {
            if (trustAnchor == null || alias == null) {
                throw new IllegalArgumentException("Trust Anchor or alias cannot be null...");
            }
            this.trustAnchors.put(alias, trustAnchor);
            return this;
        }

        public void provision() throws TrustException {
            try {
                this.store();
            }
            finally {
                this.sharedSecret = null;
                this.privateKey = null;
            }
        }

        private ProvisioningSupport(KeyStore.Builder taStoreBuilder) {
            if (taStoreBuilder == null) {
                throw new IllegalArgumentException("taStoreBuilder cannot be null...");
            }
            this.taStoreBuilder = taStoreBuilder;
        }

        private ProvisioningSupport(File taStoreFile, String taStorePassword) {
            if (taStoreFile == null) {
                throw new IllegalArgumentException("taStoreFile cannot be null...");
            }
            if (taStorePassword == null) {
                throw new IllegalArgumentException("taStorePassword cannot be null...");
            }
            this.taStoreFile = taStoreFile;
            this.taStorePassword = taStorePassword;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void store() throws TrustException {
            block17: {
                try {
                    if (this.taStoreBuilder != null) {
                        KeyStore taStore = this.taStoreBuilder.getKeyStore();
                        this.store(taStore, null, this.taStoreBuilder);
                        break block17;
                    }
                    FileOutputStream fos = null;
                    FileInputStream fis = null;
                    try {
                        String keyStoreType = "jceks";
                        KeyStore taStore = KeyStore.getInstance(keyStoreType);
                        KeyStore.PasswordProtection taProtection = null;
                        if (this.taStorePassword != null) {
                            taProtection = new KeyStore.PasswordProtection(this.taStorePassword.toCharArray());
                        }
                        fis = this.taStoreFile.exists() ? new FileInputStream(this.taStoreFile) : null;
                        taStore.load(fis, taProtection != null ? taProtection.getPassword() : null);
                        fos = new FileOutputStream(this.taStoreFile);
                        this.store(taStore, taProtection, null);
                        taStore.store(fos, taProtection != null ? taProtection.getPassword() : null);
                    }
                    finally {
                        if (fis != null) {
                            try {
                                fis.close();
                            }
                            catch (IOException ioe) {}
                        }
                        if (fos != null) {
                            try {
                                fos.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
                catch (Exception e) {
                    DefaultTrustedAssetsManager.getLogger().log(Level.SEVERE, "Error loading trusted assets...", e);
                    throw new TrustException("Error loading trusted assets...", e);
                }
            }
        }

        private void store(KeyStore taStore, KeyStore.ProtectionParameter password, KeyStore.Builder builder) throws KeyStoreException, URISyntaxException {
            String alias;
            if (this.clientId != null || this.endpointId != null) {
                if (this.sharedSecret != null) {
                    SecretKeySpec keySpec = new SecretKeySpec(this.sharedSecret.getBytes(UTF_8), "Hmac");
                    KeyStore.SecretKeyEntry secretKeyEntry = new KeyStore.SecretKeyEntry(keySpec);
                    URI uri = new URI(IOT_SCHEME_PREFIX + this.serverScheme, DefaultTrustedAssetsManager.caseEncode(this.clientId), this.serverHost, this.serverPort, null, null, DefaultTrustedAssetsManager.caseEncode(this.endpointId));
                    String alias2 = uri.toString();
                    taStore.setEntry(alias2, secretKeyEntry, builder != null ? builder.getProtectionParameter(alias2) : password);
                }
                if (this.privateKey != null) {
                    KeyStore.PrivateKeyEntry entry = new KeyStore.PrivateKeyEntry(this.privateKey, new Certificate[]{this.certificate});
                    URI uRI = new URI(IOT_SCHEME_PREFIX + this.serverScheme, DefaultTrustedAssetsManager.caseEncode(this.clientId), this.serverHost, this.serverPort, null, null, DefaultTrustedAssetsManager.caseEncode(this.endpointId));
                    alias = uRI.toString();
                    taStore.setEntry(alias, entry, builder != null ? builder.getProtectionParameter(alias) : password);
                }
            } else {
                SecureRandom random = new SecureRandom();
                byte[] byArray = new byte[32];
                random.nextBytes(byArray);
                SecretKeySpec keySpec = new SecretKeySpec(byArray, "Hmac");
                KeyStore.SecretKeyEntry entry = new KeyStore.SecretKeyEntry(keySpec);
                URI uri = new URI(IOT_SCHEME_PREFIX + this.serverScheme, null, this.serverHost, this.serverPort, null, null, null);
                String alias3 = uri.toString();
                taStore.setEntry(alias3, entry, builder != null ? builder.getProtectionParameter(alias3) : password);
            }
            if (this.trustAnchors != null && !this.trustAnchors.isEmpty()) {
                for (Map.Entry<String, Certificate> entry : this.trustAnchors.entrySet()) {
                    alias = entry.getKey();
                    Certificate trustAnchor = entry.getValue();
                    KeyStore.TrustedCertificateEntry newEntry = new KeyStore.TrustedCertificateEntry(trustAnchor);
                    taStore.setEntry(alias, newEntry, null);
                }
            }
        }
    }
}

